/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.api.decode.formats.webp;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import org.watermedia.api.decode.Decoder;
import org.watermedia.api.decode.Image;
import org.watermedia.api.decode.formats.webp.WebPCodec;
import org.watermedia.tools.DataTool;

public class WebPDecoder
extends Decoder {
    private static final int RIFF_HEADER = 1380533830;
    private static final int WEBP_HEADER = 1464156752;
    private static final int VP8_CHUNK = 1448097824;
    private static final int VP8L_CHUNK = 1448097868;
    private static final int VP8X_CHUNK = 1448097880;
    private static final int ANIM_CHUNK = 1095649613;
    private static final int ANMF_CHUNK = 1095650630;
    private static final int ALPH_CHUNK = 1095520328;
    private static final int ICCP_CHUNK = 1229144912;
    private static final int EXIF_CHUNK = 1163413830;
    private static final int XMP_CHUNK = 1481461792;
    private final WebPCodec codec = null;

    @Override
    public boolean supported(ByteBuffer buffer) {
        if (buffer.remaining() < 12) {
            return false;
        }
        int initialPos = buffer.position();
        int riff = DataTool.readBytesAsInt(buffer, 4, ByteOrder.BIG_ENDIAN);
        if (riff != 1380533830) {
            buffer.position(initialPos);
            return false;
        }
        buffer.position(buffer.position() + 4);
        int webp = DataTool.readBytesAsInt(buffer, 4, ByteOrder.BIG_ENDIAN);
        if (webp != 1464156752) {
            buffer.position(initialPos);
            return false;
        }
        return true;
    }

    @Override
    public Image decode(ByteBuffer buffer) throws IOException {
        int fileSize = DataTool.readBytesAsInt(buffer, 4, ByteOrder.LITTLE_ENDIAN);
        buffer.position(buffer.position() + 4);
        if (buffer.remaining() >= 8) {
            int chunkFourCC = this.peekFourCC(buffer);
            if (chunkFourCC == 1448097880) {
                return this.decodeExtendedFormat(buffer);
            }
            if (chunkFourCC == 1448097824) {
                return this.decodeSimpleLossyFormat(buffer);
            }
            if (chunkFourCC == 1448097868) {
                return this.decodeSimpleLosslessFormat(buffer);
            }
        }
        throw new IOException("Invalid WebP format: Unknown chunk type");
    }

    @Override
    public boolean test() {
        return false;
    }

    private int peekFourCC(ByteBuffer buffer) {
        int pos = buffer.position();
        int fourCC = DataTool.readBytesAsInt(buffer, 4, ByteOrder.BIG_ENDIAN);
        buffer.position(pos);
        return fourCC;
    }

    private Image decodeSimpleLossyFormat(ByteBuffer buffer) throws IOException {
        int chunkFourCC = DataTool.readBytesAsInt(buffer, 4, ByteOrder.BIG_ENDIAN);
        int chunkSize = DataTool.readBytesAsInt(buffer, 4, ByteOrder.LITTLE_ENDIAN);
        if (chunkFourCC != 1448097824) {
            throw new IOException("Expected VP8 chunk, found: " + Integer.toHexString(chunkFourCC));
        }
        ByteBuffer vp8Data = buffer.slice();
        vp8Data.limit(chunkSize);
        VP8Header header = this.parseVP8Header(vp8Data);
        ByteBuffer decodedFrame = this.decodeVP8Frame(vp8Data, header);
        return new Image(new ByteBuffer[]{decodedFrame}, header.width, header.height, new long[]{0L}, -1);
    }

    private Image decodeSimpleLosslessFormat(ByteBuffer buffer) throws IOException {
        int chunkFourCC = DataTool.readBytesAsInt(buffer, 4, ByteOrder.BIG_ENDIAN);
        int chunkSize = DataTool.readBytesAsInt(buffer, 4, ByteOrder.LITTLE_ENDIAN);
        if (chunkFourCC != 1448097868) {
            throw new IOException("Expected VP8L chunk, found: " + Integer.toHexString(chunkFourCC));
        }
        ByteBuffer vp8lData = buffer.slice();
        vp8lData.limit(chunkSize);
        VP8LHeader header = this.parseVP8LHeader(vp8lData);
        ByteBuffer decodedFrame = this.decodeVP8LFrame(vp8lData, header);
        return new Image(new ByteBuffer[]{decodedFrame}, header.width, header.height, new long[]{0L}, -1);
    }

    private Image decodeExtendedFormat(ByteBuffer buffer) throws IOException {
        int chunkFourCC = DataTool.readBytesAsInt(buffer, 4, ByteOrder.BIG_ENDIAN);
        int chunkSize = DataTool.readBytesAsInt(buffer, 4, ByteOrder.LITTLE_ENDIAN);
        if (chunkFourCC != 1448097880) {
            throw new IOException("Expected VP8X chunk");
        }
        byte flags = buffer.get();
        boolean hasICC = (flags & 0x20) != 0;
        boolean hasAlpha = (flags & 0x10) != 0;
        boolean hasEXIF = (flags & 8) != 0;
        boolean hasXMP = (flags & 4) != 0;
        boolean hasAnimation = (flags & 2) != 0;
        buffer.position(buffer.position() + 3);
        int canvasWidth = this.readUInt24(buffer) + 1;
        int canvasHeight = this.readUInt24(buffer) + 1;
        byte[] iccProfile = null;
        if (hasICC) {
            iccProfile = this.readICCPChunk(buffer);
        }
        if (hasAnimation) {
            return this.decodeAnimatedImage(buffer, canvasWidth, canvasHeight, hasAlpha);
        }
        return this.decodeSingleFrameExtended(buffer, canvasWidth, canvasHeight, hasAlpha);
    }

    private Image decodeAnimatedImage(ByteBuffer buffer, int canvasWidth, int canvasHeight, boolean hasAlpha) throws IOException {
        int animFourCC = DataTool.readBytesAsInt(buffer, 4, ByteOrder.BIG_ENDIAN);
        int animSize = DataTool.readBytesAsInt(buffer, 4, ByteOrder.LITTLE_ENDIAN);
        if (animFourCC != 1095649613) {
            throw new IOException("Expected ANIM chunk in animated WebP");
        }
        int backgroundColor = DataTool.readBytesAsInt(buffer, 4, ByteOrder.LITTLE_ENDIAN);
        int loopCount = DataTool.readBytesAsInt(buffer, 2, ByteOrder.LITTLE_ENDIAN);
        ArrayList<ByteBuffer> frames = new ArrayList<ByteBuffer>();
        ArrayList<Long> delays = new ArrayList<Long>();
        while (buffer.hasRemaining()) {
            int nextChunk = this.peekFourCC(buffer);
            if (nextChunk == 1095650630) {
                AnimationFrame frame = this.readANMFChunk(buffer, canvasWidth, canvasHeight);
                ByteBuffer frameImage = this.decodeAnimationFrame(frame, canvasWidth, canvasHeight, backgroundColor);
                frames.add(frameImage);
                delays.add(frame.duration);
                continue;
            }
            if (nextChunk == 1163413830 || nextChunk == 1481461792) {
                this.skipChunk(buffer);
                continue;
            }
            this.skipChunk(buffer);
        }
        ByteBuffer[] frameArray = frames.toArray(new ByteBuffer[0]);
        long[] delayArray = delays.stream().mapToLong(Long::longValue).toArray();
        int repeat = loopCount == 0 ? 0 : loopCount;
        return new Image(frameArray, canvasWidth, canvasHeight, delayArray, repeat);
    }

    private AnimationFrame readANMFChunk(ByteBuffer buffer, int canvasWidth, int canvasHeight) throws IOException {
        int chunkFourCC = DataTool.readBytesAsInt(buffer, 4, ByteOrder.BIG_ENDIAN);
        int chunkSize = DataTool.readBytesAsInt(buffer, 4, ByteOrder.LITTLE_ENDIAN);
        if (chunkFourCC != 1095650630) {
            throw new IOException("Expected ANMF chunk");
        }
        AnimationFrame frame = new AnimationFrame();
        frame.x = this.readUInt24(buffer) * 2;
        frame.y = this.readUInt24(buffer) * 2;
        frame.width = this.readUInt24(buffer) + 1;
        frame.height = this.readUInt24(buffer) + 1;
        frame.duration = this.readUInt24(buffer);
        byte flags = buffer.get();
        frame.blendingMethod = (flags & 2) >> 1;
        frame.disposeMethod = flags & 1;
        int frameDataStart = buffer.position();
        int frameDataSize = chunkSize - 16;
        while (buffer.position() < frameDataStart + frameDataSize) {
            int subChunkFourCC = DataTool.readBytesAsInt(buffer, 4, ByteOrder.BIG_ENDIAN);
            int subChunkSize = DataTool.readBytesAsInt(buffer, 4, ByteOrder.LITTLE_ENDIAN);
            if (subChunkFourCC == 1095520328) {
                frame.alphaData = ByteBuffer.allocate(subChunkSize);
                buffer.get(frame.alphaData.array(), 0, subChunkSize);
                frame.alphaData.rewind();
                if (subChunkSize % 2 == 0) continue;
                buffer.get();
                continue;
            }
            if (subChunkFourCC == 1448097824 || subChunkFourCC == 1448097868) {
                frame.bitstreamData = ByteBuffer.allocate(subChunkSize);
                buffer.get(frame.bitstreamData.array(), 0, subChunkSize);
                frame.bitstreamData.rewind();
                boolean bl = frame.isLossless = subChunkFourCC == 1448097868;
                if (subChunkSize % 2 == 0) continue;
                buffer.get();
                continue;
            }
            buffer.position(buffer.position() + subChunkSize);
            if (subChunkSize % 2 == 0) continue;
            buffer.get();
        }
        return frame;
    }

    private ByteBuffer decodeAnimationFrame(AnimationFrame frame, int canvasWidth, int canvasHeight, int backgroundColor) throws IOException {
        ByteBuffer frameBuffer;
        if (frame.isLossless) {
            header = this.parseVP8LHeader(frame.bitstreamData);
            frameBuffer = this.decodeVP8LFrame(frame.bitstreamData, (VP8LHeader)header);
        } else {
            header = this.parseVP8Header(frame.bitstreamData);
            frameBuffer = this.decodeVP8Frame(frame.bitstreamData, (VP8Header)header);
        }
        if (frame.alphaData != null && frame.alphaData.hasRemaining()) {
            this.applyAlphaChannel(frameBuffer, frame.alphaData, frame.width, frame.height);
        }
        ByteBuffer canvas = ByteBuffer.allocate(canvasWidth * canvasHeight * 4);
        this.fillCanvas(canvas, backgroundColor, canvasWidth, canvasHeight);
        this.compositeFrame(canvas, frameBuffer, frame, canvasWidth, canvasHeight);
        canvas.rewind();
        return canvas;
    }

    private void compositeFrame(ByteBuffer canvas, ByteBuffer frame, AnimationFrame frameInfo, int canvasWidth, int canvasHeight) {
        for (int y = 0; y < frameInfo.height && y + frameInfo.y < canvasHeight; ++y) {
            for (int x = 0; x < frameInfo.width && x + frameInfo.x < canvasWidth; ++x) {
                int canvasPos = ((frameInfo.y + y) * canvasWidth + (frameInfo.x + x)) * 4;
                int framePos = (y * frameInfo.width + x) * 4;
                if (frameInfo.blendingMethod == 0) {
                    this.alphaBlend(canvas, canvasPos, frame, framePos);
                    continue;
                }
                canvas.position(canvasPos);
                canvas.put(frame.get(framePos));
                canvas.put(frame.get(framePos + 1));
                canvas.put(frame.get(framePos + 2));
                canvas.put(frame.get(framePos + 3));
            }
        }
    }

    private void alphaBlend(ByteBuffer dst, int dstPos, ByteBuffer src, int srcPos) {
        int srcB = src.get(srcPos) & 0xFF;
        int srcG = src.get(srcPos + 1) & 0xFF;
        int srcR = src.get(srcPos + 2) & 0xFF;
        int srcA = src.get(srcPos + 3) & 0xFF;
        int dstB = dst.get(dstPos) & 0xFF;
        int dstG = dst.get(dstPos + 1) & 0xFF;
        int dstR = dst.get(dstPos + 2) & 0xFF;
        int dstA = dst.get(dstPos + 3) & 0xFF;
        int outA = srcA + dstA * (255 - srcA) / 255;
        if (outA == 0) {
            dst.put(dstPos, (byte)0);
            dst.put(dstPos + 1, (byte)0);
            dst.put(dstPos + 2, (byte)0);
            dst.put(dstPos + 3, (byte)0);
        } else {
            int outB = (srcB * srcA + dstB * dstA * (255 - srcA) / 255) / outA;
            int outG = (srcG * srcA + dstG * dstA * (255 - srcA) / 255) / outA;
            int outR = (srcR * srcA + dstR * dstA * (255 - srcA) / 255) / outA;
            dst.put(dstPos, (byte)outB);
            dst.put(dstPos + 1, (byte)outG);
            dst.put(dstPos + 2, (byte)outR);
            dst.put(dstPos + 3, (byte)outA);
        }
    }

    private void fillCanvas(ByteBuffer canvas, int color, int width, int height) {
        byte b = (byte)(color >> 24 & 0xFF);
        byte g = (byte)(color >> 16 & 0xFF);
        byte r = (byte)(color >> 8 & 0xFF);
        byte a = (byte)(color & 0xFF);
        for (int i = 0; i < width * height; ++i) {
            canvas.put(b);
            canvas.put(g);
            canvas.put(r);
            canvas.put(a);
        }
        canvas.rewind();
    }

    private Image decodeSingleFrameExtended(ByteBuffer buffer, int canvasWidth, int canvasHeight, boolean hasAlpha) throws IOException {
        ByteBuffer decodedFrame;
        ByteBuffer alphaData = null;
        ByteBuffer bitstreamData = null;
        boolean isLossless = false;
        while (buffer.hasRemaining()) {
            int chunkFourCC = DataTool.readBytesAsInt(buffer, 4, ByteOrder.BIG_ENDIAN);
            int chunkSize = DataTool.readBytesAsInt(buffer, 4, ByteOrder.LITTLE_ENDIAN);
            if (chunkFourCC == 1095520328) {
                alphaData = ByteBuffer.allocate(chunkSize);
                buffer.get(alphaData.array(), 0, chunkSize);
                alphaData.rewind();
                if (chunkSize % 2 == 0) continue;
                buffer.get();
                continue;
            }
            if (chunkFourCC == 1448097824 || chunkFourCC == 1448097868) {
                isLossless = chunkFourCC == 1448097868;
                bitstreamData = ByteBuffer.allocate(chunkSize);
                buffer.get(bitstreamData.array(), 0, chunkSize);
                bitstreamData.rewind();
                if (chunkSize % 2 == 0) break;
                buffer.get();
                break;
            }
            buffer.position(buffer.position() + chunkSize);
            if (chunkSize % 2 == 0) continue;
            buffer.get();
        }
        if (bitstreamData == null) {
            throw new IOException("No image data found in WebP file");
        }
        if (isLossless) {
            VP8LHeader header = this.parseVP8LHeader(bitstreamData);
            decodedFrame = this.decodeVP8LFrame(bitstreamData, header);
        } else {
            VP8Header header = this.parseVP8Header(bitstreamData);
            decodedFrame = this.decodeVP8Frame(bitstreamData, header);
        }
        if (alphaData != null && alphaData.hasRemaining()) {
            this.applyAlphaChannel(decodedFrame, alphaData, canvasWidth, canvasHeight);
        }
        return new Image(new ByteBuffer[]{decodedFrame}, canvasWidth, canvasHeight, new long[]{0L}, -1);
    }

    private void applyAlphaChannel(ByteBuffer image, ByteBuffer alphaData, int width, int height) throws IOException {
        byte[] alphaValues;
        byte flags = alphaData.get();
        int preprocessing = flags >> 4 & 3;
        int filtering = flags >> 2 & 3;
        int compression = flags & 3;
        if (compression == 0) {
            alphaValues = new byte[width * height];
            alphaData.get(alphaValues);
        } else if (compression == 1) {
            alphaValues = this.decompressAlphaVP8L(alphaData, width, height);
        } else {
            throw new IOException("Unsupported alpha compression method: " + compression);
        }
        if (filtering > 0) {
            this.applyAlphaFiltering(alphaValues, width, height, filtering);
        }
        image.rewind();
        for (int i = 0; i < width * height; ++i) {
            image.position(i * 4 + 3);
            image.put(alphaValues[i]);
        }
        image.rewind();
    }

    private void applyAlphaFiltering(byte[] alpha, int width, int height, int method) {
        byte[] filtered = new byte[width * height];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int idx = y * width + x;
                int predictor = 0;
                if (x == 0 && y == 0) {
                    predictor = 0;
                } else if (x == 0) {
                    predictor = alpha[(y - 1) * width] & 0xFF;
                } else if (y == 0) {
                    predictor = alpha[x - 1] & 0xFF;
                } else {
                    int A = alpha[idx - 1] & 0xFF;
                    int B = alpha[(y - 1) * width + x] & 0xFF;
                    int C = alpha[(y - 1) * width + (x - 1)] & 0xFF;
                    predictor = switch (method) {
                        case 1 -> A;
                        case 2 -> B;
                        case 3 -> Math.max(0, Math.min(255, A + B - C));
                        default -> predictor;
                    };
                }
                filtered[idx] = (byte)(predictor + (alpha[idx] & 0xFF) & 0xFF);
            }
        }
        System.arraycopy(filtered, 0, alpha, 0, alpha.length);
    }

    private byte[] decompressAlphaVP8L(ByteBuffer alphaData, int width, int height) throws IOException {
        byte[] result = new byte[width * height];
        if (alphaData.remaining() >= width * height) {
            alphaData.get(result);
        } else {
            Arrays.fill(result, (byte)-1);
        }
        return result;
    }

    private ByteBuffer decodeVP8Frame(ByteBuffer data, VP8Header header) throws IOException {
        ByteBuffer output = ByteBuffer.allocate(header.width * header.height * 4);
        this.codec.initialize();
        WebPCodec.FrameBuffer frameBuffer = new WebPCodec.FrameBuffer();
        frameBuffer.width = header.width;
        frameBuffer.height = header.height;
        frameBuffer.hasAlpha = false;
        frameBuffer = this.codec.decodeVP8(data, header.toCodecHeader());
        ByteBuffer bgra = this.codec.convertYUVToBGRA(frameBuffer);
        this.codec.cleanup();
        return bgra != null ? bgra : output;
    }

    private ByteBuffer decodeVP8LFrame(ByteBuffer data, VP8LHeader header) throws IOException {
        ByteBuffer output = ByteBuffer.allocate(header.width * header.height * 4);
        this.codec.initialize();
        WebPCodec.FrameBuffer frameBuffer = this.codec.decodeVP8L(data);
        if (frameBuffer != null && frameBuffer.toBGRA.get() != null) {
            return frameBuffer.toBGRA.get();
        }
        this.codec.cleanup();
        return output;
    }

    private VP8Header parseVP8Header(ByteBuffer data) throws IOException {
        VP8Header header = new VP8Header();
        byte tag0 = data.get();
        byte tag1 = data.get();
        byte tag2 = data.get();
        header.keyFrame = (tag0 & 1) == 0;
        header.version = tag0 >> 1 & 7;
        header.showFrame = (tag0 & 0x10) != 0;
        header.firstPartSize = (tag0 & 0xE0) >> 5 | tag1 << 3 | tag2 << 11;
        if (header.keyFrame) {
            byte startCode0 = data.get();
            byte startCode1 = data.get();
            byte startCode2 = data.get();
            if (startCode0 != -99 || startCode1 != 1 || startCode2 != 42) {
                throw new IOException("Invalid VP8 start code");
            }
            int widthAndScale = DataTool.readBytesAsInt(data, 2, ByteOrder.LITTLE_ENDIAN);
            int heightAndScale = DataTool.readBytesAsInt(data, 2, ByteOrder.LITTLE_ENDIAN);
            header.width = widthAndScale & 0x3FFF;
            header.horizontalScale = widthAndScale >> 14;
            header.height = heightAndScale & 0x3FFF;
            header.verticalScale = heightAndScale >> 14;
        }
        return header;
    }

    private VP8LHeader parseVP8LHeader(ByteBuffer data) throws IOException {
        VP8LHeader header = new VP8LHeader();
        byte signature = data.get();
        if (signature != 47) {
            throw new IOException("Invalid VP8L signature");
        }
        BitReader reader = new BitReader(data);
        header.width = reader.readBits(14) + 1;
        header.height = reader.readBits(14) + 1;
        header.hasAlpha = reader.readBit() == 1;
        header.version = reader.readBits(3);
        return header;
    }

    private byte[] readICCPChunk(ByteBuffer buffer) throws IOException {
        int chunkFourCC = DataTool.readBytesAsInt(buffer, 4, ByteOrder.BIG_ENDIAN);
        int chunkSize = DataTool.readBytesAsInt(buffer, 4, ByteOrder.LITTLE_ENDIAN);
        if (chunkFourCC != 1229144912) {
            throw new IOException("Expected ICCP chunk");
        }
        byte[] iccProfile = new byte[chunkSize];
        buffer.get(iccProfile);
        if (chunkSize % 2 != 0) {
            buffer.get();
        }
        return iccProfile;
    }

    private void skipChunk(ByteBuffer buffer) {
        buffer.position(buffer.position() + 4);
        int chunkSize = DataTool.readBytesAsInt(buffer, 4, ByteOrder.LITTLE_ENDIAN);
        buffer.position(buffer.position() + chunkSize);
        if (chunkSize % 2 != 0) {
            buffer.position(buffer.position() + 1);
        }
    }

    private int readUInt24(ByteBuffer buffer) {
        return DataTool.readBytesAsInt(buffer, 3, ByteOrder.LITTLE_ENDIAN);
    }

    private static class VP8Header {
        boolean keyFrame;
        int version;
        boolean showFrame;
        int firstPartSize;
        int width;
        int height;
        int horizontalScale;
        int verticalScale;

        private VP8Header() {
        }

        WebPCodec.VP8FrameHeader toCodecHeader() {
            WebPCodec.VP8FrameHeader header = new WebPCodec.VP8FrameHeader();
            header.keyFrame = this.keyFrame;
            header.version = this.version;
            header.showFrame = this.showFrame;
            header.partitionLength = this.firstPartSize;
            header.width = this.width;
            header.height = this.height;
            header.horizontalScale = this.horizontalScale;
            header.verticalScale = this.verticalScale;
            return header;
        }
    }

    private static class VP8LHeader {
        int width;
        int height;
        boolean hasAlpha;
        int version;

        private VP8LHeader() {
        }
    }

    private static class AnimationFrame {
        int x;
        int y;
        int width;
        int height;
        long duration;
        int blendingMethod;
        int disposeMethod;
        ByteBuffer alphaData;
        ByteBuffer bitstreamData;
        boolean isLossless;

        private AnimationFrame() {
        }
    }

    private static class BitReader {
        private final ByteBuffer buffer;
        private long value;
        private int bitsAvailable;

        BitReader(ByteBuffer buffer) {
            this.buffer = buffer;
            this.value = 0L;
            this.bitsAvailable = 0;
        }

        int readBits(int numBits) {
            if (numBits > 32) {
                throw new IllegalArgumentException("Cannot read more than 32 bits at once");
            }
            while (this.bitsAvailable < numBits && this.buffer.hasRemaining()) {
                this.value |= (long)(this.buffer.get() & 0xFF) << this.bitsAvailable;
                this.bitsAvailable += 8;
            }
            int result = (int)(this.value & (1L << numBits) - 1L);
            this.value >>>= numBits;
            this.bitsAvailable -= numBits;
            return result;
        }

        int readBit() {
            return this.readBits(1);
        }
    }
}

