/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.api.media;

import java.net.URI;
import java.util.Date;
import java.util.Map;
import org.watermedia.WaterMedia;

public record MRL(MediaType mediaType, Map<MediaQuality, URI> sourceQuality) {
    public URI getURI(MediaQuality quality) {
        if (this.sourceQuality.containsKey((Object)quality)) {
            return this.sourceQuality.get((Object)quality);
        }
        MediaQuality checkQuality = quality;
        do {
            checkQuality = checkQuality.getBack();
            WaterMedia.LOGGER.info("Checking quality {}", (Object)checkQuality);
            if (!this.sourceQuality.containsKey((Object)checkQuality)) continue;
            return this.sourceQuality.get((Object)checkQuality);
        } while (checkQuality != quality);
        throw new IllegalStateException("MRL has no available qualities");
    }

    public String getURIString(MediaQuality quality) {
        URI uri = this.getURI(quality);
        if ("file".equals(uri.getScheme())) {
            return uri.getPath();
        }
        return uri.toString();
    }

    public static enum MediaType {
        IMAGE,
        AUDIO,
        VIDEO,
        SUBTITLES,
        UNKNOWN;


        public static MediaType ofMimetype(String mimetype) {
            String[] mm = mimetype.split("/");
            String type = mm[0];
            String format = mm.length == 1 ? null : mm[1].toLowerCase();
            return switch (type) {
                case "image" -> IMAGE;
                case "video" -> VIDEO;
                case "audio" -> AUDIO;
                case "text" -> {
                    if (format != null && (format.equals("str") || format.equals("plain"))) {
                        yield SUBTITLES;
                    }
                    yield UNKNOWN;
                }
                default -> UNKNOWN;
            };
        }
    }

    public static enum MediaQuality {
        LOWEST(240),
        LOWER(480),
        LOW(540),
        AVERAGE(720),
        HIGH(1080),
        HIGHER(1440),
        HIGHEST(2160);

        private final int threshold;
        public static final MediaQuality[] VALUES;

        private MediaQuality(int threshold) {
            this.threshold = threshold;
        }

        public static MediaQuality of(int width) {
            if (width >= MediaQuality.LOWEST.threshold && width < MediaQuality.LOWER.threshold) {
                return LOWEST;
            }
            if (width >= MediaQuality.LOWER.threshold && width < MediaQuality.LOW.threshold) {
                return LOWER;
            }
            if (width >= MediaQuality.LOW.threshold && width < MediaQuality.AVERAGE.threshold) {
                return LOW;
            }
            if (width >= MediaQuality.AVERAGE.threshold && width < MediaQuality.HIGH.threshold) {
                return AVERAGE;
            }
            if (width >= MediaQuality.HIGH.threshold && width < MediaQuality.HIGHER.threshold) {
                return HIGH;
            }
            if (width >= MediaQuality.HIGHER.threshold && width < MediaQuality.HIGHEST.threshold) {
                return HIGHER;
            }
            return HIGHEST;
        }

        public MediaQuality getNext() {
            int ordinal = this.ordinal() + 1;
            if (ordinal >= VALUES.length) {
                return VALUES[0];
            }
            return VALUES[ordinal];
        }

        public MediaQuality getBack() {
            int ordinal = this.ordinal() - 1;
            if (ordinal <= 0) {
                return VALUES[VALUES.length - 1];
            }
            return VALUES[ordinal];
        }

        static {
            VALUES = MediaQuality.values();
        }
    }

    public record Metadata(URI thumbnail, String title, String description, Date date, long duration) {
    }
}

