/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.api.media;

import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLConnection;
import java.util.LinkedList;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.watermedia.WaterMedia;
import org.watermedia.api.WaterMediaAPI;
import org.watermedia.api.media.MRL;
import org.watermedia.api.media.platforms.ALEngine;
import org.watermedia.api.media.platforms.GLEngine;
import org.watermedia.api.media.players.FFMediaPlayer;
import org.watermedia.api.media.players.MediaPlayer;
import org.watermedia.api.media.players.TxMediaPlayer;
import org.watermedia.api.media.players.VLMediaPlayer;
import org.watermedia.api.media.sources.DefaultPlatform;
import org.watermedia.api.media.sources.IPlatform;
import org.watermedia.api.media.sources.StreamablePlatform;
import org.watermedia.api.media.sources.WaterPlatform;
import org.watermedia.tools.NetTool;
import org.watermedia.videolan4j.VideoLan4J;
import org.watermedia.videolan4j.binding.internal.libvlc_instance_t;

public class MediaAPI
extends WaterMediaAPI {
    private static final Marker IT = MarkerManager.getMarker((String)MediaAPI.class.getSimpleName());
    private static final LinkedList<IPlatform> PLATFORMS = new LinkedList();

    public static MRL[] getSources(URI uri) {
        WaterMedia.LOGGER.info("Loading source for {}", (Object)uri);
        if (PLATFORMS.isEmpty()) {
            WaterMedia.LOGGER.error("SOMEHOW PLATFORMS ARE EMPTY");
        }
        for (IPlatform platform : PLATFORMS) {
            WaterMedia.LOGGER.info("Checking {}", (Object)platform.name());
            if (!platform.validate(uri)) continue;
            try {
                WaterMedia.LOGGER.info("Using source {}", (Object)platform.name());
                MRL[] source = platform.getSources(uri);
                if (source == null) continue;
                return source;
            }
            catch (Throwable t) {
                WaterMedia.LOGGER.error("Platform {} threw an exception while validating URI: {}", (Object)platform.name(), (Object)uri, (Object)t);
            }
        }
        throw new IllegalStateException("This exception should not be threw");
    }

    public static MediaPlayer getMediaPlayer(URI uri, Thread thread, Executor renderThreadEx, GLEngine glEngine, ALEngine alEngine, boolean video, boolean audio) {
        WaterMedia.checkIsClientSideOrThrow(MediaAPI.class);
        try {
            String[] type;
            URLConnection conn = uri.toURL().openConnection();
            if (conn instanceof HttpURLConnection) {
                HttpURLConnection http = (HttpURLConnection)conn;
                NetTool.validateHTTP200(http.getResponseCode(), uri);
            }
            if ((type = conn.getContentType().split("/"))[0].equals("image")) {
                return new TxMediaPlayer(uri, thread, renderThreadEx, glEngine, video);
            }
            if (VLMediaPlayer.loaded()) {
                WaterMedia.LOGGER.debug(IT, "Creating LibVLC MediaPlayer for URI: {}", (Object)uri);
                return new VLMediaPlayer(uri, thread, renderThreadEx, glEngine, alEngine, video, audio);
            }
            if (FFMediaPlayer.loaded()) {
                WaterMedia.LOGGER.debug(IT, "Creating FFMPEG MediaPlayer for URI: {}", (Object)uri);
                return new FFMediaPlayer(uri, thread, renderThreadEx, glEngine, alEngine, video, audio);
            }
            WaterMedia.LOGGER.error(IT, "Neither LibVLC nor FFMPEG are loaded, cannot create MediaPlayer for URI: {}", (Object)uri);
        }
        catch (Throwable t) {
            WaterMedia.LOGGER.error(IT, "Failed to create MediaPlayer for URI: {}", (Object)uri, (Object)t);
        }
        return null;
    }

    @Override
    public boolean start(WaterMedia instance) throws Exception {
        if (!instance.clientSide) {
            WaterMedia.LOGGER.warn(IT, "Detected server-side environment, lockdown mode enabled");
            return false;
        }
        PLATFORMS.push(new StreamablePlatform());
        PLATFORMS.push(new WaterPlatform());
        PLATFORMS.addLast(new DefaultPlatform());
        boolean libVlcLoaded = VLMediaPlayer.load(instance);
        boolean ffmpegLoaded = FFMediaPlayer.load(instance);
        if (!libVlcLoaded && !ffmpegLoaded) {
            WaterMedia.LOGGER.fatal(IT, "LibVLC and FFMPEG are unable to be started in your environment, please report this issue to the WaterMedia's authors");
            return false;
        }
        return true;
    }

    @Override
    public boolean onlyClient() {
        return true;
    }

    @Override
    public void test() {
        WaterMedia.LOGGER.info(IT, "Testing LibVLC...");
        if (VideoLan4J.load(new String[0])) {
            libvlc_instance_t instance = VideoLan4J.createInstance("--no-quiet", "--verbose", "--file-logging", "--logfile=/logs/vlc.log", "--vout=direct3d11");
            VideoLan4J.releaseInstance(instance);
        }
    }

    @Override
    public WaterMediaAPI.Priority priority() {
        return WaterMediaAPI.Priority.NORMAL;
    }

    @Override
    public void release(WaterMedia instance) {
        if (VideoLan4J.isDiscovered()) {
            VideoLan4J.releaseInstance(VideoLan4J.getDefaultInstance());
        }
    }
}

