/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.api.media.platforms;

import java.nio.ByteBuffer;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import org.lwjgl.opengl.GL11;
import org.watermedia.WaterMedia;
import org.watermedia.tools.functions.BiIntConsumer;
import org.watermedia.tools.functions.TexImage2DFunction;
import org.watermedia.tools.functions.TexSubImage2DFunction;
import org.watermedia.tools.functions.TriIntConsumer;

public record GLEngine(IntSupplier genTexture, BiIntConsumer bindTexture, TriIntConsumer texParameter, BiIntConsumer pixelStore, IntConsumer delTexture, TexImage2DFunction texImage2D, TexSubImage2DFunction texSubImage2D) {
    public GLEngine {
        WaterMedia.checkIsClientSideOrThrow(GLEngine.class);
        if (genTexture == null || bindTexture == null || texParameter == null || pixelStore == null || delTexture == null || texImage2D == null || texSubImage2D == null) {
            throw new IllegalArgumentException("All parameters must be non-null");
        }
    }

    public int createTexture() {
        int texture = this.genTexture.getAsInt();
        this.bindTexture.accept(3553, texture);
        this.texParameter.accept(3553, 10242, 33071);
        this.texParameter.accept(3553, 10243, 33071);
        this.texParameter.accept(3553, 10241, 9729);
        this.texParameter.accept(3553, 10240, 9729);
        this.bindTexture.accept(3553, 0);
        return texture;
    }

    public void uploadTexture(int texture, ByteBuffer buffers, int stride, int width, int height, int format, boolean firstFrame) {
        this.bindTexture.accept(3553, texture);
        this.pixelStore.accept(3314, stride);
        this.pixelStore.accept(3316, 0);
        this.pixelStore.accept(3315, 0);
        if (firstFrame) {
            this.texImage2D.apply(3553, 0, format, width, height, 0, format, 33639, buffers);
        } else {
            this.texSubImage2D.apply(3553, 0, 0, 0, width, height, format, 33639, buffers);
        }
    }

    public void deleteTexture(int texture) {
        this.delTexture.accept(texture);
    }

    public static class Builder {
        private IntSupplier genTexture = GL11::glGenTextures;
        private BiIntConsumer bindTexture = GL11::glBindTexture;
        private TriIntConsumer texParameter = GL11::glTexParameteri;
        private BiIntConsumer pixelStore = GL11::glPixelStorei;
        private IntConsumer delTexture = GL11::glDeleteTextures;
        private TexImage2DFunction texImage2D = GL11::glTexImage2D;
        private TexSubImage2DFunction texSubImage2D = GL11::glTexSubImage2D;

        public Builder setGenTexture(IntSupplier genTexture) {
            this.genTexture = genTexture;
            return this;
        }

        public Builder setBindTexture(BiIntConsumer bindTexture) {
            this.bindTexture = bindTexture;
            return this;
        }

        public Builder setTexParameter(TriIntConsumer texParameter) {
            this.texParameter = texParameter;
            return this;
        }

        public Builder setPixelStore(BiIntConsumer pixelStore) {
            this.pixelStore = pixelStore;
            return this;
        }

        public Builder setDelTexture(IntConsumer delTexture) {
            this.delTexture = delTexture;
            return this;
        }

        public Builder setTexImage2D(TexImage2DFunction texImage2D) {
            this.texImage2D = texImage2D;
            return this;
        }

        public Builder setTexSubImage2D(TexSubImage2DFunction texSubImage2D) {
            this.texSubImage2D = texSubImage2D;
            return this;
        }

        public GLEngine build() {
            return new GLEngine(this.genTexture, this.bindTexture, this.texParameter, this.pixelStore, this.delTexture, this.texImage2D, this.texSubImage2D);
        }
    }
}

