/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.api.media.players;

import com.sun.jna.Pointer;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.lwjgl.system.MemoryUtil;
import org.watermedia.WaterMedia;
import org.watermedia.api.media.platforms.ALEngine;
import org.watermedia.api.media.platforms.GLEngine;
import org.watermedia.api.media.players.MediaPlayer;
import org.watermedia.videolan4j.VideoLan4J;
import org.watermedia.videolan4j.binding.internal.libvlc_audio_play_cb;
import org.watermedia.videolan4j.binding.internal.libvlc_audio_set_volume_cb;
import org.watermedia.videolan4j.binding.internal.libvlc_callback_t;
import org.watermedia.videolan4j.binding.internal.libvlc_display_callback_t;
import org.watermedia.videolan4j.binding.internal.libvlc_event_e;
import org.watermedia.videolan4j.binding.internal.libvlc_event_manager_t;
import org.watermedia.videolan4j.binding.internal.libvlc_lock_callback_t;
import org.watermedia.videolan4j.binding.internal.libvlc_media_list_player_t;
import org.watermedia.videolan4j.binding.internal.libvlc_media_list_t;
import org.watermedia.videolan4j.binding.internal.libvlc_media_player_t;
import org.watermedia.videolan4j.binding.internal.libvlc_media_stats_t;
import org.watermedia.videolan4j.binding.internal.libvlc_media_t;
import org.watermedia.videolan4j.binding.internal.libvlc_unlock_callback_t;
import org.watermedia.videolan4j.binding.internal.libvlc_video_cleanup_cb;
import org.watermedia.videolan4j.binding.internal.libvlc_video_format_cb;
import org.watermedia.videolan4j.binding.lib.LibC;
import org.watermedia.videolan4j.binding.lib.LibVlc;
import org.watermedia.videolan4j.tools.AudioFormat;
import org.watermedia.videolan4j.tools.Buffers;
import org.watermedia.videolan4j.tools.Chroma;

public final class VLMediaPlayer
extends MediaPlayer {
    private static final Marker IT = MarkerManager.getMarker((String)VLMediaPlayer.class.getSimpleName());
    private static final Chroma CHROMA = Chroma.RV32;
    private static final AudioFormat AUDIO_FORMAT = AudioFormat.S16N_STEREO_96;
    private ByteBuffer nativeBuffer = null;
    private Pointer nativePointer = null;
    private final libvlc_media_player_t rawPlayer = VideoLan4J.createMediaPlayer();
    private final libvlc_media_stats_t rawStats = null;
    private final libvlc_event_manager_t rawPlayerEvents;
    private libvlc_media_list_t mediaList;
    private libvlc_media_list_player_t mediaListPlayer;
    private libvlc_event_manager_t mediaListEvents;
    private libvlc_media_t currentMedia;
    private int currentMediaIndex = 0;
    private volatile boolean loadingSources = false;
    private volatile boolean changingQuality = false;
    private long savedPosition = -1L;
    private boolean wasPlaying = false;
    private final libvlc_callback_t endReachedCallback = (event, userData) -> {
        if (this.repeat()) {
            this.renderThreadEx.execute(() -> this.start());
        }
    };
    private final libvlc_callback_t playingCallback = (event, userData) -> {
        this.currentMedia = LibVlc.libvlc_media_player_get_media(this.rawPlayer);
    };
    private final libvlc_callback_t listPlayedCallback = (event, userData) -> {
        WaterMedia.LOGGER.debug(IT, "Media list finished playing all items");
        if (this.repeat()) {
            this.renderThreadEx.execute(() -> this.setSourceIndex(0));
        }
    };
    private final libvlc_video_format_cb formatCB = (opaque, chromaPointer, widthPointer, heightPointer, pitchesPointer, linesPointer) -> {
        byte[] chromaBytes = CHROMA.chroma();
        chromaPointer.getPointer().write(0L, chromaBytes, 0, Math.min(chromaBytes.length, 4));
        this.setVideoFormat(32993, widthPointer.getValue(), heightPointer.getValue());
        int[] pitchValues = CHROMA.getPitches(this.width());
        int[] lineValues = CHROMA.getLines(this.height());
        int planeCount = pitchValues.length;
        pitchesPointer.getPointer().write(0L, pitchValues, 0, pitchValues.length);
        linesPointer.getPointer().write(0L, lineValues, 0, lineValues.length);
        this.nativeBuffer = Buffers.alloc(pitchValues[0] * lineValues[0]);
        this.nativePointer = Pointer.createConstant((long)Buffers.address(this.nativeBuffer));
        LibC.memoryLock(this.nativePointer, this.nativeBuffer.capacity());
        return planeCount;
    };
    private final libvlc_video_cleanup_cb cleanupCB = opaque -> {
        if (this.nativeBuffer == null) {
            return;
        }
        LibC.memoryUnlock(this.nativePointer, this.nativeBuffer.capacity());
        this.nativeBuffer = null;
        this.nativePointer = null;
    };
    private final libvlc_lock_callback_t lockCB = (opaque, planes) -> {
        if (this.nativeBuffer == null) {
            return null;
        }
        ByteBuffer byteBuffer = this.nativeBuffer;
        synchronized (byteBuffer) {
            planes.getPointer().setPointer(0L, this.nativePointer);
        }
        return null;
    };
    private final libvlc_display_callback_t displayCB = (opaque, picture) -> this.upload(this.nativeBuffer, 0);
    private final libvlc_unlock_callback_t unlockCB = (opaque, picture, plane) -> {};
    private final libvlc_audio_play_cb playCB = (pointer, samples, count, pts) -> this.upload(samples.getByteBuffer(0L, (long)AUDIO_FORMAT.calculateBufferSize(count)), 4355, AUDIO_FORMAT.getSampleRate(), AUDIO_FORMAT.getChannelCount());
    private final libvlc_audio_set_volume_cb volumeCB = (data, volume, mute) -> {};

    public VLMediaPlayer(URI mrl, Thread renderThread, Executor renderThreadEx, GLEngine glEngine, ALEngine alEngine, boolean video, boolean audio) {
        super(mrl, renderThread, renderThreadEx, glEngine, alEngine, video, audio);
        this.mediaList = LibVlc.libvlc_media_list_new(VideoLan4J.getDefaultInstance());
        this.mediaListPlayer = LibVlc.libvlc_media_list_player_new(VideoLan4J.getDefaultInstance());
        LibVlc.libvlc_media_list_player_set_media_player(this.mediaListPlayer, this.rawPlayer);
        if (this.isAudio()) {
            LibVlc.libvlc_audio_set_callbacks(this.rawPlayer, this.playCB, null, null, null, null, Pointer.NULL);
            LibVlc.libvlc_audio_set_volume_callback(this.rawPlayer, this.volumeCB);
            LibVlc.libvlc_audio_set_format(this.rawPlayer, AUDIO_FORMAT.getFormatName(), AUDIO_FORMAT.getSampleRate(), AUDIO_FORMAT.getChannelCount());
        }
        if (this.isVideo()) {
            LibVlc.libvlc_video_set_format_callbacks(this.rawPlayer, this.formatCB, this.cleanupCB);
            LibVlc.libvlc_video_set_callbacks(this.rawPlayer, this.lockCB, this.unlockCB, this.displayCB, Pointer.NULL);
        }
        this.rawPlayerEvents = LibVlc.libvlc_media_player_event_manager(this.rawPlayer);
        LibVlc.libvlc_event_attach(this.rawPlayerEvents, libvlc_event_e.libvlc_MediaPlayerEndReached.intValue(), this.endReachedCallback, null);
        LibVlc.libvlc_event_attach(this.rawPlayerEvents, libvlc_event_e.libvlc_MediaPlayerPlaying.intValue(), this.playingCallback, null);
        this.mediaListEvents = LibVlc.libvlc_media_list_player_event_manager(this.mediaListPlayer);
        LibVlc.libvlc_event_attach(this.mediaListEvents, libvlc_event_e.libvlc_MediaListPlayerPlayed.intValue(), this.listPlayedCallback, null);
    }

    @Override
    protected void updateMedia() {
        LibVlc.libvlc_media_list_player_play_item_at_index(this.mediaListPlayer, this.currentMediaIndex);
        if (this.changingQuality) {
            return;
        }
        this.changingQuality = true;
        if (this.playing()) {
            this.savedPosition = this.time();
            this.wasPlaying = true;
            this.pause();
        } else {
            this.savedPosition = this.time();
            this.wasPlaying = false;
        }
        this.rebuildMediaList();
        this.changingQuality = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildMediaList() {
        LibVlc.libvlc_media_list_player_stop(this.mediaListPlayer);
        if (this.mediaList != null) {
            int count = LibVlc.libvlc_media_list_count(this.mediaList);
            for (int i = count - 1; i >= 0; --i) {
                LibVlc.libvlc_media_list_remove_index(this.mediaList, i);
            }
        }
        LibVlc.libvlc_media_list_lock(this.mediaList);
        try {
            for (int i = 0; i < this.sources.length; ++i) {
                URI uri = this.sources[i].getURI(this.selectedQuality);
                libvlc_media_t media = VideoLan4J.createMediaInstance(uri);
                if (i == this.sourceIndex && this.savedPosition > 0L) {
                    LibVlc.libvlc_media_add_option(media, "start-time=" + this.savedPosition / 1000L);
                }
                LibVlc.libvlc_media_list_add_media(this.mediaList, media);
                LibVlc.libvlc_media_release(media);
            }
            LibVlc.libvlc_media_list_player_set_media_list(this.mediaListPlayer, this.mediaList);
            if (this.sourceIndex >= 0 && this.sourceIndex < this.sources.length) {
                LibVlc.libvlc_media_list_player_play_item_at_index(this.mediaListPlayer, this.sourceIndex);
                if (this.wasPlaying) {
                    this.renderThreadEx.execute(() -> {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (this.savedPosition > 0L) {
                            this.seek(this.savedPosition);
                        }
                        this.resume();
                    });
                }
            }
        }
        finally {
            LibVlc.libvlc_media_list_unlock(this.mediaList);
        }
    }

    @Override
    public boolean previousFrame() {
        WaterMedia.LOGGER.warn(IT, "Prev frame is not supported by VLC Media Player");
        return false;
    }

    @Override
    public boolean nextFrame() {
        LibVlc.libvlc_media_player_next_frame(this.rawPlayer);
        return true;
    }

    @Override
    public void start() {
        if (this.loadingSources) {
            return;
        }
        this.loadingSources = true;
        this.openSources(() -> {
            this.rebuildMediaList();
            LibVlc.libvlc_media_list_player_play_item_at_index(this.mediaListPlayer, this.sourceIndex);
            this.loadingSources = false;
        });
    }

    @Override
    public void startPaused() {
        this.start();
        this.renderThreadEx.execute(() -> {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.pause();
        });
    }

    @Override
    public boolean resume() {
        return this.pause(false);
    }

    @Override
    public boolean pause() {
        return this.pause(true);
    }

    @Override
    public boolean pause(boolean paused) {
        LibVlc.libvlc_media_player_set_pause(this.rawPlayer, paused ? 1 : 0);
        super.pause(paused);
        return true;
    }

    @Override
    public boolean stop() {
        LibVlc.libvlc_media_list_player_stop(this.mediaListPlayer);
        return true;
    }

    @Override
    public boolean togglePlay() {
        if (this.status() == MediaPlayer.Status.PLAYING) {
            return this.pause();
        }
        if (this.status() == MediaPlayer.Status.PAUSED) {
            return this.resume();
        }
        if (this.status() == MediaPlayer.Status.STOPPED) {
            this.start();
            return true;
        }
        return false;
    }

    @Override
    public boolean seek(long time) {
        LibVlc.libvlc_media_player_set_time(this.rawPlayer, Math.max(time, 0L));
        return true;
    }

    @Override
    public boolean skipTime(long time) {
        long current = this.time();
        if (current != -1L) {
            return this.seek(current + time);
        }
        return false;
    }

    @Override
    public boolean seekQuick(long time) {
        return this.seek(time);
    }

    @Override
    public boolean foward() {
        return this.skipTime(5000L);
    }

    @Override
    public boolean rewind() {
        return this.skipTime(-5000L);
    }

    @Override
    public float speed() {
        return LibVlc.libvlc_media_player_get_rate(this.rawPlayer);
    }

    @Override
    public boolean speed(float speed) {
        return LibVlc.libvlc_media_player_set_rate(this.rawPlayer, Math.max(speed, 0.1f)) != -1;
    }

    @Override
    public MediaPlayer.Status status() {
        if (this.loadingSources || this.changingQuality) {
            return MediaPlayer.Status.LOADING;
        }
        return MediaPlayer.Status.of(LibVlc.libvlc_media_player_get_state(this.rawPlayer));
    }

    @Override
    public boolean playing() {
        return LibVlc.libvlc_media_player_is_playing(this.rawPlayer) == 1;
    }

    @Override
    public boolean validSource() {
        return this.currentMedia != null || this.mediaList != null;
    }

    @Override
    public boolean liveSource() {
        if (this.currentMedia != null) {
            return LibVlc.libvlc_media_get_duration(this.currentMedia) == -1L;
        }
        return false;
    }

    @Override
    public boolean canSeek() {
        return LibVlc.libvlc_media_player_is_seekable(this.rawPlayer) == 1;
    }

    @Override
    public boolean canPause() {
        return LibVlc.libvlc_media_player_can_pause(this.rawPlayer) == 1;
    }

    @Override
    public boolean canPlay() {
        return LibVlc.libvlc_media_player_will_play(this.rawPlayer) == 1;
    }

    @Override
    public long duration() {
        return LibVlc.libvlc_media_player_get_length(this.rawPlayer);
    }

    @Override
    public long time() {
        return LibVlc.libvlc_media_player_get_time(this.rawPlayer);
    }

    @Override
    public void release() {
        this.repeat(false);
        if (this.mediaListPlayer != null) {
            LibVlc.libvlc_media_list_player_stop(this.mediaListPlayer);
        }
        if (this.rawPlayerEvents != null) {
            LibVlc.libvlc_event_detach(this.rawPlayerEvents, libvlc_event_e.libvlc_MediaPlayerEndReached.intValue(), this.endReachedCallback, null);
            LibVlc.libvlc_event_detach(this.rawPlayerEvents, libvlc_event_e.libvlc_MediaPlayerPlaying.intValue(), this.playingCallback, null);
        }
        if (this.mediaListEvents != null) {
            LibVlc.libvlc_event_detach(this.mediaListEvents, libvlc_event_e.libvlc_MediaListPlayerPlayed.intValue(), this.listPlayedCallback, null);
        }
        if (this.currentMedia != null) {
            LibVlc.libvlc_media_release(this.currentMedia);
            this.currentMedia = null;
        }
        if (this.mediaListPlayer != null) {
            LibVlc.libvlc_media_list_player_release(this.mediaListPlayer);
            this.mediaListPlayer = null;
        }
        if (this.mediaList != null) {
            LibVlc.libvlc_media_list_release(this.mediaList);
            this.mediaList = null;
        }
        if (this.rawPlayer != null) {
            LibVlc.libvlc_media_player_release(this.rawPlayer);
        }
        this.nativeBuffer = null;
        this.nativePointer = null;
        super.release();
    }

    private libvlc_media_stats_t getMediaStats() {
        if (this.currentMedia != null && LibVlc.libvlc_media_get_stats(this.currentMedia, this.rawStats) != 0) {
            throw new IllegalStateException("Failed to get media stats");
        }
        return this.rawStats;
    }

    public static boolean load(WaterMedia instance) {
        WaterMedia.LOGGER.info(IT, "Starting LibVLC...");
        if (VideoLan4J.load("--no-quiet", "--verbose=2")) {
            WaterMedia.LOGGER.info(IT, "Created new LibVLC instance");
            VideoLan4J.setBufferAllocator(MemoryUtil::memAlignedAlloc);
            VideoLan4J.setBufferDeallocator(MemoryUtil::memAlignedFree);
            WaterMedia.LOGGER.info(IT, "Overrided LibVLC buffer allocator/deallocator");
            WaterMedia.LOGGER.info(IT, "LibVLC started, running version {}", (Object)VideoLan4J.getLibVersion());
            return true;
        }
        WaterMedia.LOGGER.error(IT, "Failed to load LibVLC");
        return false;
    }

    public static boolean loaded() {
        return VideoLan4J.isDiscovered();
    }
}

