/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.api.media.sources;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.Map;
import org.watermedia.api.media.MRL;
import org.watermedia.api.media.sources.IPlatform;
import org.watermedia.tools.NetTool;

public class StreamablePlatform
implements IPlatform {
    private static final String API_URL = "https://api.streamable.com/videos/";
    private static final Gson GSON = new Gson();

    @Override
    public String name() {
        return "Streamable";
    }

    @Override
    public boolean validate(URI uri) {
        return "streamable.com".equals(uri.getHost());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public MRL[] getSources(URI uri) {
        String videoId = uri.getPath().substring(1);
        try {
            HttpURLConnection connection = NetTool.connectToHTTP(new URI(API_URL + videoId), "GET");
            NetTool.validateHTTP200(connection.getResponseCode(), uri);
            try {
                MRL[] mRLArray;
                try (InputStreamReader is = new InputStreamReader(connection.getInputStream());){
                    VideoData video = (VideoData)GSON.fromJson((Reader)is, VideoData.class);
                    Map<MRL.MediaQuality, URI> qualities = Map.of(MRL.MediaQuality.of(video.files.mp4.width), new URI(video.files.mp4.url), MRL.MediaQuality.of(video.files.mp4_mobile.width), new URI(video.files.mp4_mobile.url));
                    mRLArray = new MRL[]{new MRL(MRL.MediaType.VIDEO, qualities)};
                }
                return mRLArray;
            }
            finally {
                connection.disconnect();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to get Streamable video sources from " + String.valueOf(uri), e);
        }
    }

    private record VideoData(int status, int percent, String message, VideoFiles files) {
    }

    private record VideoFiles(VideoFile mp4, @SerializedName(value="mp4-mobile") VideoFile mp4_mobile) {
    }

    public record VideoFile(int status, String url, int framerate, int width, int height, int bitrate, int size, float duration) {
    }
}

