/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.tools;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.jar.Manifest;

public class IOTool {
    public static String getVersion() {
        try {
            Manifest manifest = new Manifest(IOTool.jarOpenResource("/META-INF/MANIFEST.MF"));
            return manifest.getMainAttributes().getValue("version");
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read self manifest", e);
        }
    }

    public static String jarReadString(String from) {
        String string;
        block8: {
            InputStream is = IOTool.jarOpenResource(from);
            try {
                byte[] bytes = IOTool.readAllBytes(is);
                string = new String(bytes, StandardCharsets.UTF_8);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return null;
                }
            }
            is.close();
        }
        return string;
    }

    public static InputStream jarOpenResource(String source) {
        return IOTool.jarOpenResource$classLoader(source, IOTool.class.getClassLoader());
    }

    private static InputStream jarOpenResource$classLoader(String source, ClassLoader classLoader) {
        InputStream is = classLoader.getResourceAsStream(source);
        if (is == null && source.startsWith("/")) {
            is = classLoader.getResourceAsStream(source.substring(1));
        }
        return is;
    }

    public static byte[] readAllBytes(InputStream in) throws Exception {
        if (in == null) {
            throw new NullPointerException("InputStream is null");
        }
        try (InputStream inputStream = in;){
            byte[] byArray = in.readAllBytes();
            return byArray;
        }
    }
}

