/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.videolan4j;

import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.StringArray;
import java.io.File;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.watermedia.videolan4j.binding.internal.libvlc_instance_t;
import org.watermedia.videolan4j.binding.internal.libvlc_media_player_t;
import org.watermedia.videolan4j.binding.internal.libvlc_media_t;
import org.watermedia.videolan4j.binding.lib.LibVlc;
import org.watermedia.videolan4j.binding.lib.LibVlcEssential;
import org.watermedia.videolan4j.discovery.NativeDiscovery;
import org.watermedia.videolan4j.tools.Buffers;
import org.watermedia.videolan4j.tools.Version;

public class VideoLan4J {
    public static final Logger LOGGER = LogManager.getLogger((String)"VideoLan4J");
    public static final String LIBVLC_NAME = Platform.isWindows() ? "libvlc" : "vlc";
    public static final String LIBVLCCORE_NAME = Platform.isWindows() ? "libvlccore" : "vlccore";
    public static final String LIBVLC_PLUGIN_ENV_NAME = "VLC_PLUGIN_PATH";
    public static final Version LIBVLC_MIN_VERSION = new Version("3.0.0");
    public static final Version LIBVLC_MAX_VERSION = new Version("3.1.0");
    public static final int LIBVLC_BUFFER_ALIGNMENT = 32;
    public static final String VLC4J_USER_DISCOVERY_PATH = System.getProperty("vlc4j.userDiscoveryPath");
    private static libvlc_instance_t DEFAULT_INSTANCE;

    public static boolean isDiscovered() {
        return NativeDiscovery.discovered() && DEFAULT_INSTANCE != null;
    }

    public static String discoveryPath() {
        return NativeDiscovery.discoveryPath();
    }

    public static libvlc_instance_t getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static synchronized boolean load(String ... defaultArgs) {
        boolean loaded = NativeDiscovery.start();
        if (loaded && DEFAULT_INSTANCE == null && (DEFAULT_INSTANCE = VideoLan4J.createInstance(defaultArgs)) == null) {
            LOGGER.error("Failed to create default libvlc instance");
            loaded = false;
        }
        return loaded;
    }

    public static libvlc_instance_t createInstance(String ... args) {
        return LibVlcEssential.libvlc_new(0, new StringArray(args));
    }

    public static void releaseInstance(libvlc_instance_t instance) {
        LibVlcEssential.libvlc_release(instance);
    }

    public static libvlc_media_player_t createMediaPlayer(libvlc_instance_t instance) {
        return LibVlc.libvlc_media_player_new(instance);
    }

    public static libvlc_media_player_t createMediaPlayer() {
        return LibVlc.libvlc_media_player_new(DEFAULT_INSTANCE);
    }

    public static void releaseMediaPlayer(libvlc_media_player_t player) {
        if (player != null) {
            LibVlc.libvlc_media_player_release(player);
        }
    }

    public static libvlc_media_t createMediaInstance(libvlc_instance_t vlc, URI uri) {
        return uri.getScheme().equals("file") ? LibVlc.libvlc_media_new_path(vlc, new File(uri.getPath()).toString()) : LibVlc.libvlc_media_new_location(vlc, uri.toString());
    }

    public static libvlc_media_t createMediaInstance(libvlc_instance_t vlc, File url) {
        return LibVlc.libvlc_media_new_path(vlc, url.toString());
    }

    public static libvlc_media_t createMediaInstance(URI uri) {
        return uri.getScheme().equals("file") ? LibVlc.libvlc_media_new_path(DEFAULT_INSTANCE, new File(uri.getPath()).toString()) : LibVlc.libvlc_media_new_location(DEFAULT_INSTANCE, uri.toString());
    }

    public static libvlc_media_t createMediaInstance(File url) {
        return LibVlc.libvlc_media_new_path(DEFAULT_INSTANCE, url.toString());
    }

    public static void releaseMediaInstance(libvlc_media_t media) {
        if (media != null) {
            LibVlc.libvlc_media_release(media);
        }
    }

    public static void checkClassLoader(ClassLoader classLoader) {
        Thread t = Thread.currentThread();
        if (t.getContextClassLoader() == null) {
            t.setContextClassLoader(classLoader);
        }
    }

    public static void setBufferAllocator(BiFunction<Integer, Integer, ByteBuffer> bufferAllocator) {
        Buffers.setBufferAllocator(bufferAllocator);
    }

    public static void setBufferDeallocator(Consumer<ByteBuffer> bufferDeallocator) {
        Buffers.setBufferDeallocator(bufferDeallocator);
    }

    public static String copyAndFreeNativeString(Pointer pointer) {
        try {
            String string = VideoLan4J.copyNativeString(pointer);
            return string;
        }
        finally {
            VideoLan4J.freeNativeString(pointer);
        }
    }

    public static void freeNativeString(Pointer pointer) {
        if (pointer != null) {
            LibVlc.libvlc_free(pointer);
        }
    }

    public static String copyNativeString(Pointer pointer) {
        return pointer != null ? pointer.getString(0L) : null;
    }

    public static Version getLibVersion() {
        return new Version(LibVlcEssential.libvlc_get_version());
    }

    public static boolean isLibSupported() {
        return VideoLan4J.getLibVersion().inRange(LIBVLC_MIN_VERSION, LIBVLC_MAX_VERSION);
    }
}

