/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.videolan4j.medialist.events;

import org.watermedia.videolan4j.binding.internal.libvlc_event_e;
import org.watermedia.videolan4j.binding.internal.libvlc_event_t;
import org.watermedia.videolan4j.binding.internal.libvlc_instance_t;
import org.watermedia.videolan4j.medialist.MediaList;
import org.watermedia.videolan4j.medialist.events.MediaListEndReachedEvent;
import org.watermedia.videolan4j.medialist.events.MediaListEvent;
import org.watermedia.videolan4j.medialist.events.MediaListItemAddedEvent;
import org.watermedia.videolan4j.medialist.events.MediaListItemDeletedEvent;
import org.watermedia.videolan4j.medialist.events.MediaListWillAddItemEvent;
import org.watermedia.videolan4j.medialist.events.MediaListWillDeleteItemEvent;

public final class MediaListEventFactory {
    public static MediaListEvent createEvent(libvlc_instance_t libvlcInstance, MediaList mediaList, libvlc_event_t event) {
        switch (libvlc_event_e.event(event.type)) {
            case libvlc_MediaListWillAddItem: {
                return new MediaListWillAddItemEvent(libvlcInstance, mediaList, event);
            }
            case libvlc_MediaListItemAdded: {
                return new MediaListItemAddedEvent(libvlcInstance, mediaList, event);
            }
            case libvlc_MediaListWillDeleteItem: {
                return new MediaListWillDeleteItemEvent(libvlcInstance, mediaList, event);
            }
            case libvlc_MediaListItemDeleted: {
                return new MediaListItemDeletedEvent(libvlcInstance, mediaList, event);
            }
            case libvlc_MediaListEndReached: {
                return new MediaListEndReachedEvent(libvlcInstance, mediaList);
            }
        }
        return null;
    }

    private MediaListEventFactory() {
    }
}

