/*
 * Decompiled with CFR 0.152.
 */
package gay.ampflower.polysit;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.logging.LogUtils;
import eu.pb4.polymer.core.api.entity.PolymerEntityUtils;
import gay.ampflower.polysit.CollisionUtil;
import gay.ampflower.polysit.JumpHeightUtil;
import gay.ampflower.polysit.SeatEntity;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.EntitySleepEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2244;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_2354;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2742;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_2778;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_5217;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class Main {
    private static final Logger logger = LogUtils.getLogger();
    public static final double HORIZONTAL_CENTER_OFFSET = 0.5;
    public static final double UPDATE_HEIGHT_OFFSET = 0.2;
    public static final double VERTICAL_SLAB_OFFSET;
    public static final double VERTICAL_FENCE_OFFSET;
    public static final double VERTICAL_SOLID_OFFSET;
    public static final double VERTICAL_CHECK_OFFSET;
    static final String VERSION_TAG_NAME = "polysit:runtimeVersion";
    static final int RUNTIME_VERSION;
    private static final double[] OFFSET_DELTA;
    public static class_1299<SeatEntity> SEAT;

    static double delta(int runtimeVersion) {
        if (runtimeVersion > RUNTIME_VERSION) {
            return -Main.sum(OFFSET_DELTA, RUNTIME_VERSION + 1, runtimeVersion);
        }
        if (runtimeVersion < RUNTIME_VERSION) {
            return Main.sum(OFFSET_DELTA, runtimeVersion + 1, RUNTIME_VERSION);
        }
        return 0.0;
    }

    private static double sum(double[] array, int from, int to) {
        double sum = 0.0;
        while (from <= to) {
            sum += array[from];
            ++from;
        }
        return sum;
    }

    public static void bootstrap() {
    }

    public static void main() {
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            if (!world.method_8608() && hand == class_1268.field_5808 && (player.method_24828() || player.method_5765() || player.method_68878()) && player.method_5998(hand).method_7960() && hitResult.method_17780() != class_2350.field_11033) {
                class_2338 pos = hitResult.method_17777();
                if (hitResult.method_24801((class_1297)player) > 25.0) {
                    return class_1269.field_5811;
                }
                class_2680 block = world.method_8320(pos);
                double topHeight = Main.getTopHeight((class_1922)world, block, pos, (class_1297)player);
                double relative = (double)pos.method_10264() + topHeight - Main.getEffectiveEntityY((class_1297)player);
                if (relative > JumpHeightUtil.maxJumpHeight((class_1309)player)) {
                    return class_1269.field_5811;
                }
                return Main.sit(world, block, pos, (class_1297)player, topHeight, false);
            }
            return class_1269.field_5811;
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"sit").executes(context -> {
            double z;
            double y;
            class_2168 source = (class_2168)context.getSource();
            class_1297 entity = source.method_9229();
            if (entity.method_5765()) {
                entity.method_5848();
                return 1;
            }
            class_1937 world = entity.method_73183();
            double ground = CollisionUtil.ground(entity);
            if (entity.method_23318() - ground > 1.0 || entity.field_6017 > (double)0.15f) {
                source.method_9213(class_2561.method_30163((String)"It appears you're trying to sit on air."));
                return 0;
            }
            class_2338 pos = ground % 1.0 == 0.0 || Main.isAir(entity.method_55667(), entity.method_24515(), entity) ? Main.blockPosOfFloored(entity.method_23317(), ground - 1.0, entity.method_23321()) : Main.blockPosOfFloored(entity.method_23317(), ground, entity.method_23321());
            class_2680 state = world.method_8320(pos);
            double topHeight = Main.getTopHeight((class_1922)world, state, pos, entity);
            if (topHeight < 0.0) {
                source.method_9213(class_2561.method_30163((String)"It appears you're trying to sit on air."));
                return 0;
            }
            if (Main.sit(world, state, pos, entity, topHeight, true).method_23665()) {
                return 1;
            }
            double x = entity.method_23317();
            if (Main.sit(world, entity, x, y = ground + VERTICAL_SOLID_OFFSET, z = entity.method_23321(), ground).method_23665()) {
                return 1;
            }
            source.method_9213(class_2561.method_30163((String)"You can't sit here, your seat is obstructed."));
            return 0;
        })));
    }

    public static double getEffectiveEntityY(class_1297 entity) {
        if (!entity.method_5765()) {
            return CollisionUtil.ground(entity);
        }
        class_2338 pos = entity.method_24515();
        class_1937 world = entity.method_73183();
        class_2680 block = world.method_8320(pos);
        double height = Main.getTopHeight((class_1922)world, block, pos, entity);
        return Math.max((double)pos.method_10264() + height, entity.method_23318());
    }

    public static double getTopHeight(class_1922 world, class_2680 state, class_2338 pos, class_1297 entity) {
        if (state.method_26215()) {
            return -1.0;
        }
        return state.method_26194(world, pos, class_3726.method_16195((class_1297)entity)).method_1105(class_2350.class_2351.field_11052);
    }

    private static boolean isAir(class_2680 state, class_2338 pos, class_1297 entity) {
        return state.method_26215() || state.method_26194((class_1922)entity.method_73183(), pos, class_3726.method_16195((class_1297)entity)).method_1110();
    }

    private static boolean maySleep(class_1297 entity, class_2338 pos) {
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            class_1269 result = ((EntitySleepEvents.AllowSleepTime)EntitySleepEvents.ALLOW_SLEEP_TIME.invoker()).allowSleepTime((class_1657)player, pos, false);
            if (result.method_23665()) {
                return true;
            }
            if (result == class_1269.field_5811) {
                return !player.method_51469().method_8530();
            }
            return false;
        }
        return !entity.method_73183().method_8530();
    }

    public static class_1269 sit(@NotNull class_1937 world, @NotNull class_2680 state, @NotNull class_2338 pos, @NotNull class_1297 entity, double topHeight, boolean command) {
        double minY = (double)pos.method_10264() + topHeight;
        if (state.method_26204() instanceof class_2510 && state.method_11654((class_2769)class_2510.field_11572) == class_2760.field_12617) {
            class_2350 direction = ((class_2350)state.method_11654((class_2769)class_2510.field_11571)).method_10153();
            class_2382 corner = switch ((class_2778)state.method_11654((class_2769)class_2510.field_11565)) {
                case class_2778.field_12712, class_2778.field_12708 -> direction.method_10160().method_62675();
                case class_2778.field_12713, class_2778.field_12709 -> direction.method_10170().method_62675();
                default -> class_2382.field_11176;
            };
            double x = (double)pos.method_10263() + 0.5 + (double)(direction.method_10148() + corner.method_10263()) * 0.2;
            double y = (double)pos.method_10264() + VERTICAL_SLAB_OFFSET;
            double z = (double)pos.method_10260() + 0.5 + (double)(direction.method_10165() + corner.method_10260()) * 0.2;
            return Main.sit(world, entity, x, y, z, minY);
        }
        if (state.method_26204() instanceof class_2482 && state.method_11654((class_2769)class_2482.field_11501) == class_2771.field_12681) {
            double x = (double)pos.method_10263() + 0.5;
            double y = (double)pos.method_10264() + VERTICAL_SLAB_OFFSET;
            double z = (double)pos.method_10260() + 0.5;
            return Main.sit(world, entity, x, y, z, minY);
        }
        if (state.method_26204() instanceof class_2244 && !Main.maySleep(entity, pos)) {
            if (!command && entity instanceof class_3222) {
                class_2338 head;
                class_3222 player = (class_3222)entity;
                if (!class_2244.method_27352((class_1937)world)) {
                    return class_1269.field_5811;
                }
                if (state.method_11654((class_2769)class_2244.field_9967) == class_2742.field_12560) {
                    head = pos;
                } else {
                    head = pos.method_10093((class_2350)state.method_11654((class_2769)class_2244.field_11177));
                    if (!world.method_8320(head).method_27852(state.method_26204())) {
                        head = null;
                    }
                }
                if (head != null && ((EntitySleepEvents.AllowSettingSpawn)EntitySleepEvents.ALLOW_SETTING_SPAWN.invoker()).allowSettingSpawn((class_1657)player, head)) {
                    class_5217.class_12064 spawnPoint = class_5217.class_12064.method_74895((class_5321)world.method_27983(), (class_2338)head, (float)player.method_36454(), (float)player.method_36455());
                    player.method_26284(new class_3222.class_10766(spawnPoint, false), true);
                }
            }
            double x = (double)pos.method_10263() + 0.5;
            double y = (double)pos.method_10264() + Main.getTopHeight((class_1922)world, state, pos, entity) + VERTICAL_SOLID_OFFSET;
            double z = (double)pos.method_10260() + 0.5;
            return Main.sit(world, entity, x, y, z, minY);
        }
        if (command && (state.method_26204() instanceof class_2354 || state.method_26204() instanceof class_2349)) {
            double x = (double)pos.method_10263() + 0.5;
            double y = (double)pos.method_10264() + VERTICAL_FENCE_OFFSET;
            double z = (double)pos.method_10260() + 0.5;
            return Main.sit(world, entity, x, y, z, minY);
        }
        return class_1269.field_5811;
    }

    public static class_1269 sit(class_1937 world, class_1297 entity, double seatX, double seatY, double seatZ, double minY) {
        SeatEntity seat = new SeatEntity(world, seatX, seatY, seatZ);
        if (seat.isDiscardable() || !CollisionUtil.isClear(entity, seat, minY)) {
            seat.method_31472();
            return class_1269.field_5811;
        }
        if (!world.method_8649((class_1297)seat)) {
            seat.method_31472();
            return class_1269.field_5814;
        }
        entity.method_5804((class_1297)seat);
        return class_1269.field_5812;
    }

    public static <T extends class_1297> class_1299<T> registerEntity(String id, class_1299.class_1300<T> type) {
        class_2960 identifier = class_2960.method_60654((String)id);
        class_1299 built = type.method_5905(class_5321.method_29179((class_5321)class_7924.field_41266, (class_2960)identifier));
        class_2378.method_10230((class_2378)class_7923.field_41177, (class_2960)identifier, (Object)built);
        PolymerEntityUtils.registerType((class_1299[])new class_1299[]{built});
        return built;
    }

    public static class_2338 blockPosOfFloored(double x, double y, double z) {
        return new class_2338(class_3532.method_15357((double)x), class_3532.method_15357((double)y), class_3532.method_15357((double)z));
    }

    public static class_2338 blockPosOfFloored(class_243 vec3d) {
        return Main.blockPosOfFloored(vec3d.field_1352, vec3d.field_1351, vec3d.field_1350);
    }

    static class_2960 id(String value) {
        return class_2960.method_60655((String)"polysit", (String)value);
    }

    static {
        OFFSET_DELTA = new double[]{0.0, 0.2};
        int currentVersion = 4554;
        double verticalSolidOffset = -0.2;
        double verticalSlabOffset = 0.3;
        double verticalFenceOffset = 0.8;
        int updateChangingOffset = 3572;
        VERTICAL_SLAB_OFFSET = 0.5;
        VERTICAL_FENCE_OFFSET = 1.0;
        VERTICAL_SOLID_OFFSET = 0.0;
        VERTICAL_CHECK_OFFSET = -0.2;
        RUNTIME_VERSION = 1;
        SEAT = Main.registerEntity("polysit:seat", class_1299.class_1300.method_5903(SeatEntity::new, (class_1311)class_1311.field_17715).method_17687(0.0f, 0.0f).method_27299(10).method_5901().method_19947());
    }
}

