/*
 * Decompiled with CFR 0.152.
 */
package gay.ampflower.polysit;

import com.mojang.logging.LogUtils;
import gay.ampflower.polysit.JumpHeightUtil;
import gay.ampflower.polysit.mixin.AccessorEntity;
import java.util.Iterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.class_1297;
import net.minecraft.class_238;
import net.minecraft.class_265;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class CollisionUtil {
    private static final Logger logger = LogUtils.getLogger();

    public static FittingPosition adjustFit(class_1297 entity, double x, double y, double z) {
        double max = y + JumpHeightUtil.maxJumpHeight(entity) + (double)entity.method_17682();
        double min = y;
        class_238 box = CollisionUtil.getSmallestPose(entity, x, y, z);
        Iterator itr = CollisionUtil.collisionBoxStream(entity, box.method_35578(max)).iterator();
        while (itr.hasNext()) {
            class_238 bound = (class_238)itr.next();
            if (!bound.method_994(box)) {
                max = Math.min(max, bound.field_1322);
                continue;
            }
            box = box.method_989(0.0, bound.field_1325 - min, 0.0);
            min = bound.field_1325;
        }
        return new FittingPosition(min, CollisionUtil.getLargestFittingPose(entity, max - min));
    }

    public static class_238 getSmallestPose(class_1297 entity, double x, double y, double z) {
        return CollisionUtil.getSmallestPose(entity).method_30231(x, y, z);
    }

    public static class_4048 getSmallestPose(class_1297 entity) {
        class_4048 standing = entity.method_18377(entity.method_18376());
        class_4048 sneaking = entity.method_18377(class_4050.field_18081);
        class_4048 swimming = entity.method_18377(class_4050.field_18079);
        return CollisionUtil.smallest(standing, sneaking, swimming);
    }

    public static class_4050 getLargestFittingPose(class_1297 entity, double y) {
        return CollisionUtil.largest(entity, y, entity.method_18376(), class_4050.field_18076, class_4050.field_18081, class_4050.field_18079);
    }

    @NotNull
    public static class_4048 smallest(class_4048 ... dimensions) {
        if (dimensions.length == 0) {
            throw new IllegalArgumentException("length == 0");
        }
        class_4048 min = dimensions[0];
        for (int i = 1; i < dimensions.length; ++i) {
            class_4048 comparison = dimensions[i];
            if (!(comparison.comp_2186() < min.comp_2186()) || !(comparison.comp_2185() <= min.comp_2185())) continue;
            min = comparison;
        }
        return min;
    }

    @Nullable
    private static class_4050 largest(class_1297 entity, double maxHeight, class_4050 ... poses) {
        if (poses.length == 0) {
            throw new IllegalArgumentException("poses.length == 0");
        }
        double height = 0.0;
        class_4050 fittingPose = null;
        for (class_4050 pose : poses) {
            float poseHeight = entity.method_18377(pose).comp_2186();
            if (!((double)poseHeight < maxHeight) || !((double)poseHeight > height)) continue;
            height = poseHeight;
            fittingPose = pose;
        }
        return fittingPose;
    }

    public static double ground(class_1297 entity) {
        double maxY = entity.method_23318();
        double minY = maxY - JumpHeightUtil.maxJumpHeight(entity);
        class_238 box = CollisionUtil.box(entity.method_23317(), minY, entity.method_23321(), entity.method_17681(), maxY);
        return CollisionUtil.collisionBoxStream(entity, box).mapToDouble(b -> b.field_1325).max().orElse(Double.NEGATIVE_INFINITY);
    }

    public static boolean isClear(class_1297 entity, class_1297 seat, double minY) {
        double maxY = CollisionUtil.getEffectiveSittingHeight(entity, seat);
        class_238 box = CollisionUtil.box(seat.method_23317(), minY, seat.method_23321(), entity.method_17681(), seat.method_23318() + maxY);
        return !CollisionUtil.collisions(entity, box).iterator().hasNext();
    }

    public static class_238 box(double x, double y, double z, double w, double my) {
        return new class_238(x - (w /= 2.0), y, z - w, x + w, my, z + w);
    }

    private static double getEffectiveSittingHeight(class_1297 entity, class_1297 seat) {
        class_4050 prevPose = entity.method_18376();
        class_1297 prevVehicle = entity.method_5854();
        AccessorEntity accessor = (AccessorEntity)entity;
        entity.method_18380(class_4050.field_40118);
        accessor.setVehicle(seat);
        double height = (double)entity.method_17682() - entity.method_55668(seat).method_10214();
        accessor.setVehicle(prevVehicle);
        entity.method_18380(prevPose);
        return height;
    }

    private static Stream<class_238> collisionBoxStream(class_1297 entity, class_238 box) {
        return CollisionUtil.collisionStream(entity, box).flatMap(voxel -> voxel.method_1090().stream()).filter(arg_0 -> ((class_238)box).method_994(arg_0));
    }

    private static Stream<class_265> collisionStream(class_1297 entity, class_238 box) {
        return StreamSupport.stream(entity.method_37908().method_20812(entity, box).spliterator(), false);
    }

    private static Iterable<class_265> collisions(class_1297 entity, class_238 box) {
        return entity.method_37908().method_20812(entity, box);
    }

    public record FittingPosition(double y, class_4050 pose) {
    }
}

