/*
 * Decompiled with CFR 0.152.
 */
package net.bytzo.sessility.mixins;

import com.mojang.authlib.GameProfile;
import net.bytzo.sessility.ComponentUtils;
import net.bytzo.sessility.SessilePlayer;
import net.bytzo.sessility.Sessility;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2596;
import net.minecraft.class_268;
import net.minecraft.class_270;
import net.minecraft.class_2703;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3222.class})
public abstract class ServerPlayerMixin
extends class_1657
implements SessilePlayer {
    @Shadow
    @Final
    public MinecraftServer field_13995;
    @Unique
    private boolean sessile = false;
    @Unique
    private long lastMotileTime = class_156.method_658();

    public ServerPlayerMixin(class_1937 level, GameProfile gameProfile) {
        super(level, gameProfile);
    }

    @Inject(method={"tick()V"}, at={@At(value="RETURN")})
    private void postTick(CallbackInfo callbackInfo) {
        int timeout;
        if (Sessility.settings().properties().sessileTimeout <= 0 || this.sessile) {
            return;
        }
        long idleTime = class_156.method_658() - this.lastMotileTime;
        if (idleTime > (long)(timeout = Sessility.settings().properties().sessileTimeout * 1000)) {
            this.setSessile(true);
        }
    }

    @Inject(method={"resetLastActionTime()V"}, at={@At(value="HEAD")})
    private void preResetLastActionTime(CallbackInfo callbackInfo) {
        if (Sessility.settings().properties().detectAction) {
            this.setSessile(false);
        }
    }

    @Inject(method={"getTabListDisplayName()Lnet/minecraft/network/chat/Component;"}, at={@At(value="RETURN")}, cancellable=true)
    private void postGetTabListDisplayName(CallbackInfoReturnable<class_2561> callbackInfo) {
        if (this.sessile) {
            class_5250 profileName = class_2561.method_43470((String)this.method_7334().name());
            class_5250 teamFormattedName = class_268.method_1142((class_270)this.method_5781(), (class_2561)profileName);
            class_5250 displayName = teamFormattedName.method_27696(class_2583.field_24360.method_27703(Sessility.settings().properties().sessileDisplayColor));
            callbackInfo.setReturnValue((Object)displayName);
        }
    }

    @Override
    @Unique
    public void setSessile(boolean sessile) {
        if (!sessile) {
            this.lastMotileTime = class_156.method_658();
        }
        if (sessile != this.sessile) {
            class_2561 broadcastMessage;
            this.sessile = sessile;
            this.broadcastDisplayName();
            if (Sessility.settings().properties().hideSessileInTabList) {
                this.broadcastPlayerListed();
            }
            class_2561 class_25612 = broadcastMessage = sessile ? Sessility.settings().properties().messageSessile : Sessility.settings().properties().messageMotile;
            if (!ComponentUtils.isEmptyContents(broadcastMessage)) {
                String profileName = this.method_7334().name();
                class_2561 argMessage = ComponentUtils.componentWithArgs(broadcastMessage, profileName);
                this.field_13995.method_3760().method_43514(argMessage, false);
            }
        }
    }

    @Override
    @Unique
    public boolean isSessile() {
        return this.sessile;
    }

    @Unique
    private void broadcastDisplayName() {
        class_2703 packet = new class_2703(class_2703.class_5893.field_29139, (class_3222)this);
        this.field_13995.method_3760().method_14581((class_2596)packet);
    }

    @Unique
    private void broadcastPlayerListed() {
        class_2703 packet = new class_2703(class_2703.class_5893.field_40700, (class_3222)this);
        this.field_13995.method_3760().method_14581((class_2596)packet);
    }
}

