package me.pajic.smbs.mixin;

import me.pajic.smbs.SMBS;
import me.pajic.smbs.util.MobExtension;
import me.pajic.smbs.system.BuffHandler;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import net.minecraft.world.entity.*;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1308.class)
public abstract class MobMixin extends class_1309 implements MobExtension {
    protected MobMixin(class_1299<? extends class_1309> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Unique private int smbs$buffLevel = 0;
    @Unique private int smbs$maxBuffLevel = 0;
    @Unique private boolean smbs$shouldDropRewards = false;
    @Unique private final class_1308 smbs$thisMob = (class_1308) (Object) this;
    @Unique private Boolean smbs$fromSpawner = null;
    @Unique private boolean smbs$buffApplyAttempted = false;

    /**
     * @author pajic
     * @reason Gets the reason for the mob spawn for later checking.
     */
    @Inject(
            method = "finalizeSpawn",
            at = @At("HEAD")
    )
    private void getSpawnReason(class_5425 level, class_1266 difficulty, /*? if 1.21.1 {*//*MobSpawnType spawnType*//*?} else {*/class_3730 spawnType/*?}*/, class_1315 spawnGroupData, CallbackInfoReturnable<class_1315> cir) {
        smbs$fromSpawner = /*? if 1.21.1 {*//*MobSpawnType*//*?} else {*/class_3730/*?}*/.method_54986(spawnType);
    }

    /**
     * @author pajic
     * @reason Once the mob starts ticking, invokes the mob buff system to apply mob buffs,
     * if buff application hasn't been attempted yet and the mob didn't spawn from a spawner.
     */
    @SuppressWarnings("resource")
    @Inject(
            method = "tick",
            at = @At("HEAD")
    )
    private void applyBuffs(CallbackInfo ci) {
        if (!method_73183().method_8608() && !smbs$buffApplyAttempted && smbs$fromSpawner != null) {
            smbs$buffApplyAttempted = true;
            if (SMBS.CONFIG.allowBuffedMobsFromSpawners.get() || !smbs$fromSpawner) {
                BuffHandler.applyBuffs(smbs$thisMob, (class_3218) method_73183(), (/*? if >=1.21.11 {*/(class_3218)/*?}*/method_73183()).method_8404(smbs$thisMob.method_23312()));
            }
        }
    }

    /**
     * @author pajic
     * @reason Once the mob is killed, invokes the mob buff system to drop XP and loot based on the mob's buff level.
     */
    @Inject(
            method = "dropCustomDeathLoot",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/LivingEntity;dropCustomDeathLoot(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/damagesource/DamageSource;Z)V"
            )
    )
    private void dropRewards(class_3218 level, class_1282 damageSource, boolean recentlyHit, CallbackInfo ci) {
        BuffHandler.dropRewards(smbs$thisMob, /*? if 1.21.1 {*//*lastHurtByPlayerTime*//*?} else {*/field_6238/*?}*/, level);
    }

    @Override
    public int smbs$getBuffLevel() {
        return smbs$buffLevel;
    }

    @Override
    public void smbs$increaseBuffLevel(int increase) {
        smbs$buffLevel += increase;
    }

    @Override
    public int smbs$getMaxBuffLevel() {
        return smbs$maxBuffLevel;
    }

    @Override
    public void smbs$increaseMaxBuffLevel(int increase) {
        smbs$maxBuffLevel += increase;
    }

    @Override
    public boolean smbs$getShouldDropRewards() {
        return smbs$shouldDropRewards;
    }

    @Override
    public void smbs$setShouldDropRewards(boolean shouldDropRewards) {
        this.smbs$shouldDropRewards = shouldDropRewards;
    }

    //? if 1.21.1 {
    /*@Inject(
            method = "addAdditionalSaveData",
            at = @At("TAIL")
    )
    private void save(CompoundTag compound, CallbackInfo ci) {
        compound.putInt("BuffLevel", smbs$buffLevel);
        compound.putInt("MaxBuffLevel", smbs$maxBuffLevel);
        compound.putBoolean("ShouldDropRewards", smbs$shouldDropRewards);
        compound.putBoolean("BuffApplyAttempted", smbs$buffApplyAttempted);
    }

    @Inject(
            method = "readAdditionalSaveData",
            at = @At("TAIL")
    )
    private void load(CompoundTag compound, CallbackInfo ci) {
		smbs$buffLevel = compound.getInt("BuffLevel");
		smbs$maxBuffLevel = compound.getInt("MaxBuffLevel");
		smbs$shouldDropRewards = compound.getBoolean("ShouldDropRewards");
		smbs$buffApplyAttempted = compound.getBoolean("BuffApplyAttempted");
    }
    *///?} else {
    @Inject(
            method = "addAdditionalSaveData",
            at = @At("TAIL")
    )
    private void save(class_11372 output, CallbackInfo ci) {
        output.method_71465("BuffLevel", smbs$buffLevel);
        output.method_71465("MaxBuffLevel", smbs$maxBuffLevel);
        output.method_71472("ShouldDropRewards", smbs$shouldDropRewards);
        output.method_71472("BuffApplyAttempted", smbs$buffApplyAttempted);
    }

    @Inject(
            method = "readAdditionalSaveData",
            at = @At("TAIL")
    )
    private void load(class_11368 input, CallbackInfo ci) {
        smbs$buffLevel = input.method_71424("BuffLevel", 0);
        smbs$maxBuffLevel = input.method_71424("MaxBuffLevel", 0);
        smbs$shouldDropRewards = input.method_71433("ShouldDropRewards", false);
        smbs$buffApplyAttempted = input.method_71433("BuffApplyAttempted", true);
    }
    //?}
}
