package me.pajic.smbs.mixin;

import me.pajic.smbs.SMBS;
import me.pajic.smbs.util.AttachmentUtil;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1642;
import net.minecraft.class_1937;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1642.class)
public abstract class ZombieMixin extends class_1308 {
    protected ZombieMixin(class_1299<? extends class_1308> entityType, class_1937 level) {
        super(entityType, level);
    }

    /**
     * @author pajic
     * @reason Saves a boolean value to entity data indicating whether the zombie is a leader or not,
     * for use in the mob buff system. Also heals the zombie to max health to fix a vanilla bug.
     */
    @Inject(
            method = "handleAttributes",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/monster/zombie/Zombie;setCanBreakDoors(Z)V"
            )
    )
    private void markLeader(float difficulty, CallbackInfo ci) {
        method_6025(method_6063());
		AttachmentUtil.setLeader((class_1642) (Object) this);
        SMBS.debugLog(
                "Leader {} at {} {} {}",
                method_5477().getString(), method_23317(), method_23318(), method_23321()
        );
    }
}
