package me.pajic.smbs.system;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import me.fzzyhmstrs.fzzy_config.validation.collection.ValidatedMap;
import me.fzzyhmstrs.fzzy_config.validation.collection.ValidatedSet;
import me.pajic.smbs.SMBS;
import me.pajic.smbs.util.AttachmentUtil;
import me.pajic.smbs.util.MobExtension;
import net.minecraft.class_1266;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1303;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_156;
import net.minecraft.class_1642;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1928;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9636;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class BuffHandler {

    /**
     * Applies buffs to the mob according to data from the mod configuration and current local difficulty in the world.
     * @param mob The mob which the buffs are being applied to.
     * @param levelAccessor Server world accessor.
     * @param difficulty World difficulty data.
     */
    public static void applyBuffs(class_1308 mob, class_5425 levelAccessor, class_1266 difficulty) {
        class_5819 random = levelAccessor.method_8409();
        ((MobExtension) mob).smbs$setShouldDropRewards(true);
        class_2960 mobTypeKey = class_7923.field_41177.method_10221(mob.method_5864());
        Set<BuffEntry> possibleBuffEntries = new HashSet<>();
		SMBS.CONFIG.buffRules.forEach((buffEntry, mobTypeKeys) -> {
            if (mobTypeKeys.contains(mobTypeKey)) possibleBuffEntries.add(buffEntry);
        });
        Object2IntArrayMap<class_6880<class_1291>> buffs = getBuffs(possibleBuffEntries, mob);
        if (roll(random, difficulty, SMBS.CONFIG.minSpawnChance.get(), SMBS.CONFIG.maxSpawnChance.get())) {
            // Apply buffs and increase buff level for each buff
            buffs.forEach((mobEffect, i) -> {
                if (roll(random, difficulty, SMBS.CONFIG.minChancePerBuff.get(), SMBS.CONFIG.maxChancePerBuff.get())) {
                    int maxAmplifier = i - 1;
                    int amplifier = class_3532.method_15340(
                            Math.round(difficulty.method_5458() * random.method_43057() * maxAmplifier * maxAmplifier),
                            0, maxAmplifier
                    );
                    mob.method_6092(new class_1293(mobEffect, -1, amplifier));
                    ((MobExtension) mob).smbs$increaseBuffLevel(1 + amplifier);
                }
            });
        }
        // Increase current and max buff level for each enchanted piece of equipment
        // Max buff level is increased too because we don't want this increase to
        // contribute to the enchanted book drop chance
        int increase = 0;
        if (getWeapon(mob).method_7942()) increase++;
        if (mob.method_6118(class_1304.field_6169).method_7942()) increase++;
        if (mob.method_6118(class_1304.field_6174).method_7942()) increase++;
        if (mob.method_6118(class_1304.field_6172).method_7942()) increase++;
        if (mob.method_6118(class_1304.field_6166).method_7942()) increase++;
        ((MobExtension) mob).smbs$increaseBuffLevel(increase);
        ((MobExtension) mob).smbs$increaseMaxBuffLevel(increase);
        // Increase current buff level if mob is a zombie leader
        boolean isLeader = false;
        if (mob instanceof class_1642 zombie && AttachmentUtil.isLeader(zombie)) {
            ((MobExtension) mob).smbs$increaseBuffLevel(6);
            isLeader = true;
        }
        // If mob has a health buff make sure it spawns with max possible health
        if (mob.method_6063() > 20.0F) mob.method_6025(mob.method_6063());

        if (((MobExtension) mob).smbs$getBuffLevel() > 0) SMBS.debugLog(
                "Buff level {} mob {} at {} {} {}\nArmor bonus: {}\nLeader: {}",
                ((MobExtension) mob).smbs$getBuffLevel(), mob.method_5477().getString(), mob.method_23317(), mob.method_23318(), mob.method_23321(), increase, isLeader
        );
    }

    private static boolean roll(class_5819 random, class_1266 difficulty, float minPercent, float maxPercent) {
        return random.method_43057() < class_3532.method_16439(getNormalizedDifficulty(difficulty), minPercent / 100, maxPercent / 100);
    }

    private static float getNormalizedDifficulty(class_1266 difficulty) {
        return difficulty.method_5457() < 2 ? 0 : (difficulty.method_5457() - 2) / 4.75F;
    }

    /**
     * Drops custom loot based on how high the buff level of the mob is.
     * @param mob The mob which is dropping the loot.
     * @param lastHurtByPlayerTime Time since the mob was last hit by the player.
     * @param level The current server world.
     */
    public static void dropRewards(class_1308 mob, int lastHurtByPlayerTime, class_3218 level) {
        if (((MobExtension) mob).smbs$getShouldDropRewards() && lastHurtByPlayerTime > 0 && mobsDropLoot(level)) {
            // Determine max possible buff level
            class_2960 mobTypeKey = class_7923.field_41177.method_10221(mob.method_5864());
            Set<BuffEntry> possibleBuffEntries = new HashSet<>();
			SMBS.CONFIG.buffRules.forEach((buffEntry, mobTypeKeys) -> {
                if (mobTypeKeys.contains(mobTypeKey)) possibleBuffEntries.add(buffEntry);
            });
            getBuffs(possibleBuffEntries, mob).forEach((mobEffect, i) -> ((MobExtension) mob).smbs$increaseMaxBuffLevel(i));

            int maxBuffLevel = ((MobExtension) mob).smbs$getMaxBuffLevel();
            int buffLevel = ((MobExtension) mob).smbs$getBuffLevel();
            int buffLevelThreshold = Math.round(maxBuffLevel * (SMBS.CONFIG.enchantedBookThresholdPercentage.get() / 100));
            // Increase equipment drop chances
            if (SMBS.CONFIG.increasedEquipmentDropChancePerBuff.get()) for (class_1304 slot : class_1304.values()) {
                mob.method_5946(slot, getDropChanceForSlot(mob, slot) * class_3532.method_16439(
                        (float) buffLevel / maxBuffLevel, 1F, SMBS.CONFIG.maxEquipmentDropChanceIncrease.get()
                ));
            }
            // Drop enchanted book
            if (buffLevel > buffLevelThreshold) {
                List<class_6880<class_1887>> enchantments = new ArrayList<>();
                level.method_30349().method_30530(class_7924.field_41265).method_46735(class_9636.field_51550).forEach(enchantments::add);
                class_156.method_40083(enchantments, level.field_9229).ifPresent(enchantment -> {
                    int i = class_3532.method_15395(
                            level.method_8409(), enchantment.comp_349().method_8187(),
                            Math.min(buffLevel - buffLevelThreshold + 2, enchantment.comp_349().method_8183())
                    );
                    class_1799 book = new class_1799(class_1802.field_8598);
                    book.method_7978(enchantment, i);
                    mob.method_5775(/*? if > 1.21.1 {*/level,/*?}*/ book);
                });
            }
            // Drop XP orbs
            if (buffLevel > 0) {
                for (int i = 0; i < buffLevel; i++) {
                    level.method_8649(new class_1303(level, mob.method_23317(), mob.method_23318(), mob.method_23321(), SMBS.CONFIG.xpPerBuffLevel.get()));
                }
				SMBS.debugLog(
                        "\nCurrent buff level: {}\nLevel required for book: {}\nMaximum buff level: {}",
                        buffLevel, buffLevelThreshold + 1, maxBuffLevel
                );
            }
        }
    }

    private static Object2IntArrayMap<class_6880<class_1291>> getBuffs(Set<BuffEntry> possibleBuffEntries, class_1308 mob) {
        Object2IntArrayMap<class_6880<class_1291>> buffs = new Object2IntArrayMap<>();
        class_1799 weapon = getWeapon(mob);
        possibleBuffEntries.forEach(buffEntry -> {
            switch (buffEntry.buffSetType.get()) {
                case WEAPON_BASED -> {
                    switch (buffEntry.weaponType.get()) {
                        case ANY -> {
                            if (isRangedWeapon(weapon)) addBuffs(buffs, SMBS.CONFIG.defaultRangedBuffs);
                            else addBuffs(buffs, SMBS.CONFIG.defaultMeleeBuffs);
                        }
                        case MELEE -> {
                            if (isMeleeWeapon(weapon)) addBuffs(buffs, SMBS.CONFIG.defaultMeleeBuffs);
                        }
                        case RANGED -> {
                            if (isRangedWeapon(weapon)) addBuffs(buffs, SMBS.CONFIG.defaultRangedBuffs);
                        }
                        case CUSTOM -> {

                        }
                    }
                }
                case CUSTOM -> {
                    switch (buffEntry.weaponType.get()) {
                        case ANY -> addBuffs(buffs, buffEntry.customBuffs);
                        case MELEE -> {
                            if (isMeleeWeapon(weapon)) addBuffs(buffs, buffEntry.customBuffs);
                        }
                        case RANGED -> {
                            if (isRangedWeapon(weapon)) addBuffs(buffs, buffEntry.customBuffs);
                        }
                        case CUSTOM -> {
                            if (weaponMatches(weapon, buffEntry.customWeapons)) addBuffs(buffs, buffEntry.customBuffs);
                        }
                    }
                }
            }
        });
        return buffs;
    }

    private static void addBuffs(Object2IntArrayMap<class_6880<class_1291>> buffs, ValidatedMap<class_2960, Integer> addition) {
        addition.forEach((rl, i) -> buffs.put(
                class_7923.field_41174./*? if < 1.21.8 {*//*getHolder*//*?} else {*/method_10223/*?}*/(rl).orElseThrow(), i.intValue())
        );
    }

    private static class_1799 getWeapon(class_1308 mob) {
        class_1799 mainHand = mob.method_6047();
        class_1799 offHand = mob.method_6079();
        return mainHand.method_7960() ? offHand : mainHand;
    }

    private static boolean weaponMatches(class_1799 stack, ValidatedSet<String> keys) {
        Set<class_1792> items = new HashSet<>();
        Set<class_6862<class_1792>> itemTags = new HashSet<>();
        keys.forEach(string -> {
            if (string.startsWith("#")) itemTags.add(class_6862.method_40092(class_7924.field_41197, class_2960.method_60654(string.substring(1))));
            else items.add(class_7923.field_41178.method_17966(class_2960.method_60654(string)).orElseThrow());
        });
        return items.contains(stack.method_7909()) ||
                itemTags.stream().anyMatch(itemTag -> class_7923.field_41178
                        ./*? if 1.21.1 {*//*getTag*//*?} else {*/method_46733/*?}*/(itemTag).orElseThrow().method_40241(stack.method_41409())
                );
    }

    private static float getDropChanceForSlot(class_1308 mob, class_1304 slot) {
        //? if > 1.21.1 {
        return mob.method_66286().method_66240(slot);
        //?} else {
        /*return switch (slot.getType()) {
            case HAND -> mob.handDropChances[slot.getIndex()];
            case HUMANOID_ARMOR -> mob.armorDropChances[slot.getIndex()];
            case ANIMAL_ARMOR -> mob.bodyArmorDropChance;
        };
        *///?}
    }

	private static boolean mobsDropLoot(class_3218 level) {
		//? if < 1.21.11
		//return level.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT);
		//? if >= 1.21.11
		return level.method_64395().method_76185(class_1928.field_19391);
	}

    private static boolean isMeleeWeapon(class_1799 stack) {
        return weaponMatches(stack, SMBS.CONFIG.meleeWeapons);
    }

    private static boolean isRangedWeapon(class_1799 stack) {
        return weaponMatches(stack, SMBS.CONFIG.rangedWeapons);
    }
}
