/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.smbs.system;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import me.fzzyhmstrs.fzzy_config.validation.collection.ValidatedMap;
import me.fzzyhmstrs.fzzy_config.validation.collection.ValidatedSet;
import me.pajic.smbs.Main;
import me.pajic.smbs.system.BuffEntry;
import me.pajic.smbs.system.BuffSetType;
import me.pajic.smbs.system.WeaponType;
import me.pajic.smbs.util.MobExtension;
import me.pajic.smbs.util.ZombieExtension;
import net.minecraft.class_1266;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_156;
import net.minecraft.class_1642;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9636;

public class BuffHandler {
    public static void applyBuffs(class_1308 mob, class_5425 levelAccessor, class_1266 difficulty) {
        class_5819 random = levelAccessor.method_8409();
        ((MobExtension)mob).smbs$setShouldDropRewards(true);
        class_2960 mobTypeKey = class_7923.field_41177.method_10221((Object)mob.method_5864());
        HashSet<BuffEntry> possibleBuffEntries = new HashSet<BuffEntry>();
        Main.CONFIG.buffRules.forEach((buffEntry, mobTypeKeys) -> {
            if (mobTypeKeys.contains(mobTypeKey)) {
                possibleBuffEntries.add((BuffEntry)buffEntry);
            }
        });
        Object2IntArrayMap<class_6880<class_1291>> buffs = BuffHandler.getBuffs(possibleBuffEntries, mob);
        if (BuffHandler.roll(random, difficulty, ((Float)Main.CONFIG.minSpawnChance.get()).floatValue(), ((Float)Main.CONFIG.maxSpawnChance.get()).floatValue())) {
            buffs.forEach((mobEffect, i) -> {
                if (BuffHandler.roll(random, difficulty, ((Float)Main.CONFIG.minChancePerBuff.get()).floatValue(), ((Float)Main.CONFIG.maxChancePerBuff.get()).floatValue())) {
                    int maxAmplifier = i - 1;
                    int amplifier = class_3532.method_15340((int)Math.round(difficulty.method_5458() * random.method_43057() * (float)maxAmplifier * (float)maxAmplifier), (int)0, (int)maxAmplifier);
                    mob.method_6092(new class_1293(mobEffect, -1, amplifier));
                    ((MobExtension)mob).smbs$increaseBuffLevel(1 + amplifier);
                }
            });
        }
        if (mob.method_6063() > 20.0f) {
            mob.method_6025(mob.method_6063());
        }
        if (((MobExtension)mob).smbs$getBuffLevel() > 0) {
            Main.debugLog("Buff level {} mob {} at {} {} {}", ((MobExtension)mob).smbs$getBuffLevel(), mob.method_5477().getString(), mob.method_23317(), mob.method_23318(), mob.method_23321());
        }
    }

    private static boolean roll(class_5819 random, class_1266 difficulty, float minPercent, float maxPercent) {
        return random.method_43057() < class_3532.method_16439((float)BuffHandler.getNormalizedDifficulty(difficulty), (float)(minPercent / 100.0f), (float)(maxPercent / 100.0f));
    }

    private static float getNormalizedDifficulty(class_1266 difficulty) {
        return difficulty.method_5457() < 2.0f ? 0.0f : (difficulty.method_5457() - 2.0f) / 4.75f;
    }

    public static void dropRewards(class_1308 mob, int lastHurtByPlayerTime, class_3218 level) {
        if (((MobExtension)mob).smbs$getShouldDropRewards() && lastHurtByPlayerTime > 0 && level.method_8450().method_8355(class_1928.field_19391)) {
            class_1642 zombie;
            class_2960 mobTypeKey = class_7923.field_41177.method_10221((Object)mob.method_5864());
            HashSet<BuffEntry> possibleBuffEntries = new HashSet<BuffEntry>();
            Main.CONFIG.buffRules.forEach((buffEntry, mobTypeKeys) -> {
                if (mobTypeKeys.contains(mobTypeKey)) {
                    possibleBuffEntries.add((BuffEntry)buffEntry);
                }
            });
            BuffHandler.getBuffs(possibleBuffEntries, mob).forEach((mobEffect, i) -> ((MobExtension)mob).smbs$increaseMaxBuffLevel((int)i));
            boolean isLeader = false;
            if (mob instanceof class_1642 && ((ZombieExtension)(zombie = (class_1642)mob)).smbs$isLeader()) {
                ((MobExtension)mob).smbs$increaseBuffLevel(6);
                isLeader = true;
            }
            int increase = 0;
            if (BuffHandler.getWeapon(mob).method_7942()) {
                ++increase;
            }
            if (mob.method_6118(class_1304.field_6169).method_7942()) {
                ++increase;
            }
            if (mob.method_6118(class_1304.field_6174).method_7942()) {
                ++increase;
            }
            if (mob.method_6118(class_1304.field_6172).method_7942()) {
                ++increase;
            }
            if (mob.method_6118(class_1304.field_6166).method_7942()) {
                ++increase;
            }
            ((MobExtension)mob).smbs$increaseBuffLevel(increase);
            ((MobExtension)mob).smbs$increaseMaxBuffLevel(increase);
            int maxBuffLevel = ((MobExtension)mob).smbs$getMaxBuffLevel();
            int buffLevel = ((MobExtension)mob).smbs$getBuffLevel();
            int buffLevelThreshold = Math.round((float)maxBuffLevel * (((Float)Main.CONFIG.enchantedBookThresholdPercentage.get()).floatValue() / 100.0f));
            if (buffLevel > buffLevelThreshold) {
                ArrayList enchantments = new ArrayList();
                level.method_30349().method_46762(class_7924.field_41265).method_46735(class_9636.field_51550).forEach(enchantments::add);
                class_156.method_40083(enchantments, (class_5819)level.field_9229).ifPresent(enchantment -> {
                    int i = class_3532.method_15395((class_5819)level.method_8409(), (int)((class_1887)enchantment.comp_349()).method_8187(), (int)Math.min(buffLevel - buffLevelThreshold + 2, ((class_1887)enchantment.comp_349()).method_8183()));
                    class_1799 book = new class_1799((class_1935)class_1802.field_8598);
                    book.method_7978(enchantment, i);
                    mob.method_5775(book);
                });
            }
            if (buffLevel > 0) {
                for (int i2 = 0; i2 < buffLevel; ++i2) {
                    level.method_8649((class_1297)new class_1303((class_1937)level, mob.method_23317(), mob.method_23318(), mob.method_23321(), ((Integer)Main.CONFIG.xpPerBuffLevel.get()).intValue()));
                }
                Main.debugLog("\nCurrent buff level: {}\nLevel required for book: {}\nMaximum buff level: {}\nArmor bonus: {}\nLeader: {}", buffLevel, buffLevelThreshold + 1, maxBuffLevel, increase, isLeader);
            }
        }
    }

    private static Object2IntArrayMap<class_6880<class_1291>> getBuffs(Set<BuffEntry> possibleBuffEntries, class_1308 mob) {
        Object2IntArrayMap buffs = new Object2IntArrayMap();
        class_1799 weapon = BuffHandler.getWeapon(mob);
        possibleBuffEntries.forEach(buffEntry -> {
            block19: {
                block0 : switch ((BuffSetType)((Object)((Object)buffEntry.buffSetType.get()))) {
                    case WEAPON_BASED: {
                        switch ((WeaponType)((Object)((Object)buffEntry.weaponType.get()))) {
                            case ANY: {
                                if (BuffHandler.isRangedWeapon(weapon)) {
                                    BuffHandler.addBuffs((Object2IntArrayMap<class_6880<class_1291>>)buffs, Main.CONFIG.defaultRangedBuffs);
                                    return;
                                }
                                BuffHandler.addBuffs((Object2IntArrayMap<class_6880<class_1291>>)buffs, Main.CONFIG.defaultMeleeBuffs);
                                return;
                            }
                            case MELEE: {
                                if (!BuffHandler.isMeleeWeapon(weapon)) break;
                                BuffHandler.addBuffs((Object2IntArrayMap<class_6880<class_1291>>)buffs, Main.CONFIG.defaultMeleeBuffs);
                                return;
                            }
                            case RANGED: {
                                if (!BuffHandler.isRangedWeapon(weapon)) break;
                                BuffHandler.addBuffs((Object2IntArrayMap<class_6880<class_1291>>)buffs, Main.CONFIG.defaultRangedBuffs);
                                return;
                            }
                        }
                        return;
                    }
                    case CUSTOM: {
                        switch ((WeaponType)((Object)((Object)buffEntry.weaponType.get()))) {
                            case ANY: {
                                BuffHandler.addBuffs((Object2IntArrayMap<class_6880<class_1291>>)buffs, buffEntry.customBuffs);
                                break block0;
                            }
                            case MELEE: {
                                if (!BuffHandler.isMeleeWeapon(weapon)) return;
                                BuffHandler.addBuffs((Object2IntArrayMap<class_6880<class_1291>>)buffs, buffEntry.customBuffs);
                                break block19;
                            }
                            case RANGED: {
                                if (!BuffHandler.isRangedWeapon(weapon)) return;
                                BuffHandler.addBuffs((Object2IntArrayMap<class_6880<class_1291>>)buffs, buffEntry.customBuffs);
                                break block19;
                            }
                            case CUSTOM: {
                                if (!BuffHandler.weaponMatches(weapon, buffEntry.customWeapons)) return;
                                BuffHandler.addBuffs((Object2IntArrayMap<class_6880<class_1291>>)buffs, buffEntry.customBuffs);
                            }
                        }
                    }
                }
            }
        });
        return buffs;
    }

    private static void addBuffs(Object2IntArrayMap<class_6880<class_1291>> buffs, ValidatedMap<class_2960, Integer> addition) {
        addition.forEach((rl, i) -> buffs.put((Object)((class_6880)class_7923.field_41174.method_55841(rl).orElseThrow()), i.intValue()));
    }

    private static class_1799 getWeapon(class_1308 mob) {
        class_1799 mainHand = mob.method_6047();
        class_1799 offHand = mob.method_6079();
        return mainHand.method_7960() ? offHand : mainHand;
    }

    private static boolean weaponMatches(class_1799 stack, ValidatedSet<String> keys) {
        HashSet items = new HashSet();
        HashSet itemTags = new HashSet();
        keys.forEach(string -> {
            if (string.startsWith("#")) {
                itemTags.add(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60654((String)string.substring(1))));
            } else {
                items.add((class_1792)class_7923.field_41178.method_17966(class_2960.method_60654((String)string)).orElseThrow());
            }
        });
        return items.contains(stack.method_7909()) || itemTags.stream().anyMatch(itemTag -> ((class_6885.class_6888)class_7923.field_41178.method_40266(itemTag).orElseThrow()).method_40241(stack.method_41409()));
    }

    private static boolean isMeleeWeapon(class_1799 stack) {
        return BuffHandler.weaponMatches(stack, Main.CONFIG.meleeWeapons);
    }

    private static boolean isRangedWeapon(class_1799 stack) {
        return BuffHandler.weaponMatches(stack, Main.CONFIG.rangedWeapons);
    }
}

