package com.boyonk.bossbar;

import com.boyonk.bossbar.command.BossBarCommandExtension;
import com.boyonk.bossbar.entity.boss.EntityBossBar;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.mojang.serialization.Codec;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1299;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4239;
import net.minecraft.class_5250;
import net.minecraft.class_5699;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;

public class BossbarMod implements ModInitializer {

	public static final String NAMESPACE = "bossbar";
	public static final Logger LOGGER = LoggerFactory.getLogger("Bossbar");
	public static final Gson GSON = (new GsonBuilder()).setPrettyPrinting().create();

	public static final int DEFAULT_RANGE = 64;
	public static final String NBT_KEY = class_2960.method_60655(NAMESPACE, "bossbar").toString();

	private static Config config = new Config(Map.of());


	@Override
	public void onInitialize() {
		CommandRegistrationCallback.EVENT.register(BossBarCommandExtension::register);

		Path path = FabricLoader.getInstance().getConfigDir().resolve(NAMESPACE + ".json");

		if (Files.isRegularFile(path)) {
			try (JsonReader reader = new JsonReader(Files.newBufferedReader(path, StandardCharsets.UTF_8))) {
				reader.setLenient(false);
				JsonElement json = Streams.parse(reader);
				config = Config.CODEC.parse(JsonOps.INSTANCE, json).getOrThrow(JsonParseException::new);
			} catch (JsonParseException exception) {
				LOGGER.error("Couldn't parse config {}", path.getFileName(), exception);
			} catch (IOException exception) {
				LOGGER.error("Couldn't access config {}", path.getFileName(), exception);
			}
		} else {
			try {
				class_4239.method_47525(path.getParent());
				try (Writer writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8)) {
					GSON.toJson(Config.CODEC.encodeStart(JsonOps.INSTANCE, config).getOrThrow(IOException::new), writer);
				}
			} catch (IOException exception) {
				LOGGER.error("Failed to save config {}", path, exception);
			}
		}

	}

	public static @Nullable EntityBossBar.Settings getSettings(class_1299<?> type) {
		return config.defaultBossbars.get(type);
	}

	public record Config(Map<class_1299<?>, EntityBossBar.Settings> defaultBossbars) {
		public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group(
						class_5699.method_53703(class_7923.field_41177.method_39673(), EntityBossBar.Settings.CODEC)
								.fieldOf("default")
								.forGetter(Config::defaultBossbars)
				).apply(instance, Config::new)
		);
	}

	public static class_5250 translatable(String key, Object... args) {
		String fallback = class_2561.method_43469(key, args).getString();
		return class_2561.method_48322(key, fallback, args);
	}

	public static class_5250 translatable(String key) {
		String fallback = class_2561.method_43471(key).getString();
		return class_2561.method_48321(key, fallback);
	}

}
