package com.boyonk.bossbar.command;

import com.boyonk.bossbar.BossBarHolder;
import com.boyonk.bossbar.BossbarMod;
import com.boyonk.bossbar.entity.boss.EntityBossBar;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.class_1259;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2564;
import net.minecraft.class_7157;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class BossBarCommandExtension {
	private static final SimpleCommandExceptionType NON_LIVING_EXCEPTION = new SimpleCommandExceptionType(BossbarMod.translatable("commands.bossbar.entity.non_living.failure"));
	private static final SimpleCommandExceptionType SET_COLOR_UNCHANGED_EXCEPTION = new SimpleCommandExceptionType(BossbarMod.translatable("commands.bossbar.set.color.unchanged"));
	private static final SimpleCommandExceptionType SET_STYLE_UNCHANGED_EXCEPTION = new SimpleCommandExceptionType(BossbarMod.translatable("commands.bossbar.set.style.unchanged"));
	private static final SimpleCommandExceptionType SET_VISIBILITY_UNCHANGED_HIDDEN_EXCEPTION = new SimpleCommandExceptionType(BossbarMod.translatable("commands.bossbar.set.visibility.unchanged.hidden"));
	private static final SimpleCommandExceptionType SET_VISIBILITY_UNCHANGED_VISIBLE_EXCEPTION = new SimpleCommandExceptionType(BossbarMod.translatable("commands.bossbar.set.visibility.unchanged.visible"));
	private static final SimpleCommandExceptionType SET_DARKEN_SKY_UNCHANGED_TRUE_EXCEPTION = new SimpleCommandExceptionType(BossbarMod.translatable("commands.bossbar.set.darken_sky.unchanged.true"));
	private static final SimpleCommandExceptionType SET_DARKEN_SKY_UNCHANGED_FALSE_EXCEPTION = new SimpleCommandExceptionType(BossbarMod.translatable("commands.bossbar.set.darken_sky.unchanged.false"));
	private static final SimpleCommandExceptionType SET_THICKEN_FOG_UNCHANGED_TRUE_EXCEPTION = new SimpleCommandExceptionType(BossbarMod.translatable("commands.bossbar.set.thicken_fog.unchanged.true"));
	private static final SimpleCommandExceptionType SET_THICKEN_FOG_UNCHANGED_FALSE_EXCEPTION = new SimpleCommandExceptionType(BossbarMod.translatable("commands.bossbar.set.thicken_fog.unchanged.false"));
	private static final SimpleCommandExceptionType SET_RANGE_UNCHANGED_EXCEPTION = new SimpleCommandExceptionType(BossbarMod.translatable("commands.bossbar.set.range.unchanged"));

	public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registries, class_2170.class_5364 environment) {
		dispatcher.register(method_9247("bossbar")
				.requires(source -> source.method_9259(2))
				.then(method_9247("get")
						.then(method_9244("target", class_2186.method_9309())
								.then(method_9247("players")
										.executes(ctx -> getPlayers(ctx.getSource(), class_2186.method_9313(ctx, "target")))
								)
								.then(method_9247("visible")
										.executes(ctx -> isVisible(ctx.getSource(), class_2186.method_9313(ctx, "target")))
								)
								.then(method_9247("get")
										.executes(ctx -> getRange(ctx.getSource(), class_2186.method_9313(ctx, "target")))
								)
						)
				)
				.then(method_9247("set")
						.then(method_9244("target", class_2186.method_9309())
								.then(method_9247("color")
										.then(method_9247("pink").executes(ctx -> setColor(ctx.getSource(), class_2186.method_9313(ctx, "target"), class_1259.class_1260.field_5788)))
										.then(method_9247("blue").executes(ctx -> setColor(ctx.getSource(), class_2186.method_9313(ctx, "target"), class_1259.class_1260.field_5780)))
										.then(method_9247("red").executes(ctx -> setColor(ctx.getSource(), class_2186.method_9313(ctx, "target"), class_1259.class_1260.field_5784)))
										.then(method_9247("green").executes(ctx -> setColor(ctx.getSource(), class_2186.method_9313(ctx, "target"), class_1259.class_1260.field_5785)))
										.then(method_9247("yellow").executes(ctx -> setColor(ctx.getSource(), class_2186.method_9313(ctx, "target"), class_1259.class_1260.field_5782)))
										.then(method_9247("purple").executes(ctx -> setColor(ctx.getSource(), class_2186.method_9313(ctx, "target"), class_1259.class_1260.field_5783)))
								)
								.then(method_9247("style")
										.then(method_9247("progress").executes(ctx -> setStyle(ctx.getSource(), class_2186.method_9313(ctx, "target"), class_1259.class_1261.field_5795)))
										.then(method_9247("notched_6").executes(ctx -> setStyle(ctx.getSource(), class_2186.method_9313(ctx, "target"), class_1259.class_1261.field_5796)))
										.then(method_9247("notched_10").executes(ctx -> setStyle(ctx.getSource(), class_2186.method_9313(ctx, "target"), class_1259.class_1261.field_5791)))
										.then(method_9247("notched_12").executes(ctx -> setStyle(ctx.getSource(), class_2186.method_9313(ctx, "target"), class_1259.class_1261.field_5793)))
										.then(method_9247("notched_20").executes(ctx -> setStyle(ctx.getSource(), class_2186.method_9313(ctx, "target"), class_1259.class_1261.field_5790)))
								)
								.then(method_9247("visible")
										.then(method_9244("visible", BoolArgumentType.bool())
												.executes(ctx -> setVisible(ctx.getSource(), class_2186.method_9313(ctx, "target"), BoolArgumentType.getBool(ctx, "visible")))
										)
								)
								.then(method_9247("darken_sky")
										.then(method_9244("darken_sky", BoolArgumentType.bool())
												.executes(ctx -> setDarkenSky(ctx.getSource(), class_2186.method_9313(ctx, "target"), BoolArgumentType.getBool(ctx, "darken_sky"))))
								)
								.then(method_9247("thicken_fog")
										.then(method_9244("thicken_fog", BoolArgumentType.bool())
												.executes(ctx -> setThickenFog(ctx.getSource(), class_2186.method_9313(ctx, "target"), BoolArgumentType.getBool(ctx, "thicken_fog"))))
								)
								.then(method_9247("range")
										.then(method_9244("range", IntegerArgumentType.integer(0))
												.executes(ctx -> setRange(ctx.getSource(), class_2186.method_9313(ctx, "target"), IntegerArgumentType.getInteger(ctx, "range"))))
								)

						)
				)
		);
	}

	private static int getPlayers(class_2168 source, class_1297 target) throws CommandSyntaxException {
		if (!(target instanceof BossBarHolder livingEntity)) throw NON_LIVING_EXCEPTION.create();

		EntityBossBar bossBar = livingEntity.getBossBar();

		if (bossBar == null || bossBar.method_14092().isEmpty()) {
			source.method_9226(() -> BossbarMod.translatable("commands.bossbar.entity.get.players.none", target.method_5477()), true);
		} else {
			source.method_9226(() -> BossbarMod.translatable("commands.bossbar.entity.get.players.some", target.method_5477(), bossBar.method_14092().size(), class_2564.method_10884(bossBar.method_14092(), class_1657::method_5476)), true);
		}
		return bossBar == null ? 0 : bossBar.method_14092().size();
	}

	private static int isVisible(class_2168 source, class_1297 target) throws CommandSyntaxException {
		if (!(target instanceof BossBarHolder livingEntity)) throw NON_LIVING_EXCEPTION.create();

		EntityBossBar bossBar = livingEntity.getBossBar();

		if (bossBar != null && bossBar.method_14093()) {
			source.method_9226(() -> BossbarMod.translatable("commands.bossbar.entity.get.visible.visible", target.method_5477()), true);
			return 1;
		}
		source.method_9226(() -> BossbarMod.translatable("commands.bossbar.entity.get.visible.hidden", target.method_5477()), true);
		return 0;
	}

	private static int getRange(class_2168 source, class_1297 target) throws CommandSyntaxException {
		if (!(target instanceof BossBarHolder livingEntity)) throw NON_LIVING_EXCEPTION.create();

		EntityBossBar bossBar = livingEntity.getBossBar();

		int range = bossBar == null ? BossbarMod.DEFAULT_RANGE : bossBar.getRange();

		source.method_9226(() -> BossbarMod.translatable("commands.bossbar.entity.get.range", target.method_5477(), String.valueOf(range)), true);

		return range;

	}

	private static int setColor(class_2168 source, class_1297 target, class_1259.class_1260 color) throws CommandSyntaxException {
		if (!(target instanceof BossBarHolder livingEntity)) throw NON_LIVING_EXCEPTION.create();

		EntityBossBar bossBar = livingEntity.getOrCreateBossBar();

		if (bossBar.method_5420().equals(color)) throw SET_COLOR_UNCHANGED_EXCEPTION.create();

		bossBar.method_5416(color);

		source.method_9226(() -> BossbarMod.translatable("commands.bossbar.entity.set.color.success", target.method_5477()), true);
		return 1;
	}

	private static int setStyle(class_2168 source, class_1297 target, class_1259.class_1261 style) throws CommandSyntaxException {
		if (!(target instanceof BossBarHolder livingEntity)) throw NON_LIVING_EXCEPTION.create();

		EntityBossBar bossBar = livingEntity.getOrCreateBossBar();

		if (bossBar.method_5415().equals(style)) throw SET_STYLE_UNCHANGED_EXCEPTION.create();

		bossBar.method_5409(style);

		source.method_9226(() -> BossbarMod.translatable("commands.bossbar.entity.set.style.success", target.method_5477()), true);
		return 1;
	}

	private static int setVisible(class_2168 source, class_1297 target, boolean visible) throws CommandSyntaxException {
		if (!(target instanceof BossBarHolder livingEntity)) throw NON_LIVING_EXCEPTION.create();

		EntityBossBar bossBar = livingEntity.getOrCreateBossBar();

		if (bossBar.method_14093() == visible) {
			if (visible) {
				throw SET_VISIBILITY_UNCHANGED_VISIBLE_EXCEPTION.create();
			}
			throw SET_VISIBILITY_UNCHANGED_HIDDEN_EXCEPTION.create();
		}

		bossBar.method_14091(visible);

		if (visible) {
			source.method_9226(() -> BossbarMod.translatable("commands.bossbar.entity.set.visible.success.visible", target.method_5477()), true);
		} else {
			source.method_9226(() -> BossbarMod.translatable("commands.bossbar.entity.set.visible.success.hidden", target.method_5477()), true);
		}
		return 1;
	}

	private static int setDarkenSky(class_2168 source, class_1297 target, boolean darkenSky) throws CommandSyntaxException {
		if (!(target instanceof BossBarHolder livingEntity)) throw NON_LIVING_EXCEPTION.create();

		EntityBossBar bossBar = livingEntity.getOrCreateBossBar();

		if (bossBar.method_5417() == darkenSky) {
			if (darkenSky) {
				throw SET_DARKEN_SKY_UNCHANGED_TRUE_EXCEPTION.create();
			}
			throw SET_DARKEN_SKY_UNCHANGED_FALSE_EXCEPTION.create();
		}

		bossBar.method_5406(darkenSky);

		if (darkenSky) {
			source.method_9226(() -> BossbarMod.translatable("commands.bossbar.entity.set.darken_sky.success.true", target.method_5477()), true);
		} else {
			source.method_9226(() -> BossbarMod.translatable("commands.bossbar.entity.set.darken_sky.success.false", target.method_5477()), true);
		}
		return 1;
	}

	private static int setThickenFog(class_2168 source, class_1297 target, boolean thickenFog) throws CommandSyntaxException {
		if (!(target instanceof BossBarHolder livingEntity)) throw NON_LIVING_EXCEPTION.create();

		EntityBossBar bossBar = livingEntity.getOrCreateBossBar();

		if (bossBar.method_5419() == thickenFog) {
			if (thickenFog) {
				throw SET_THICKEN_FOG_UNCHANGED_TRUE_EXCEPTION.create();
			}
			throw SET_THICKEN_FOG_UNCHANGED_FALSE_EXCEPTION.create();
		}

		bossBar.method_5411(thickenFog);
		if (thickenFog) {
			source.method_9226(() -> BossbarMod.translatable("commands.bossbar.entity.set.thicken_fog.success.true", target.method_5477()), true);
		} else {
			source.method_9226(() -> BossbarMod.translatable("commands.bossbar.entity.set.thicken_fog.success.false", target.method_5477()), true);
		}
		return 1;
	}

	private static int setRange(class_2168 source, class_1297 target, int range) throws CommandSyntaxException {
		if (!(target instanceof BossBarHolder livingEntity)) throw NON_LIVING_EXCEPTION.create();

		EntityBossBar bossBar = livingEntity.getOrCreateBossBar();

		if (bossBar.getRange() == range) throw SET_RANGE_UNCHANGED_EXCEPTION.create();

		bossBar.setRange(range);

		source.method_9226(() -> BossbarMod.translatable("commands.bossbar.entity.set.range.success", target.method_5477()), true);
		return 1;
	}

}
