package com.boyonk.bossbar.mixin;

import com.boyonk.bossbar.BossBarHolder;
import com.boyonk.bossbar.BossbarMod;
import com.boyonk.bossbar.entity.boss.EntityBossBar;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;

@Mixin(class_1309.class)
public abstract class MixinLivingEntity extends class_1297 implements BossBarHolder {

	@Unique
	@Nullable
	EntityBossBar bossbar$bossBar = null;

	public MixinLivingEntity(class_1299<?> type, class_1937 world) {
		super(type, world);
	}

	@Inject(method = "<init>", at = @At("RETURN"))
	void bossbar$init(class_1299<?> entityType, class_1937 world, CallbackInfo ci) {
		EntityBossBar.Settings settings = BossbarMod.getSettings(entityType);
		if (settings != null) this.bossbar$bossBar = new EntityBossBar(settings);
	}

	@Inject(method = "remove", at = @At("RETURN"))
	void bossbar$remove(class_1297.class_5529 reason, CallbackInfo ci) {
		if (this.bossbar$bossBar != null) this.bossbar$bossBar.method_14091(false);
	}

	@Inject(method = "writeCustomData", at = @At("RETURN"))
	void bossbar$writeBossBar(class_11372 view, CallbackInfo ci) {
		if (this.bossbar$bossBar == null) return;
		if (this.bossbar$bossBar.shouldSkipSaving(this.method_5864())) return;

		view.method_71468(BossbarMod.NBT_KEY, EntityBossBar.Settings.CODEC, this.bossbar$bossBar.getSettings());
	}

	@Inject(method = "readCustomData", at = @At("RETURN"))
	void bossbar$readBossBar(class_11368 view, CallbackInfo ci) {
		Optional<EntityBossBar.Settings> serialized = view.method_71426(BossbarMod.NBT_KEY, EntityBossBar.Settings.CODEC);
		if (this.bossbar$bossBar != null && serialized.isEmpty()) {
			EntityBossBar.Settings settings = BossbarMod.getSettings(this.method_5864());
			if (settings == null) {
				this.bossbar$bossBar.method_14091(false);
				this.bossbar$bossBar = null;
			} else {
				this.bossbar$bossBar.setSettings(settings);
				this.bossbar$bossBar.method_14091(true);
			}
		} else {
			if (this.bossbar$bossBar == null) this.bossbar$bossBar = new EntityBossBar();
			serialized.ifPresent(this.bossbar$bossBar::setSettings);
		}
	}


	@Inject(method = "tick", at = @At("RETURN"))
	void bossbar$tick(CallbackInfo ci) {
		if (this.bossbar$bossBar == null) return;
		//noinspection DataFlowIssue
		EntityBossBar.tick(this.bossbar$bossBar, (class_1309) (Object) this);
	}


	@SuppressWarnings("AddedMixinMembersNamePattern")
	@Override
	public @Nullable EntityBossBar getBossBar() {
		return this.bossbar$bossBar;
	}

	@SuppressWarnings("AddedMixinMembersNamePattern")
	@Override
	public EntityBossBar getOrCreateBossBar() {
		if (this.bossbar$bossBar == null) this.bossbar$bossBar = new EntityBossBar();
		return this.bossbar$bossBar;
	}
}
