/*
 * Decompiled with CFR 0.152.
 */
package com.boyonk.bossbar;

import com.boyonk.bossbar.command.BossBarCommandExtension;
import com.boyonk.bossbar.entity.boss.EntityBossBar;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1299;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4239;
import net.minecraft.class_5250;
import net.minecraft.class_5699;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BossbarMod
implements ModInitializer {
    public static final String NAMESPACE = "bossbar";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Bossbar");
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final int DEFAULT_RANGE = 64;
    public static final String NBT_KEY = class_2960.method_60655((String)"bossbar", (String)"bossbar").toString();
    private static Config config = new Config(Map.of());

    public void onInitialize() {
        CommandRegistrationCallback.EVENT.register(BossBarCommandExtension::register);
        Path path = FabricLoader.getInstance().getConfigDir().resolve("bossbar.json");
        if (Files.isRegularFile(path, new LinkOption[0])) {
            try (JsonReader reader = new JsonReader((Reader)Files.newBufferedReader(path, StandardCharsets.UTF_8));){
                reader.setLenient(false);
                JsonElement json = Streams.parse((JsonReader)reader);
                config = (Config)Config.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(JsonParseException::new);
            }
            catch (JsonParseException exception) {
                LOGGER.error("Couldn't parse config {}", (Object)path.getFileName(), (Object)exception);
            }
            catch (IOException exception) {
                LOGGER.error("Couldn't access config {}", (Object)path.getFileName(), (Object)exception);
            }
        } else {
            try {
                class_4239.method_47525((Path)path.getParent());
                try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
                    GSON.toJson((JsonElement)Config.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)config).getOrThrow(IOException::new), (Appendable)writer);
                }
            }
            catch (IOException exception) {
                LOGGER.error("Failed to save config {}", (Object)path, (Object)exception);
            }
        }
    }

    @Nullable
    public static EntityBossBar.Settings getSettings(class_1299<?> type) {
        return BossbarMod.config.defaultBossbars.get(type);
    }

    public static class_5250 translatable(String key, Object ... args) {
        String fallback = class_2561.method_43469((String)key, (Object[])args).getString();
        return class_2561.method_48322((String)key, (String)fallback, (Object[])args);
    }

    public static class_5250 translatable(String key) {
        String fallback = class_2561.method_43471((String)key).getString();
        return class_2561.method_48321((String)key, (String)fallback);
    }

    public record Config(Map<class_1299<?>, EntityBossBar.Settings> defaultBossbars) {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.method_53703((Codec)class_7923.field_41177.method_39673(), EntityBossBar.Settings.CODEC).fieldOf("default").forGetter(Config::defaultBossbars)).apply((Applicative)instance, Config::new));
    }
}

