/*
 * Decompiled with CFR 0.152.
 */
package com.boyonk.bossbar.command;

import com.boyonk.bossbar.BossBarHolder;
import com.boyonk.bossbar.BossbarMod;
import com.boyonk.bossbar.entity.boss.EntityBossBar;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import net.minecraft.class_1259;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2564;
import net.minecraft.class_7157;

public class BossBarCommandExtension {
    private static final SimpleCommandExceptionType NON_LIVING_EXCEPTION = new SimpleCommandExceptionType((Message)BossbarMod.translatable("commands.bossbar.entity.non_living.failure"));
    private static final SimpleCommandExceptionType SET_COLOR_UNCHANGED_EXCEPTION = new SimpleCommandExceptionType((Message)BossbarMod.translatable("commands.bossbar.set.color.unchanged"));
    private static final SimpleCommandExceptionType SET_STYLE_UNCHANGED_EXCEPTION = new SimpleCommandExceptionType((Message)BossbarMod.translatable("commands.bossbar.set.style.unchanged"));
    private static final SimpleCommandExceptionType SET_VISIBILITY_UNCHANGED_HIDDEN_EXCEPTION = new SimpleCommandExceptionType((Message)BossbarMod.translatable("commands.bossbar.set.visibility.unchanged.hidden"));
    private static final SimpleCommandExceptionType SET_VISIBILITY_UNCHANGED_VISIBLE_EXCEPTION = new SimpleCommandExceptionType((Message)BossbarMod.translatable("commands.bossbar.set.visibility.unchanged.visible"));
    private static final SimpleCommandExceptionType SET_DARKEN_SKY_UNCHANGED_TRUE_EXCEPTION = new SimpleCommandExceptionType((Message)BossbarMod.translatable("commands.bossbar.set.darken_sky.unchanged.true"));
    private static final SimpleCommandExceptionType SET_DARKEN_SKY_UNCHANGED_FALSE_EXCEPTION = new SimpleCommandExceptionType((Message)BossbarMod.translatable("commands.bossbar.set.darken_sky.unchanged.false"));
    private static final SimpleCommandExceptionType SET_THICKEN_FOG_UNCHANGED_TRUE_EXCEPTION = new SimpleCommandExceptionType((Message)BossbarMod.translatable("commands.bossbar.set.thicken_fog.unchanged.true"));
    private static final SimpleCommandExceptionType SET_THICKEN_FOG_UNCHANGED_FALSE_EXCEPTION = new SimpleCommandExceptionType((Message)BossbarMod.translatable("commands.bossbar.set.thicken_fog.unchanged.false"));
    private static final SimpleCommandExceptionType SET_RANGE_UNCHANGED_EXCEPTION = new SimpleCommandExceptionType((Message)BossbarMod.translatable("commands.bossbar.set.range.unchanged"));

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registries, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"bossbar").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"get").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9309()).then(class_2170.method_9247((String)"players").executes(ctx -> BossBarCommandExtension.getPlayers((class_2168)ctx.getSource(), class_2186.method_9313((CommandContext)ctx, (String)"target"))))).then(class_2170.method_9247((String)"visible").executes(ctx -> BossBarCommandExtension.isVisible((class_2168)ctx.getSource(), class_2186.method_9313((CommandContext)ctx, (String)"target"))))).then(class_2170.method_9247((String)"get").executes(ctx -> BossBarCommandExtension.getRange((class_2168)ctx.getSource(), class_2186.method_9313((CommandContext)ctx, (String)"target"))))))).then(class_2170.method_9247((String)"set").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9309()).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"color").then(class_2170.method_9247((String)"pink").executes(ctx -> BossBarCommandExtension.setColor((class_2168)ctx.getSource(), class_2186.method_9313((CommandContext)ctx, (String)"target"), class_1259.class_1260.field_5788)))).then(class_2170.method_9247((String)"blue").executes(ctx -> BossBarCommandExtension.setColor((class_2168)ctx.getSource(), class_2186.method_9313((CommandContext)ctx, (String)"target"), class_1259.class_1260.field_5780)))).then(class_2170.method_9247((String)"red").executes(ctx -> BossBarCommandExtension.setColor((class_2168)ctx.getSource(), class_2186.method_9313((CommandContext)ctx, (String)"target"), class_1259.class_1260.field_5784)))).then(class_2170.method_9247((String)"green").executes(ctx -> BossBarCommandExtension.setColor((class_2168)ctx.getSource(), class_2186.method_9313((CommandContext)ctx, (String)"target"), class_1259.class_1260.field_5785)))).then(class_2170.method_9247((String)"yellow").executes(ctx -> BossBarCommandExtension.setColor((class_2168)ctx.getSource(), class_2186.method_9313((CommandContext)ctx, (String)"target"), class_1259.class_1260.field_5782)))).then(class_2170.method_9247((String)"purple").executes(ctx -> BossBarCommandExtension.setColor((class_2168)ctx.getSource(), class_2186.method_9313((CommandContext)ctx, (String)"target"), class_1259.class_1260.field_5783))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"style").then(class_2170.method_9247((String)"progress").executes(ctx -> BossBarCommandExtension.setStyle((class_2168)ctx.getSource(), class_2186.method_9313((CommandContext)ctx, (String)"target"), class_1259.class_1261.field_5795)))).then(class_2170.method_9247((String)"notched_6").executes(ctx -> BossBarCommandExtension.setStyle((class_2168)ctx.getSource(), class_2186.method_9313((CommandContext)ctx, (String)"target"), class_1259.class_1261.field_5796)))).then(class_2170.method_9247((String)"notched_10").executes(ctx -> BossBarCommandExtension.setStyle((class_2168)ctx.getSource(), class_2186.method_9313((CommandContext)ctx, (String)"target"), class_1259.class_1261.field_5791)))).then(class_2170.method_9247((String)"notched_12").executes(ctx -> BossBarCommandExtension.setStyle((class_2168)ctx.getSource(), class_2186.method_9313((CommandContext)ctx, (String)"target"), class_1259.class_1261.field_5793)))).then(class_2170.method_9247((String)"notched_20").executes(ctx -> BossBarCommandExtension.setStyle((class_2168)ctx.getSource(), class_2186.method_9313((CommandContext)ctx, (String)"target"), class_1259.class_1261.field_5790))))).then(class_2170.method_9247((String)"visible").then(class_2170.method_9244((String)"visible", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> BossBarCommandExtension.setVisible((class_2168)ctx.getSource(), class_2186.method_9313((CommandContext)ctx, (String)"target"), BoolArgumentType.getBool((CommandContext)ctx, (String)"visible")))))).then(class_2170.method_9247((String)"darken_sky").then(class_2170.method_9244((String)"darken_sky", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> BossBarCommandExtension.setDarkenSky((class_2168)ctx.getSource(), class_2186.method_9313((CommandContext)ctx, (String)"target"), BoolArgumentType.getBool((CommandContext)ctx, (String)"darken_sky")))))).then(class_2170.method_9247((String)"thicken_fog").then(class_2170.method_9244((String)"thicken_fog", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> BossBarCommandExtension.setThickenFog((class_2168)ctx.getSource(), class_2186.method_9313((CommandContext)ctx, (String)"target"), BoolArgumentType.getBool((CommandContext)ctx, (String)"thicken_fog")))))).then(class_2170.method_9247((String)"range").then(class_2170.method_9244((String)"range", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> BossBarCommandExtension.setRange((class_2168)ctx.getSource(), class_2186.method_9313((CommandContext)ctx, (String)"target"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"range"))))))));
    }

    private static int getPlayers(class_2168 source, class_1297 target) throws CommandSyntaxException {
        if (!(target instanceof BossBarHolder)) {
            throw NON_LIVING_EXCEPTION.create();
        }
        BossBarHolder livingEntity = (BossBarHolder)target;
        EntityBossBar bossBar = livingEntity.getBossBar();
        if (bossBar == null || bossBar.method_14092().isEmpty()) {
            source.method_9226(() -> BossbarMod.translatable("commands.bossbar.entity.get.players.none", target.method_5477()), true);
        } else {
            source.method_9226(() -> BossbarMod.translatable("commands.bossbar.entity.get.players.some", target.method_5477(), bossBar.method_14092().size(), class_2564.method_10884((Collection)bossBar.method_14092(), class_1657::method_5476)), true);
        }
        return bossBar == null ? 0 : bossBar.method_14092().size();
    }

    private static int isVisible(class_2168 source, class_1297 target) throws CommandSyntaxException {
        if (!(target instanceof BossBarHolder)) {
            throw NON_LIVING_EXCEPTION.create();
        }
        BossBarHolder livingEntity = (BossBarHolder)target;
        EntityBossBar bossBar = livingEntity.getBossBar();
        if (bossBar != null && bossBar.method_14093()) {
            source.method_9226(() -> BossbarMod.translatable("commands.bossbar.entity.get.visible.visible", target.method_5477()), true);
            return 1;
        }
        source.method_9226(() -> BossbarMod.translatable("commands.bossbar.entity.get.visible.hidden", target.method_5477()), true);
        return 0;
    }

    private static int getRange(class_2168 source, class_1297 target) throws CommandSyntaxException {
        if (!(target instanceof BossBarHolder)) {
            throw NON_LIVING_EXCEPTION.create();
        }
        BossBarHolder livingEntity = (BossBarHolder)target;
        EntityBossBar bossBar = livingEntity.getBossBar();
        int range = bossBar == null ? 64 : bossBar.getRange();
        source.method_9226(() -> BossbarMod.translatable("commands.bossbar.entity.get.range", target.method_5477(), String.valueOf(range)), true);
        return range;
    }

    private static int setColor(class_2168 source, class_1297 target, class_1259.class_1260 color) throws CommandSyntaxException {
        if (!(target instanceof BossBarHolder)) {
            throw NON_LIVING_EXCEPTION.create();
        }
        BossBarHolder livingEntity = (BossBarHolder)target;
        EntityBossBar bossBar = livingEntity.getOrCreateBossBar();
        if (bossBar.method_5420().equals((Object)color)) {
            throw SET_COLOR_UNCHANGED_EXCEPTION.create();
        }
        bossBar.method_5416(color);
        source.method_9226(() -> BossbarMod.translatable("commands.bossbar.entity.set.color.success", target.method_5477()), true);
        return 1;
    }

    private static int setStyle(class_2168 source, class_1297 target, class_1259.class_1261 style) throws CommandSyntaxException {
        if (!(target instanceof BossBarHolder)) {
            throw NON_LIVING_EXCEPTION.create();
        }
        BossBarHolder livingEntity = (BossBarHolder)target;
        EntityBossBar bossBar = livingEntity.getOrCreateBossBar();
        if (bossBar.method_5415().equals((Object)style)) {
            throw SET_STYLE_UNCHANGED_EXCEPTION.create();
        }
        bossBar.method_5409(style);
        source.method_9226(() -> BossbarMod.translatable("commands.bossbar.entity.set.style.success", target.method_5477()), true);
        return 1;
    }

    private static int setVisible(class_2168 source, class_1297 target, boolean visible) throws CommandSyntaxException {
        if (!(target instanceof BossBarHolder)) {
            throw NON_LIVING_EXCEPTION.create();
        }
        BossBarHolder livingEntity = (BossBarHolder)target;
        EntityBossBar bossBar = livingEntity.getOrCreateBossBar();
        if (bossBar.method_14093() == visible) {
            if (visible) {
                throw SET_VISIBILITY_UNCHANGED_VISIBLE_EXCEPTION.create();
            }
            throw SET_VISIBILITY_UNCHANGED_HIDDEN_EXCEPTION.create();
        }
        bossBar.method_14091(visible);
        if (visible) {
            source.method_9226(() -> BossbarMod.translatable("commands.bossbar.entity.set.visible.success.visible", target.method_5477()), true);
        } else {
            source.method_9226(() -> BossbarMod.translatable("commands.bossbar.entity.set.visible.success.hidden", target.method_5477()), true);
        }
        return 1;
    }

    private static int setDarkenSky(class_2168 source, class_1297 target, boolean darkenSky) throws CommandSyntaxException {
        if (!(target instanceof BossBarHolder)) {
            throw NON_LIVING_EXCEPTION.create();
        }
        BossBarHolder livingEntity = (BossBarHolder)target;
        EntityBossBar bossBar = livingEntity.getOrCreateBossBar();
        if (bossBar.method_5417() == darkenSky) {
            if (darkenSky) {
                throw SET_DARKEN_SKY_UNCHANGED_TRUE_EXCEPTION.create();
            }
            throw SET_DARKEN_SKY_UNCHANGED_FALSE_EXCEPTION.create();
        }
        bossBar.method_5406(darkenSky);
        if (darkenSky) {
            source.method_9226(() -> BossbarMod.translatable("commands.bossbar.entity.set.darken_sky.success.true", target.method_5477()), true);
        } else {
            source.method_9226(() -> BossbarMod.translatable("commands.bossbar.entity.set.darken_sky.success.false", target.method_5477()), true);
        }
        return 1;
    }

    private static int setThickenFog(class_2168 source, class_1297 target, boolean thickenFog) throws CommandSyntaxException {
        if (!(target instanceof BossBarHolder)) {
            throw NON_LIVING_EXCEPTION.create();
        }
        BossBarHolder livingEntity = (BossBarHolder)target;
        EntityBossBar bossBar = livingEntity.getOrCreateBossBar();
        if (bossBar.method_5419() == thickenFog) {
            if (thickenFog) {
                throw SET_THICKEN_FOG_UNCHANGED_TRUE_EXCEPTION.create();
            }
            throw SET_THICKEN_FOG_UNCHANGED_FALSE_EXCEPTION.create();
        }
        bossBar.method_5411(thickenFog);
        if (thickenFog) {
            source.method_9226(() -> BossbarMod.translatable("commands.bossbar.entity.set.thicken_fog.success.true", target.method_5477()), true);
        } else {
            source.method_9226(() -> BossbarMod.translatable("commands.bossbar.entity.set.thicken_fog.success.false", target.method_5477()), true);
        }
        return 1;
    }

    private static int setRange(class_2168 source, class_1297 target, int range) throws CommandSyntaxException {
        if (!(target instanceof BossBarHolder)) {
            throw NON_LIVING_EXCEPTION.create();
        }
        BossBarHolder livingEntity = (BossBarHolder)target;
        EntityBossBar bossBar = livingEntity.getOrCreateBossBar();
        if (bossBar.getRange() == range) {
            throw SET_RANGE_UNCHANGED_EXCEPTION.create();
        }
        bossBar.setRange(range);
        source.method_9226(() -> BossbarMod.translatable("commands.bossbar.entity.set.range.success", target.method_5477()), true);
        return 1;
    }
}

