/*
 * Decompiled with CFR 0.152.
 */
package com.boyonk.bossbar.entity.boss;

import com.boyonk.bossbar.BossbarMod;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1259;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5699;
import org.slf4j.Logger;

public class EntityBossBar
extends class_3213 {
    private Optional<Boolean> visible = Optional.empty();
    private Optional<class_1259.class_1260> color = Optional.empty();
    private Optional<class_1259.class_1261> style = Optional.empty();
    private Optional<Integer> range = Optional.empty();
    private Optional<Boolean> darkenSky = Optional.empty();
    private Optional<Boolean> thickenFog = Optional.empty();

    public EntityBossBar() {
        super((class_2561)class_2561.method_43473(), class_1259.class_1260.field_5783, class_1259.class_1261.field_5795);
        this.method_14091(false);
    }

    public EntityBossBar(Settings settings) {
        this();
        this.setSettings(settings);
        this.method_14091(true);
    }

    public void method_14091(boolean visible) {
        super.method_14091(visible);
        this.visible = Optional.of(visible);
    }

    public void method_5416(class_1259.class_1260 color) {
        super.method_5416(color);
        this.color = Optional.of(color);
    }

    public void method_5409(class_1259.class_1261 style) {
        super.method_5409(style);
        this.style = Optional.of(style);
    }

    public void setRange(int range) {
        this.range = Optional.of(range);
    }

    public class_1259 method_5406(boolean darkenSky) {
        this.darkenSky = Optional.of(darkenSky);
        return super.method_5406(darkenSky);
    }

    public class_1259 method_5411(boolean thickenFog) {
        this.thickenFog = Optional.of(thickenFog);
        return super.method_5411(thickenFog);
    }

    public int getRange() {
        return this.range.orElse(64);
    }

    public Settings getSettings() {
        return new Settings(this.visible, this.color, this.style, this.range, this.darkenSky, this.thickenFog);
    }

    public void setSettings(Settings settings) {
        settings.visible.ifPresent(this::method_14091);
        settings.color.ifPresent(this::method_5416);
        settings.style.ifPresent(this::method_5409);
        settings.range.ifPresent(this::setRange);
        settings.darkenSky.ifPresent(this::method_5406);
        settings.thickenFog.ifPresent(this::method_5411);
    }

    public boolean shouldSkipSaving(class_1299<?> type) {
        return this.method_14093() && BossbarMod.getSettings(type) == this.getSettings();
    }

    public void writeNbt(class_2487 nbt, class_1299<?> type) {
        if (this.method_14093() && BossbarMod.getSettings(type) == this.getSettings()) {
            return;
        }
        nbt.method_10543(Settings.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.getSettings()).resultOrPartial(arg_0 -> ((Logger)BossbarMod.LOGGER).error(arg_0)).orElse(new class_2487()));
    }

    public void readNbt(class_2487 nbt) {
        Settings.CODEC.decode((DynamicOps)class_2509.field_11560, (Object)nbt).resultOrPartial(arg_0 -> ((Logger)BossbarMod.LOGGER).error(arg_0)).ifPresent(pair -> this.setSettings((Settings)pair.getFirst()));
    }

    public static void tick(EntityBossBar bossBar, class_1309 entity) {
        if (!bossBar.method_14093()) {
            return;
        }
        bossBar.method_5408(entity.method_6032() / entity.method_6063());
        bossBar.method_5413(entity.method_5477());
        if (entity.method_31481()) {
            bossBar.method_14094();
        }
        if (bossBar.getRange() <= 0) {
            for (class_3222 playerEntity : ((class_3218)entity.method_73183()).method_18456()) {
                bossBar.method_14088(playerEntity);
            }
        } else {
            float squaredRange = (float)bossBar.getRange() * (float)bossBar.getRange();
            List newPlayers = entity.method_73183().method_8390(class_3222.class, class_238.method_30048((class_243)entity.method_73189(), (double)bossBar.getRange(), (double)bossBar.getRange(), (double)bossBar.getRange()), p -> p.method_5858((class_1297)entity) <= (double)squaredRange);
            Collection oldPlayers = bossBar.method_14092();
            for (class_3222 player : oldPlayers) {
                if (newPlayers.contains(player)) continue;
                bossBar.method_14089(player);
            }
            for (class_3222 player : newPlayers) {
                bossBar.method_14088(player);
            }
        }
    }

    public record Settings(Optional<Boolean> visible, Optional<class_1259.class_1260> color, Optional<class_1259.class_1261> style, Optional<Integer> range, Optional<Boolean> darkenSky, Optional<Boolean> thickenFog) {
        public static final Codec<Settings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("visible").forGetter(Settings::visible), (App)class_1259.class_1260.field_56628.optionalFieldOf("color").forGetter(Settings::color), (App)class_1259.class_1261.field_56629.optionalFieldOf("color").forGetter(Settings::style), (App)class_5699.field_33441.optionalFieldOf("range").forGetter(Settings::range), (App)Codec.BOOL.optionalFieldOf("darken_sky").forGetter(Settings::darkenSky), (App)Codec.BOOL.optionalFieldOf("thicken_fog").forGetter(Settings::thickenFog)).apply((Applicative)instance, Settings::new));
    }
}

