/*
 * Decompiled with CFR 0.152.
 */
package de.oceanblocks.durabilitydisplay.config;

import net.minecraft.ChatFormatting;
import net.neoforged.neoforge.common.ModConfigSpec;

public class DurabilityConfig {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec SPEC;
    public static final ModConfigSpec.BooleanValue SHOW_DURABILITY_NUMBERS;
    public static final ModConfigSpec.BooleanValue SHOW_TOOLTIP_INFO;
    public static final ModConfigSpec.BooleanValue HIDE_DURABILITY_BAR;
    public static final ModConfigSpec.ConfigValue<String> COLOR_EXCELLENT;
    public static final ModConfigSpec.ConfigValue<String> COLOR_GOOD;
    public static final ModConfigSpec.ConfigValue<String> COLOR_WARN;
    public static final ModConfigSpec.ConfigValue<String> COLOR_CRITICAL;

    private static int parseHexColor(String hexColor, int fallback) {
        try {
            String cleanHex = hexColor.trim();
            if (cleanHex.startsWith("0x") || cleanHex.startsWith("0X")) {
                cleanHex = cleanHex.substring(2);
            } else if (cleanHex.startsWith("#")) {
                cleanHex = cleanHex.substring(1);
            }
            if (cleanHex.length() != 6) {
                throw new IllegalArgumentException("Hex color must be 6 characters long");
            }
            return Integer.parseInt(cleanHex, 16);
        }
        catch (Exception e) {
            System.err.println("DurabilityMod: Invalid hex color '" + hexColor + "', using fallback color");
            return fallback;
        }
    }

    public static int getDurabilityColor(double percentage) {
        if (percentage > 75.0) {
            return DurabilityConfig.parseHexColor((String)COLOR_EXCELLENT.get(), 0x55FF55);
        }
        if (percentage > 50.0) {
            return DurabilityConfig.parseHexColor((String)COLOR_GOOD.get(), 0xFFFF55);
        }
        if (percentage > 25.0) {
            return DurabilityConfig.parseHexColor((String)COLOR_WARN.get(), 0xFFAA00);
        }
        return DurabilityConfig.parseHexColor((String)COLOR_CRITICAL.get(), 0xFF5555);
    }

    public static ChatFormatting getTooltipColor(double percentage) {
        if (percentage > 75.0) {
            return ChatFormatting.GREEN;
        }
        if (percentage > 50.0) {
            return ChatFormatting.YELLOW;
        }
        if (percentage > 25.0) {
            return ChatFormatting.GOLD;
        }
        return ChatFormatting.RED;
    }

    static {
        BUILDER.push("General Settings");
        BUILDER.comment("Configure when and how durability information is displayed");
        SHOW_DURABILITY_NUMBERS = BUILDER.comment(new String[]{"Show durability numbers above the durability bar", "This displays a compact number (e.g. '1.5k') above damaged items"}).define("showDurabilityNumbers", true);
        SHOW_TOOLTIP_INFO = BUILDER.comment(new String[]{"Show detailed durability information in item tooltips", "Adds a line showing exact durability and percentage when hovering over items"}).define("showTooltipInfo", true);
        HIDE_DURABILITY_BAR = BUILDER.comment(new String[]{"Hide the vanilla durability bar completely", "When enabled, only the number will be shown (requires showDurabilityNumbers to be true)", "This gives a cleaner, more minimal look"}).define("hideDurabilityBar", false);
        BUILDER.pop();
        BUILDER.push("Color Settings");
        BUILDER.comment(new String[]{"Customize colors for different durability levels", "Colors must be in hexadecimal format:", "\u2022 With 0x prefix: '0xFF5555', '0x55FF55', '0x0099FF'", "\u2022 With # prefix: '#FF5555', '#55FF55', '#0099FF'", "\u2022 Without prefix: 'FF5555', '55FF55', '0099FF'", "Use online color pickers to find hex values easily!"});
        COLOR_EXCELLENT = BUILDER.comment(new String[]{"Color for excellent durability (greater than 75%)", "Default: '0x55FF55' (Bright Green)"}).define("colorExcellent", (Object)"0x55FF55");
        COLOR_GOOD = BUILDER.comment(new String[]{"Color for good durability (50-75%)", "Default: '0xFFFF55' (Bright Yellow)"}).define("colorGood", (Object)"0xFFFF55");
        COLOR_WARN = BUILDER.comment(new String[]{"Color for warning durability (25-50%)", "Default: '0xFFAA00' (Orange)"}).define("colorWarn", (Object)"0xFFAA00");
        COLOR_CRITICAL = BUILDER.comment(new String[]{"Color for critical durability (less than 25%)", "Default: '0xFF5555' (Bright Red)"}).define("colorCritical", (Object)"0xFF5555");
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

