/*
 * Decompiled with CFR 0.152.
 */
package de.oceanblocks.durabilitydisplay.handler;

import de.oceanblocks.durabilitydisplay.config.DurabilityConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

public class DurabilityTooltipHandler {
    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        if (!((Boolean)DurabilityConfig.SHOW_TOOLTIP_INFO.get()).booleanValue()) {
            return;
        }
        ItemStack itemStack = event.getItemStack();
        if (itemStack.isDamageableItem()) {
            int maxDamage = itemStack.getMaxDamage();
            int currentDamage = itemStack.getDamageValue();
            int durabilityLeft = maxDamage - currentDamage;
            double percentage = (double)durabilityLeft / (double)maxDamage * 100.0;
            ChatFormatting color = DurabilityConfig.getTooltipColor(percentage);
            MutableComponent durabilityText = Component.literal((String)String.format("Durability: %d/%d (%.1f%%)", durabilityLeft, maxDamage, percentage)).withStyle(color);
            if (event.getToolTip().size() > 1) {
                event.getToolTip().add(1, durabilityText);
            } else {
                event.getToolTip().add(durabilityText);
            }
        }
    }
}

