/*
 * Decompiled with CFR 0.152.
 */
package de.oceanblocks.durabilitydisplay.mixin;

import de.oceanblocks.durabilitydisplay.config.DurabilityConfig;
import de.oceanblocks.durabilitydisplay.utils.DurabilityUtils;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiGraphics.class})
public class HideDurabilityBarMixin {
    @Inject(method={"renderItemDecorations(Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;IILjava/lang/String;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void hideDurabilityBar(Font font, ItemStack itemStack, int x, int y, String text, CallbackInfo ci) {
        if (((Boolean)DurabilityConfig.HIDE_DURABILITY_BAR.get()).booleanValue() && ((Boolean)DurabilityConfig.SHOW_DURABILITY_NUMBERS.get()).booleanValue() && itemStack.isDamageableItem() && itemStack.isDamaged()) {
            GuiGraphics guiGraphics = (GuiGraphics)this;
            this.renderCustomDurabilityOnly(guiGraphics, font, itemStack, x, y, text);
            ci.cancel();
        }
    }

    @Unique
    private void renderCustomDurabilityOnly(GuiGraphics guiGraphics, Font font, ItemStack item, int x, int y, String text) {
        if (text != null) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, 0.0f, 200.0f);
            guiGraphics.drawString(font, text, x + 19 - 2 - font.width(text), y + 6 + 3, 0xFFFFFF, true);
            guiGraphics.pose().popPose();
        }
        int unbreakingLevel = DurabilityUtils.getEnchantmentLevel(item, (ResourceKey<Enchantment>)Enchantments.UNBREAKING);
        int maxDamage = item.getMaxDamage();
        int currentDamage = item.getDamageValue();
        int durabilityLeft = maxDamage - currentDamage;
        double percentage = (double)durabilityLeft / (double)maxDamage * 100.0;
        int color = DurabilityConfig.getDurabilityColor(percentage);
        String string = DurabilityUtils.format((maxDamage - currentDamage) * (unbreakingLevel + 1));
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 200.0f);
        guiGraphics.pose().scale(0.5f, 0.5f, 1.0f);
        int stringWidth = font.width(string);
        int xScaled = (x + 8) * 2 + 1 + stringWidth / 2 - stringWidth;
        int yScaled = (y + 12) * 2;
        guiGraphics.drawString(font, string, xScaled, yScaled, color, true);
        guiGraphics.pose().popPose();
    }
}

