/*
 * Decompiled with CFR 0.152.
 */
package de.oceanblocks.durabilitydisplay.utils;

import java.text.DecimalFormat;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public class DurabilityUtils {
    public static String format(float number) {
        DecimalFormat decimalFormat = new DecimalFormat("0.#");
        if (number >= 1.0E9f) {
            return decimalFormat.format(number / 1.0E9f) + "b";
        }
        if (number >= 1000000.0f) {
            return decimalFormat.format(number / 1000000.0f) + "m";
        }
        if (number >= 1000.0f) {
            return decimalFormat.format(number / 1000.0f) + "k";
        }
        return Float.toString(number).replaceAll("\\.?0*$", "");
    }

    public static int getEnchantmentLevel(ItemStack item, ResourceKey<Enchantment> enchantment) {
        return ((ItemEnchantments)item.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)).entrySet().stream().filter(entry -> ((Holder)entry.getKey()).getKey().compareTo(enchantment) == 0).findAny().map(entry -> entry.getIntValue()).orElse(0);
    }
}

