/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.features.serverMsptMetricsStatistic;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.LongStream;
import net.minecraft.class_8743;

public class MetricsStatistic {
    private final Type aggregationType;
    private final int aggregationLen;
    private final long[][] buffer;
    private final List<MetricsStatistic> newSampleChildren;
    private static final int COLUMN_NUM = 4;
    private class_8743 metricsData;
    private int index;

    public MetricsStatistic(Type aggregationType, int aggregationLen) {
        this.aggregationType = aggregationType;
        this.aggregationLen = aggregationLen;
        this.buffer = new long[4][aggregationLen];
        this.newSampleChildren = Lists.newArrayList();
        this.reset();
    }

    public class_8743 getMetricsData() {
        return this.metricsData;
    }

    public void reset() {
        this.metricsData = new class_8743();
        this.index = 0;
    }

    public void addData(long ms) {
        this.buffer[0][this.index++] = ms;
        if (this.index == this.aggregationLen) {
            this.harvestBuffer();
        }
    }

    public void addDataExtra(long ms, int column) {
        if (1 <= column && column < 4) {
            this.buffer[column][this.index] = ms;
        }
    }

    public void addNewSampleCallback(MetricsStatistic child) {
        this.newSampleChildren.add(child);
    }

    private void harvestBuffer() {
        long[] samples = new long[4];
        for (int cl = 0; cl < samples.length; ++cl) {
            samples[cl] = this.aggregationType.process(this.buffer[cl]);
            Arrays.fill(this.buffer[cl], 0L);
        }
        this.index = 0;
        this.metricsData.method_53066(samples[0]);
        this.newSampleChildren.forEach(child -> {
            for (int cl = 1; cl < samples.length; ++cl) {
                child.addDataExtra(samples[cl], cl);
            }
            child.addData(samples[0]);
        });
    }

    public static enum Type {
        AVG(s -> (long)s.average().orElse(0.0)),
        MAX(s -> s.max().orElse(0L));

        private final Function<LongStream, Long> harvester;

        private Type(Function<LongStream, Long> harvester) {
            this.harvester = harvester;
        }

        public long process(long[] buffer) {
            return this.harvester.apply(Arrays.stream(buffer));
        }
    }
}

