/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.features.pistorder;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.impl.features.pistorder.DisplayMode;
import me.fallenbreath.tweakermore.impl.features.pistorder.ImmovableBlockPosRecorder;
import me.fallenbreath.tweakermore.impl.features.pistorder.PistonActionType;
import me.fallenbreath.tweakermore.impl.features.pistorder.pushlimit.PushLimitManager;
import me.fallenbreath.tweakermore.mixins.tweaks.features.pistorder.PistonBlockAccessor;
import me.fallenbreath.tweakermore.util.Messenger;
import me.fallenbreath.tweakermore.util.PositionUtils;
import me.fallenbreath.tweakermore.util.TemporaryBlockReplacer;
import me.fallenbreath.tweakermore.util.render.ColorHolder;
import me.fallenbreath.tweakermore.util.render.TextRenderer;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2554;
import net.minecraft.class_2561;
import net.minecraft.class_2674;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2818;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PistorderDisplay {
    private static final String INDICATOR_SUCCESS = class_124.field_1060 + "\u221a";
    private static final String INDICATOR_FAIL = class_124.field_1061 + "\u00d7";
    private List<class_2338> movedBlocks;
    private List<class_2338> brokenBlocks;
    private boolean moveSuccess;
    @Nullable
    private class_2338 immovableBlockPos;
    public final class_1937 world;
    public final class_2338 pistonPos;
    public final class_2680 blockState;
    public final class_2350 direction;
    public PistonActionType actionType;
    public final int color;
    private DisplayMode displayMode;
    private long lastUpdateTime = -1L;

    public PistorderDisplay(class_1937 world, class_2338 pistonPos, class_2680 blockState, class_2350 direction, PistonActionType actionType) {
        this.world = world;
        this.pistonPos = pistonPos;
        this.blockState = blockState;
        this.direction = direction;
        this.actionType = actionType;
        this.setDisplayMode(DisplayMode.DIRECT);
        Random random = new Random(pistonPos.hashCode());
        this.color = random.nextInt(80) + 175 + (random.nextInt(80) + 175 << 8) + (random.nextInt(80) + 175 << 16);
    }

    private class_2350 getPistonFacing() {
        return (class_2350)this.blockState.method_11654((class_2769)class_2741.field_12525);
    }

    private boolean isStickyPiston() {
        return ((PistonBlockAccessor)this.blockState.method_11614()).getIsSticky();
    }

    public boolean isDisabled() {
        return this.displayMode == DisplayMode.DISABLED;
    }

    private void disable() {
        this.displayMode = DisplayMode.DISABLED;
    }

    private void setDisplayMode(DisplayMode mode) {
        this.displayMode = mode;
        this.refreshInformation();
    }

    private void refreshInformation() {
        class_2338 simulatedPistonPos = null;
        switch (this.displayMode) {
            case DIRECT: {
                simulatedPistonPos = this.pistonPos;
                break;
            }
            case INDIRECT: {
                simulatedPistonPos = this.pistonPos;
                if (this.isStickyPiston()) break;
                simulatedPistonPos = simulatedPistonPos.method_10093(this.getPistonFacing());
                break;
            }
        }
        if (simulatedPistonPos != null) {
            this.analyze(this.world, simulatedPistonPos, this.getPistonFacing(), this.actionType);
        }
    }

    private void analyze(class_1937 world, class_2338 simulatedPistonPos, class_2350 pistonFacing, PistonActionType PistonActionType2) {
        class_2680 air = class_2246.field_10124.method_9564();
        TemporaryBlockReplacer blockReplacer = new TemporaryBlockReplacer(this.world);
        if (!this.pistonPos.equals((Object)simulatedPistonPos)) {
            blockReplacer.add(this.pistonPos, air);
        }
        if (PistonActionType2.isRetract()) {
            blockReplacer.add(simulatedPistonPos.method_10093(pistonFacing), air);
        }
        blockReplacer.removeBlocks();
        class_2674 pistonHandler = new class_2674(world, simulatedPistonPos, pistonFacing, PistonActionType2.isPush());
        this.moveSuccess = pistonHandler.method_11537();
        if (!this.moveSuccess) {
            int newPushLimit = Math.max(PushLimitManager.getInstance().getPushLimit(), TweakerMoreConfigs.PISTORDER_MAX_SIMULATION_PUSH_LIMIT.getIntegerValue());
            PushLimitManager.getInstance().overwritePushLimit(newPushLimit);
            pistonHandler.method_11537();
        }
        blockReplacer.restoreBlocks();
        PushLimitManager.getInstance().restorePushLimit();
        this.brokenBlocks = Lists.newArrayList((Iterable)pistonHandler.method_11536());
        this.movedBlocks = Lists.newArrayList((Iterable)pistonHandler.method_11541());
        this.immovableBlockPos = ((ImmovableBlockPosRecorder)pistonHandler).getImmovableBlockPos$TKM();
        Collections.reverse(this.brokenBlocks);
        Collections.reverse(this.movedBlocks);
    }

    private boolean tryIndirectMode() {
        class_2680 blockInFront1 = this.world.method_8320(this.pistonPos.method_10079(this.getPistonFacing(), 1));
        class_2680 blockInFront2 = this.world.method_8320(this.pistonPos.method_10079(this.getPistonFacing(), 2));
        if (blockInFront1.method_11588() && !blockInFront2.method_11588()) {
            if (this.isStickyPiston()) {
                this.actionType = PistonActionType.RETRACT;
            }
            this.setDisplayMode(DisplayMode.INDIRECT);
            return true;
        }
        return false;
    }

    public void onClick() {
        switch (this.displayMode) {
            case DIRECT: {
                if (this.tryIndirectMode()) break;
                this.disable();
                break;
            }
            case INDIRECT: {
                this.disable();
                break;
            }
        }
    }

    private static TextRenderer drawString(class_2338 pos, float offsetY, class_2554 text, int color) {
        ColorHolder colorHolder = ColorHolder.of(color).modify(h -> {
            h.alpha = (int)(255.0 * TweakerMoreConfigs.PISTORDER_TEXT_ALPHA.getDoubleValue());
        });
        TextRenderer renderer = TextRenderer.create().at(PositionUtils.centerOf(pos)).text((class_2561)text).color(colorHolder.pack()).fontScale(0.025 * TweakerMoreConfigs.PISTORDER_TEXT_SCALE.getDoubleValue()).seeThrough().shadow(TweakerMoreConfigs.PISTORDER_TEXT_SHADOW.getBooleanValue());
        renderer.shift(0.0, (double)offsetY * renderer.getLineHeight());
        return renderer;
    }

    private boolean checkState(class_1937 world) {
        if (!Objects.equals(world, this.world)) {
            return false;
        }
        class_1922 chunk = world.method_8398().method_12246(this.pistonPos.method_10263() >> 4, this.pistonPos.method_10260() >> 4);
        if (chunk instanceof class_2818 && !((class_2818)chunk).method_12223()) {
            return chunk.method_8320(this.pistonPos).equals(this.blockState);
        }
        return true;
    }

    public List<@NotNull TextRenderer> render() {
        ArrayList texts = Lists.newArrayList();
        if (!this.isDisabled()) {
            int i;
            class_310 client = class_310.method_1551();
            if (!this.checkState((class_1937)client.field_1687)) {
                this.disable();
                return Collections.emptyList();
            }
            String actionKey = this.actionType.isPush() ? "tweakermore.impl.pistorder.push" : "tweakermore.impl.pistorder.retract";
            String actionResult = this.moveSuccess ? INDICATOR_SUCCESS : INDICATOR_FAIL;
            texts.add(PistorderDisplay.drawString(this.pistonPos, -0.5f, Messenger.s(String.format("%s %s", class_1074.method_4662((String)actionKey, (Object[])new Object[0]), actionResult), class_124.field_1065), this.color));
            texts.add(PistorderDisplay.drawString(this.pistonPos, 0.5f, Messenger.c(Messenger.formatting(Messenger.tr("tweakermore.impl.pistorder.block_count.pre", new Object[0]), class_124.field_1065), Messenger.s(this.movedBlocks.size()), Messenger.formatting(Messenger.tr("tweakermore.impl.pistorder.block_count.post", new Object[0]), class_124.field_1065)), this.color));
            for (i = 0; i < this.movedBlocks.size(); ++i) {
                texts.add(PistorderDisplay.drawString(this.movedBlocks.get(i), 0.0f, Messenger.s(i + 1), this.color));
            }
            for (i = 0; i < this.brokenBlocks.size(); ++i) {
                texts.add(PistorderDisplay.drawString(this.brokenBlocks.get(i), 0.0f, Messenger.s(i + 1), class_124.field_1061.method_532()));
            }
            if (this.immovableBlockPos != null) {
                texts.add(PistorderDisplay.drawString(this.immovableBlockPos, 0.0f, Messenger.s("\u00d7"), class_124.field_1079.method_532()));
            }
        }
        return texts.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public void tick() {
        if (TweakerMoreConfigs.PISTORDER_DYNAMICALLY_INFO_UPDATE.getBooleanValue() && this.world.method_8510() != this.lastUpdateTime) {
            this.refreshInformation();
            this.lastUpdateTime = this.world.method_8510();
        }
    }
}

