/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.features.schematicProPlace.restrict;

import java.util.Optional;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.mixins.tweaks.features.schematicProPlace.CoralBlockAccessor;
import me.fallenbreath.tweakermore.mixins.tweaks.features.schematicProPlace.CoralFanBlockAccessor;
import me.fallenbreath.tweakermore.mixins.tweaks.features.schematicProPlace.CoralWallFanBlockAccessor;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2217;
import net.minecraft.class_2221;
import net.minecraft.class_2222;
import net.minecraft.class_2248;
import net.minecraft.class_2297;
import net.minecraft.class_2299;
import net.minecraft.class_2301;
import net.minecraft.class_2386;
import net.minecraft.class_2680;
import net.minecraft.class_3486;

public class LooseCaseChecker {
    private static boolean isStrict() {
        return TweakerMoreConfigs.SCHEMATIC_BLOCK_PLACEMENT_RESTRICTION_STRICT.getBooleanValue();
    }

    public static boolean isLooseCheckSpecialCase(class_2680 schematicState, class_1799 schematicStack, class_1799 stackToUse) {
        if (LooseCaseChecker.isStrict()) {
            return false;
        }
        class_1792 itemToUse = stackToUse.method_7909();
        if (itemToUse instanceof class_1747) {
            class_2248 itemToUseBlock = ((class_1747)itemToUse).method_7711();
            if (LooseCaseChecker.checkDeadCoral(schematicState, schematicStack, stackToUse)) {
                return true;
            }
            if (LooseCaseChecker.checkIce(schematicState, itemToUseBlock)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isLooseCheckSpecialCase(class_2680 schematicState, class_2248 blockToPlace) {
        return !LooseCaseChecker.isStrict() && (LooseCaseChecker.checkDeadCoral(schematicState, blockToPlace) || LooseCaseChecker.checkIce(schematicState, blockToPlace));
    }

    private static boolean checkDeadCoral(class_2680 schematicState, class_1799 schematicStack, class_1799 itemToUse) {
        if (LooseCaseChecker.isDeadCoral(schematicState.method_11614())) {
            Optional<class_1792> toUseAsDead = LooseCaseChecker.coralLiving2Dead(itemToUse.method_7909());
            return toUseAsDead.isPresent() && toUseAsDead.get() == schematicStack.method_7909();
        }
        return false;
    }

    private static boolean checkDeadCoral(class_2680 schematicState, class_2248 blockToPlace) {
        class_2248 schematicBlock = schematicState.method_11614();
        if (LooseCaseChecker.isDeadCoral(schematicBlock)) {
            Optional<class_2248> deadCoralToPlace = LooseCaseChecker.coralLiving2Dead(blockToPlace);
            return deadCoralToPlace.isPresent() && deadCoralToPlace.get() == schematicBlock;
        }
        return false;
    }

    private static boolean checkIce(class_2680 schematicState, class_2248 blockToPlace) {
        return blockToPlace instanceof class_2386 && schematicState.method_11618().method_15767(class_3486.field_15517);
    }

    private static Optional<class_2248> coralLiving2Dead(class_2248 livingCoral) {
        class_2248 deadCoral = null;
        if (livingCoral instanceof class_2301) {
            deadCoral = ((CoralBlockAccessor)livingCoral).getDeadCoralBlock();
        } else if (livingCoral instanceof class_2297) {
            deadCoral = ((CoralFanBlockAccessor)livingCoral).getDeadCoralBlock();
        } else if (livingCoral instanceof class_2299) {
            deadCoral = ((CoralWallFanBlockAccessor)livingCoral).getDeadCoralBlock();
        }
        return Optional.ofNullable(deadCoral);
    }

    private static Optional<class_1792> coralLiving2Dead(class_1792 livingCoral) {
        if (livingCoral instanceof class_1747) {
            return LooseCaseChecker.coralLiving2Dead(((class_1747)livingCoral).method_7711()).map(class_2248::method_8389);
        }
        return Optional.empty();
    }

    private static boolean isLivingCoral(class_2248 block) {
        return LooseCaseChecker.coralLiving2Dead(block).isPresent();
    }

    private static boolean isDeadCoral(class_2248 block) {
        return block instanceof class_2217 || block.getClass() == class_2221.class || block.getClass() == class_2222.class;
    }
}

