/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.mixins.core.gui.element;

import fi.dy.masa.malilib.gui.widgets.WidgetBase;
import fi.dy.masa.malilib.gui.widgets.WidgetLabel;
import java.util.List;
import me.fallenbreath.tweakermore.gui.TweakerMoreOptionLabel;
import me.fallenbreath.tweakermore.util.render.context.GuiRenderContext;
import me.fallenbreath.tweakermore.util.render.context.RenderContext;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={WidgetLabel.class})
public abstract class WidgetLabelMixin
extends WidgetBase {
    @Shadow(remap=false)
    protected boolean centered;
    @Shadow(remap=false)
    @Final
    protected int textColor;
    @Shadow(remap=false)
    @Final
    protected List<String> labels;

    public WidgetLabelMixin(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    @Unique
    private boolean shouldUseTranslatedOptionLabelLogic() {
        WidgetLabel self = (WidgetLabel)this;
        return self instanceof TweakerMoreOptionLabel && ((TweakerMoreOptionLabel)self).shouldShowOriginalLines();
    }

    @ModifyVariable(method={"render"}, at=@At(value="CONSTANT", args={"intValue=0"}, remap=false), remap=false, ordinal=4)
    private int translatedOptionLabelShiftyTextStart(int yTextStart) {
        double scale;
        if (this.shouldUseTranslatedOptionLabelLogic() && (scale = TweakerMoreOptionLabel.getConfigOriginalNameScale()) > 0.0) {
            double deltaK = -0.28571428571428575 * scale + 0.28571428571428575 + 0.5;
            yTextStart -= (int)((double)this.fontHeight * scale * deltaK);
        }
        return yTextStart;
    }

    @Inject(method={"render"}, at={@At(value="FIELD", target="Lfi/dy/masa/malilib/gui/widgets/WidgetLabel;centered:Z", remap=false)}, remap=false, locals=LocalCapture.CAPTURE_FAILHARD)
    private void translatedOptionLabelRenderTranslation(int mouseX, int mouseY, boolean selected, CallbackInfo ci, int fontHeight, int yCenter, int yTextStart, int i, String text) {
        double scale = TweakerMoreOptionLabel.getConfigOriginalNameScale();
        if (this.shouldUseTranslatedOptionLabelLogic() && scale > 0.0) {
            TweakerMoreOptionLabel self = (TweakerMoreOptionLabel)((Object)this);
            int color = WidgetLabelMixin.darkerColor(this.textColor);
            String originText = self.getOriginalLines()[i];
            double x = (double)this.x + (this.centered ? (double)this.width / 2.0 : 0.0);
            double y = (int)((double)yTextStart + ((double)this.labels.size() + (double)i * scale + 0.2) * (double)fontHeight);
            GuiRenderContext renderContext = RenderContext.gui();
            renderContext.pushMatrix();
            renderContext.scale(scale, scale);
            x /= scale;
            y /= scale;
            if (this.centered) {
                this.drawCenteredStringWithShadow((int)x, (int)y, color, originText);
            } else {
                this.drawStringWithShadow((int)x, (int)y, color, originText);
            }
            renderContext.popMatrix();
        }
    }

    @Unique
    private static int darkerColor(int color) {
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color >> 0 & 0xFF;
        r = (int)((double)r * 0.6);
        g = (int)((double)g * 0.6);
        b = (int)((double)b * 0.6);
        return a << 24 | r << 16 | g << 8 | b << 0;
    }
}

