/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import me.fallenbreath.tweakermore.TweakerMoreMod;
import org.jetbrains.annotations.Nullable;

public class ReflectionUtils {
    private static final Map<String, Optional<Class<?>>> classCache = new ConcurrentHashMap();

    public static Optional<Class<?>> getClass(String className) {
        return classCache.computeIfAbsent(className, k -> {
            try {
                return Optional.of(Class.forName(className));
            }
            catch (ClassNotFoundException e) {
                TweakerMoreMod.LOGGER.debug("ReflectionUtils.getClass '{}' not found", (Object)className);
                return Optional.empty();
            }
        });
    }

    public static <T> ValueWrapper<T> getStaticField(Class<?> clazz, String fieldName) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return ValueWrapper.of(field.get(null));
        }
        catch (Exception e) {
            return ValueWrapper.error(e);
        }
    }

    public static <T> ValueWrapper<T> invoke(Class<?> clazz, String methodName, @Nullable Object object, Object ... args) {
        try {
            for (Method method : clazz.getDeclaredMethods()) {
                if (!method.getName().equals(methodName) || method.getParameterCount() != args.length) continue;
                method.setAccessible(true);
                return ValueWrapper.of(method.invoke(object, args));
            }
            return ValueWrapper.notFound();
        }
        catch (Exception error) {
            return ValueWrapper.error(error);
        }
    }

    public static class ValueWrapper<T> {
        private final T value;
        private final boolean existed;
        @Nullable
        private final Throwable error;

        private ValueWrapper(T value, boolean existed, @Nullable Throwable error) {
            this.value = value;
            this.existed = existed;
            this.error = error;
        }

        public static <T> ValueWrapper<T> of(T value) {
            return new ValueWrapper<T>(value, true, null);
        }

        public static <T> ValueWrapper<T> notFound() {
            return new ValueWrapper<Object>(null, false, null);
        }

        public static <T> ValueWrapper<T> error(Throwable error) {
            return new ValueWrapper<Object>(null, false, error);
        }

        public boolean isPresent() {
            return this.existed;
        }

        @Nullable
        public Throwable getError() {
            return this.error;
        }

        public T get() {
            if (!this.isPresent()) {
                throw new RuntimeException("value not exists");
            }
            return this.value;
        }

        public void ifPresent(Consumer<T> action) {
            if (this.existed) {
                action.accept(this.value);
            }
        }

        public String toString() {
            return "ValueWrapper[value=" + this.value + ",existed=" + this.existed + ",error=" + this.error + "]";
        }
    }
}

