/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.util.render;

import java.util.Objects;
import me.fallenbreath.tweakermore.util.render.context.GuiRenderContext;
import me.fallenbreath.tweakermore.util.render.context.WorldRenderContext;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4597;

public class RenderUtils {
    private static final class_327 TEXT_RENDERER = class_310.method_1551().field_1772;
    public static final int TEXT_HEIGHT;
    public static final int TEXT_LINE_HEIGHT;
    public static float tickDelta;

    public static int getRenderWidth(String text) {
        return TEXT_RENDERER.method_1727(text);
    }

    public static int getSizeScalingXSign() {
        return -1;
    }

    public static class_4597.class_4598 getVertexConsumer() {
        return class_4597.method_22991((class_287)class_289.method_1348().method_1349());
    }

    public static Scaler createScaler(double anchorX, double anchorY, double factor) {
        return new Scaler(anchorX, anchorY, factor);
    }

    static {
        Objects.requireNonNull(TEXT_RENDERER);
        TEXT_HEIGHT = 9;
        TEXT_LINE_HEIGHT = TEXT_HEIGHT + 1;
        tickDelta = 1.0f;
    }

    public static class Scaler {
        private final double anchorX;
        private final double anchorY;
        private final double factor;
        private Runnable restoreFunc;

        private Scaler(double anchorX, double anchorY, double factor) {
            this.anchorX = anchorX;
            this.anchorY = anchorY;
            if (factor <= 0.0) {
                throw new IllegalArgumentException("factor should be greater than 0, but " + factor + " found");
            }
            this.factor = factor;
        }

        public double getScaleFactor() {
            return this.factor;
        }

        public void apply(WorldRenderContext renderContext) {
            renderContext.pushMatrix();
            renderContext.translate(-this.anchorX * this.factor, -this.anchorY * this.factor, 0.0);
            renderContext.scale(this.factor, this.factor, 1.0);
            renderContext.translate(this.anchorX / this.factor, this.anchorY / this.factor, 0.0);
            this.restoreFunc = renderContext::popMatrix;
        }

        public void apply(GuiRenderContext renderContext) {
            renderContext.pushMatrix();
            renderContext.translate(-this.anchorX * this.factor, -this.anchorY * this.factor);
            renderContext.scale(this.factor, this.factor);
            renderContext.translate(this.anchorX / this.factor, this.anchorY / this.factor);
            this.restoreFunc = renderContext::popMatrix;
        }

        public void restore() {
            if (this.restoreFunc == null) {
                throw new RuntimeException("RenderUtils.Scaler: Calling restore before calling apply");
            }
            this.restoreFunc.run();
            this.restoreFunc = null;
        }
    }
}

