/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.features.autoContainerProcess.processors;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import fi.dy.masa.itemscroller.util.InventoryUtils;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.materials.MaterialListBase;
import fi.dy.masa.litematica.materials.MaterialListEntry;
import fi.dy.masa.litematica.materials.MaterialListUtils;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import me.fallenbreath.tweakermore.TweakerMoreMod;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.config.options.TweakerMoreConfigBooleanHotkeyed;
import me.fallenbreath.tweakermore.config.options.listentries.AutoCollectMaterialListItemLogType;
import me.fallenbreath.tweakermore.impl.features.autoContainerProcess.processors.IContainerProcessor;
import me.fallenbreath.tweakermore.impl.features.autoContainerProcess.processors.ProcessResult;
import me.fallenbreath.tweakermore.mixins.tweaks.features.autoCollectMaterialListItem.MaterialListHudRendererAccessor;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_465;
import net.minecraft.class_746;

public class ContainerMaterialListItemCollector
implements IContainerProcessor {
    @Override
    public TweakerMoreConfigBooleanHotkeyed getConfig() {
        return TweakerMoreConfigs.AUTO_COLLECT_MATERIAL_LIST_ITEM;
    }

    private static void log(Message.MessageType type, String translationKey, Object ... args) {
        if (TweakerMoreConfigs.AUTO_COLLECT_MATERIAL_LIST_ITEM_MESSAGE_TYPE.getOptionListValue() == AutoCollectMaterialListItemLogType.FULL) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)type, (String)translationKey, (Object[])args);
        } else {
            String text = type.getFormatting() + StringUtils.translate((String)translationKey, (Object[])args) + GuiBase.TXT_RST;
            InfoUtils.printActionbarMessage((String)text, (Object[])new Object[0]);
        }
    }

    @Override
    public ProcessResult process(class_746 player, class_465<?> containerScreen, List<class_1735> allSlots, List<class_1735> playerInvSlots, List<class_1735> containerInvSlots) {
        MaterialListBase materialList = DataManager.getMaterialList();
        if (materialList != null) {
            MaterialListHudRendererAccessor hudRendererAccessor = (MaterialListHudRendererAccessor)materialList.getHudRenderer();
            String guiTitle = containerScreen.method_25440().getString();
            MaterialListUtils.updateAvailableCounts((List)materialList.getMaterialsAll(), (class_1657)player);
            List missingOnly = materialList.getMaterialsMissingOnly(true);
            boolean summaryOnly = TweakerMoreConfigs.AUTO_COLLECT_MATERIAL_LIST_ITEM_MESSAGE_TYPE.getOptionListValue() == AutoCollectMaterialListItemLogType.SUMMARY;
            ArrayList summaries = Lists.newArrayList();
            boolean takenSomething = false;
            for (MaterialListEntry entry : missingOnly) {
                int missing = entry.getCountMissing() * materialList.getMultiplier() - entry.getCountAvailable();
                class_1799 stack = entry.getStack();
                if (missing <= 0) continue;
                int totalTaken = 0;
                for (class_1735 slot : containerInvSlots) {
                    int retainAmount;
                    if (!InventoryUtils.areStacksEqual((class_1799)stack, (class_1799)slot.method_7677())) continue;
                    int stackAmount = slot.method_7677().method_7947();
                    int tryMoveAmount = Math.min(missing, stackAmount);
                    if (TweakerMoreConfigs.AUTO_COLLECT_MATERIAL_LIST_ITEM_RETAIN_ITEM.getBooleanValue() && (tryMoveAmount = Math.min(tryMoveAmount, stackAmount - (retainAmount = TweakerMoreConfigs.AUTO_COLLECT_MATERIAL_LIST_ITEM_KEEP_RETAIN_AMOUNT.getIntegerValue()))) <= 0) continue;
                    String itemName = stack.method_7909().method_63680().getString();
                    this.moveToPlayerInventory(containerScreen, playerInvSlots, slot, tryMoveAmount);
                    int moved = stackAmount - slot.method_7677().method_7947();
                    totalTaken += moved;
                    TweakerMoreMod.LOGGER.debug("Moved {}x (attempt {}x) {} to player inventory, still miss {} items", new Object[]{moved, tryMoveAmount, itemName, missing -= moved});
                    if (moved != 0) continue;
                    TweakerMoreMod.LOGGER.debug("Player inventory is full for item {}", (Object)stack.method_7909().method_63680().getString());
                    break;
                }
                if (totalTaken <= 0) continue;
                if (!takenSomething && !summaryOnly) {
                    ContainerMaterialListItemCollector.log(Message.MessageType.INFO, "tweakermore.impl.autoCollectMaterialListItem.info.title", guiTitle);
                }
                takenSomething = true;
                String missingColor = missing == 0 ? GuiBase.TXT_GREEN : GuiBase.TXT_GOLD;
                class_124 formatting = stack.method_7932().method_58413();
                String stackName = String.valueOf(formatting) + stack.method_7964().getString() + GuiBase.TXT_RST;
                if (summaryOnly) {
                    summaries.add(String.format("%s +%s", stackName, missingColor + totalTaken + GuiBase.TXT_RST));
                    continue;
                }
                ContainerMaterialListItemCollector.log(Message.MessageType.INFO, "tweakermore.impl.autoCollectMaterialListItem.info.line", GuiBase.TXT_GOLD + totalTaken + GuiBase.TXT_RST, stackName, missingColor + hudRendererAccessor.invokeGetFormattedCountString(missing, stack.method_7914()) + GuiBase.TXT_RST);
            }
            if (takenSomething) {
                if (summaryOnly) {
                    ContainerMaterialListItemCollector.log(Message.MessageType.INFO, Joiner.on((String)", ").join((Iterable)summaries), new Object[0]);
                }
            } else {
                ContainerMaterialListItemCollector.log(Message.MessageType.INFO, "tweakermore.impl.autoCollectMaterialListItem.took_nothing", guiTitle);
            }
            hudRendererAccessor.setLastUpdateTime(-1L);
        } else {
            ContainerMaterialListItemCollector.log(Message.MessageType.WARNING, "tweakermore.impl.autoCollectMaterialListItem.no_material_list", new Object[0]);
        }
        return new ProcessResult(true, TweakerMoreConfigs.AUTO_COLLECT_MATERIAL_LIST_ITEM_CLOSE_GUI.getBooleanValue());
    }

    private void moveToPlayerInventory(class_465<?> containerScreen, List<class_1735> playerInvSlots, class_1735 fromSlot, int amount) {
        class_1799 stack = fromSlot.method_7677().method_7972();
        if (amount == stack.method_7947()) {
            InventoryUtils.shiftClickSlot(containerScreen, (int)fromSlot.field_7874);
            return;
        }
        if (amount > stack.method_7947()) {
            TweakerMoreMod.LOGGER.warn("Too many items to move to player inventory, the stack {} has {} items but {} items are required", new Object[]{stack.method_7909(), stack.method_7947(), amount});
            return;
        }
        InventoryUtils.leftClickSlot(containerScreen, (int)fromSlot.field_7874);
        for (int idx = playerInvSlots.size() - 1; idx >= 0; --idx) {
            class_1735 slot = playerInvSlots.get(idx);
            int clickAmount = 0;
            if (slot.method_7681() && InventoryUtils.areStacksEqual((class_1799)slot.method_7677(), (class_1799)stack)) {
                class_1799 invStack = slot.method_7677();
                clickAmount = Math.min(invStack.method_7914() - invStack.method_7947(), amount);
            } else if (!slot.method_7681()) {
                clickAmount = amount;
            }
            for (int i = 0; i < clickAmount; ++i) {
                InventoryUtils.rightClickSlot(containerScreen, (int)slot.field_7874);
            }
            if ((amount -= clickAmount) == 0) break;
        }
        InventoryUtils.leftClickSlot(containerScreen, (int)fromSlot.field_7874);
        if (amount != 0) {
            TweakerMoreMod.LOGGER.warn("Failed to move full item stack to player inventory, {} items remains", (Object)amount);
        }
    }
}

