/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.util.damage;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Objects;
import me.fallenbreath.tweakermore.TweakerMoreMod;
import me.fallenbreath.tweakermore.util.damage.DamageUtil;
import net.minecraft.class_1267;
import net.minecraft.class_1280;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_8103;
import net.minecraft.class_9892;

public class DamageCalculator {
    private final class_1309 entity;
    private float damageAmount;
    private final class_1282 damageSource;
    private class_3218 serverWorld = null;
    private ApplyStage currentStage;

    private DamageCalculator(class_1309 entity, float damageAmount, class_1282 damageSource) {
        this.entity = entity;
        this.damageAmount = damageAmount;
        this.damageSource = damageSource;
        this.currentStage = ApplyStage.NONE;
    }

    public void setServerWorld(class_3218 serverWorld) {
        this.serverWorld = serverWorld;
    }

    public static DamageCalculator create(class_1309 entity, float damageAmount, class_1282 damageSource) {
        return new DamageCalculator(entity, damageAmount, damageSource);
    }

    public static DamageCalculator explosion(class_243 explosionCenter, float explosionPower, class_1309 entity) {
        int damage;
        float exposure = class_9892.method_61731((class_243)explosionCenter, (class_1297)entity);
        float maxRange = explosionPower * 2.0f;
        double distanceRatio = Math.sqrt(entity.method_5707(explosionCenter)) / (double)maxRange;
        if (distanceRatio <= 1.0) {
            double damageFactor = (1.0 - distanceRatio) * (double)exposure;
            damage = (int)((damageFactor * damageFactor + damageFactor) / 2.0 * 7.0 * (double)maxRange + 1.0);
        } else {
            damage = 0;
        }
        return new DamageCalculator(entity, damage, entity.method_48923().method_48808(explosionCenter));
    }

    public class_1309 getEntity() {
        return this.entity;
    }

    public float getEntityHealthAfterDeal() {
        return Math.max(this.entity.method_6032() - this.damageAmount, 0.0f);
    }

    public float getDamageAmount() {
        return this.damageAmount;
    }

    public class_1282 getDamageSource() {
        return this.damageSource;
    }

    private void checkAndSetStage(ApplyStage stage) {
        if (stage.ordinal() <= this.currentStage.ordinal()) {
            TweakerMoreMod.LOGGER.warn("DamageCalculator wrong apply order: current {}, applying {}", (Object)this.currentStage, (Object)stage);
        }
        this.currentStage = stage;
    }

    public DamageCalculator applyDifficulty(class_1267 difficulty) {
        this.checkAndSetStage(ApplyStage.DIFFICULTY);
        if (this.entity instanceof class_1657 && this.damageSource.method_5514()) {
            this.damageAmount = DamageUtil.modifyDamageForDifficulty(this.damageAmount, difficulty);
        }
        return this;
    }

    public DamageCalculator applyArmorAndResistanceAndEnchantment() {
        this.checkAndSetStage(ApplyStage.ARMOR);
        float amount = this.damageAmount;
        if (!this.damageSource.method_48789(class_8103.field_42241)) {
            amount = class_1280.method_5496((class_1309)this.entity, (float)amount, (class_1282)this.damageSource, (float)this.entity.method_6096(), (float)((float)this.entity.method_45325(class_5134.field_23725)));
        }
        if (!this.damageSource.method_48789(class_8103.field_42243)) {
            float level;
            if (this.entity.method_6059(class_1294.field_5907) && this.damageSource != this.entity.method_48923().method_48829()) {
                int level2 = Objects.requireNonNull(this.entity.method_6112(class_1294.field_5907)).method_5578() + 1;
                amount = Math.max(amount * (1.0f - (float)level2 / 5.0f), 0.0f);
            }
            if (amount > 0.0f && !this.damageSource.method_48789(class_8103.field_42245) && (level = this.calculateProtectionEnchantmentAmount()) > 0.0f) {
                amount = class_1280.method_5497((float)amount, (float)level);
            }
        }
        this.damageAmount = amount;
        return this;
    }

    private static Iterable<class_1799> getEntityAllArmorItems(class_1309 entity) {
        return entity.method_5661();
    }

    private float calculateProtectionEnchantmentAmount() {
        if (this.serverWorld != null) {
            return class_1890.method_8219((class_3218)this.serverWorld, (class_1309)this.entity, (class_1282)this.damageSource);
        }
        class_1282 source = this.damageSource;
        if (source.method_48789(class_8103.field_42242)) {
            return 0.0f;
        }
        float epf = 0.0f;
        for (class_1799 item : DamageCalculator.getEntityAllArmorItems(this.entity)) {
            for (Object2IntMap.Entry enchantmentEntry : item.method_58657().method_57539()) {
                class_5321 enchantment = ((class_6880)enchantmentEntry.getKey()).method_40230().orElse(null);
                if (enchantment == null) continue;
                int level = enchantmentEntry.getIntValue();
                if (enchantment == class_1893.field_9111) {
                    epf += (float)level;
                    continue;
                }
                if (enchantment == class_1893.field_9095 && source.method_48789(class_8103.field_42246)) {
                    epf += (float)(level * 2);
                    continue;
                }
                if (enchantment == class_1893.field_9129 && source.method_48789(class_8103.field_42250)) {
                    epf += (float)(level * 3);
                    continue;
                }
                if (enchantment == class_1893.field_9107 && source.method_48789(class_8103.field_42249)) {
                    epf += (float)(level * 2);
                    continue;
                }
                if (enchantment != class_1893.field_9096 || !source.method_48789(class_8103.field_42247)) continue;
                epf += (float)(level * 2);
            }
        }
        return epf;
    }

    public DamageCalculator applyAbsorption() {
        this.checkAndSetStage(ApplyStage.ABSORPTION);
        this.damageAmount = Math.max(this.damageAmount - this.entity.method_6067(), 0.0f);
        return this;
    }

    private static enum ApplyStage {
        NONE,
        DIFFICULTY,
        ARMOR,
        ABSORPTION;

    }
}

