/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.features.pistorder;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import fi.dy.masa.malilib.interfaces.IClientTickHandler;
import fi.dy.masa.malilib.util.InfoUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.impl.features.pistorder.PistonActionType;
import me.fallenbreath.tweakermore.impl.features.pistorder.PistorderDisplay;
import me.fallenbreath.tweakermore.mixins.tweaks.features.pistorder.PistonBlockAccessor;
import me.fallenbreath.tweakermore.util.render.TextRenderer;
import me.fallenbreath.tweakermore.util.render.TweakerMoreIRenderer;
import me.fallenbreath.tweakermore.util.render.context.WorldRenderContext;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2665;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3965;

public class PistorderRenderer
implements TweakerMoreIRenderer,
IClientTickHandler {
    private static final PistorderRenderer INSTANCE = new PistorderRenderer();
    private final Map<Pair<class_1937, class_2338>, PistorderDisplay> displayMap = Maps.newHashMap();

    public static PistorderRenderer getInstance() {
        return INSTANCE;
    }

    public boolean isEnabled() {
        return TweakerMoreConfigs.PISTORDER.getBooleanValue() && TweakerMoreConfigs.PISTORDER.getTweakerMoreOption().isEnabled();
    }

    public class_1269 onPlayerRightClickBlock(class_1937 world, class_1657 player, class_1268 hand, class_3965 hit) {
        if (!this.isEnabled()) {
            return class_1269.field_5814;
        }
        if (hand == class_1268.field_5808) {
            return this.onPlayerRightClickBlockWithMainHand(world, player, hit);
        }
        return class_1269.field_5814;
    }

    public class_1269 onPlayerRightClickBlockWithMainHand(class_1937 world, class_1657 player, class_3965 hit) {
        boolean extended;
        class_2338 pos;
        class_2680 blockState;
        class_2248 block;
        if (!this.isEnabled()) {
            return class_1269.field_5814;
        }
        if (player.method_6047().method_7960() && !player.method_5715() && (block = (blockState = world.method_8320(pos = hit.method_17777())).method_26204()) instanceof class_2665 && (!(extended = ((Boolean)blockState.method_11654((class_2769)class_2665.field_12191)).booleanValue()) || ((PistonBlockAccessor)block).getIsSticky())) {
            this.click(world, pos, blockState, (class_2350)blockState.method_11654((class_2769)class_2741.field_12525), extended ? PistonActionType.RETRACT : PistonActionType.PUSH);
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }

    private void click(class_1937 world, class_2338 pos, class_2680 blockState, class_2350 pistonFacing, PistonActionType PistonActionType2) {
        Pair key = Pair.of((Object)world, (Object)pos);
        PistorderDisplay display = this.displayMap.get(key);
        if (display == null) {
            this.displayMap.put((Pair<class_1937, class_2338>)key, new PistorderDisplay(world, pos, blockState, pistonFacing, PistonActionType2));
        } else {
            display.onClick();
            if (display.isDisabled()) {
                this.displayMap.remove(key);
            }
        }
    }

    @Override
    public void onRenderWorldLast(WorldRenderContext context) {
        if (!this.isEnabled()) {
            this.displayMap.clear();
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        ArrayList removeList = Lists.newArrayList();
        ArrayList texts = Lists.newArrayList();
        this.displayMap.forEach((key, display) -> {
            texts.addAll(display.render());
            if (display.isDisabled()) {
                removeList.add(key);
            }
        });
        removeList.forEach(this.displayMap::remove);
        double maxDistance = TweakerMoreConfigs.PISTORDER_MAX_RENDER_DISTANCE.getIntegerValue();
        texts.stream().map(tr -> Pair.of((Object)client.field_1724.method_5707(tr.getPos()), (Object)tr)).filter(p -> (Double)p.getFirst() <= maxDistance * maxDistance).sorted(Collections.reverseOrder(Comparator.comparingDouble(Pair::getFirst))).forEach(p -> ((TextRenderer)p.getSecond()).render());
    }

    public void onClientTick(class_310 mc) {
        this.displayMap.values().forEach(PistorderDisplay::tick);
    }

    public void clearDisplay() {
        if (TweakerMoreConfigs.PISTORDER.getBooleanValue()) {
            InfoUtils.printActionbarMessage((String)"tweakermore.impl.pistorder.display_cleared", (Object[])new Object[0]);
            this.displayMap.clear();
        }
    }
}

