/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.mc_tweaks.flawlessFrames;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.config.options.ConfigBoolean;
import java.util.List;
import me.fallenbreath.tweakermore.TweakerMoreMod;
import net.minecraft.class_310;
import net.minecraft.class_761;

public class FlawlessFramesHandler {
    private static final List<String> HOOK_CLASSES = ImmutableList.of((Object)"com.replaymod.render.hooks.ChunkLoadingRenderGlobal", (Object)"com.replaymod.render.hooks.ForceChunkLoadingHook");
    private static Object hook = null;

    private static void installHook() {
        hook = null;
        Class<?> clazz = null;
        class_761 worldRenderer = class_310.method_1551().field_1769;
        for (String hookClass : HOOK_CLASSES) {
            try {
                clazz = Class.forName(hookClass);
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        if (clazz == null) {
            TweakerMoreMod.LOGGER.error("Failed to located replay flawless rendering hook, searched {}", HOOK_CLASSES);
            return;
        }
        try {
            hook = clazz.getConstructor(class_761.class).newInstance(worldRenderer);
        }
        catch (Exception e) {
            TweakerMoreMod.LOGGER.error("Failed to construct replay flawless rendering hook", (Throwable)e);
        }
    }

    private static void uninstallHook() {
        try {
            hook.getClass().getMethod("uninstall", new Class[0]).invoke(hook, new Object[0]);
        }
        catch (Exception e) {
            TweakerMoreMod.LOGGER.error("Failed to invoke method uninstall of replay flawless rendering hook {}", hook, (Object)e);
        }
        hook = null;
    }

    public static void onConfigValueChanged(ConfigBoolean config) {
        boolean enabled = config.getBooleanValue();
        if (hook == null && enabled) {
            FlawlessFramesHandler.installHook();
        } else if (hook != null && !enabled) {
            FlawlessFramesHandler.uninstallHook();
        }
    }

    public static void refreshHook() {
        if (hook != null) {
            FlawlessFramesHandler.uninstallHook();
            FlawlessFramesHandler.installHook();
        }
    }
}

