/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.util.compat.carpet;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import me.fallenbreath.tweakermore.TweakerMoreMod;
import me.fallenbreath.tweakermore.util.FabricUtils;
import me.fallenbreath.tweakermore.util.ReflectionUtils;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_310;
import net.minecraft.class_638;

public class CarpetModAccess {
    private static final List<Supplier<Optional<Boolean>>> TICK_FROZEN_FLAG_GETTERS = Lists.newArrayList((Object[])new Supplier[]{CarpetModAccess::getIsTickFrozenOld, CarpetModAccess::getIsTickFrozenNew});

    private static boolean checkCarpetVersion(String predicate) {
        return FabricLoader.getInstance().getModContainer("carpet").map(ModContainer::getMetadata).map(ModMetadata::getVersion).map(version -> FabricUtils.doesVersionSatisfyPredicate(version, predicate)).orElse(false);
    }

    private static Optional<Boolean> getIsTickFrozenOld() {
        if (!CarpetModAccess.checkCarpetVersion("<1.4.108")) {
            return Optional.empty();
        }
        Optional<Class<?>> tickSpeedOpt = ReflectionUtils.getClass("carpet.helpers.TickSpeed");
        if (!tickSpeedOpt.isPresent()) {
            TweakerMoreMod.LOGGER.warn("failed to get field carpet.helpers.TickSpeed: {}", tickSpeedOpt);
            return Optional.empty();
        }
        Class<?> tickSpeedClass = tickSpeedOpt.get();
        ReflectionUtils.ValueWrapper flagWrapper = ReflectionUtils.getStaticField(tickSpeedClass, "process_entities");
        if (!flagWrapper.isPresent()) {
            TweakerMoreMod.LOGGER.warn("failed to get field carpet.helpers.TickSpeed#process_entities: {}", flagWrapper);
            return Optional.empty();
        }
        return Optional.of((Boolean)flagWrapper.get() == false);
    }

    private static Optional<Boolean> getIsTickFrozenNew() {
        if (!CarpetModAccess.checkCarpetVersion(">=1.4.108")) {
            return Optional.empty();
        }
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return Optional.of(false);
        }
        ReflectionUtils.ValueWrapper trmWrapper = ReflectionUtils.invoke(world.getClass(), "tickRateManager", world, new Object[0]);
        if (!trmWrapper.isPresent()) {
            TweakerMoreMod.LOGGER.warn("failed to invoked carpet.fakes.LevelInterface#tickRateManager() from a ClientWorld: {}", trmWrapper);
            return Optional.empty();
        }
        Object trm = trmWrapper.get();
        ReflectionUtils.ValueWrapper runsNormally = ReflectionUtils.invoke(trm.getClass(), "runsNormally", trm, new Object[0]);
        if (!runsNormally.isPresent()) {
            TweakerMoreMod.LOGGER.warn("failed to invoked carpet.helpers.TickRateManager#runsNormally(): {}", runsNormally);
            return Optional.empty();
        }
        return Optional.of((Boolean)runsNormally.get() == false);
    }

    public static boolean isTickFrozen() {
        for (Supplier<Optional<Boolean>> flagGetter : TICK_FROZEN_FLAG_GETTERS) {
            Optional<Boolean> frozen = flagGetter.get();
            if (!frozen.isPresent()) continue;
            return frozen.get();
        }
        return false;
    }
}

