/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.gui;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import fi.dy.masa.malilib.config.IConfigResettable;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.GuiConfigsBase;
import fi.dy.masa.malilib.gui.GuiTextFieldGeneric;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.widgets.WidgetBase;
import fi.dy.masa.malilib.gui.widgets.WidgetListConfigOptions;
import fi.dy.masa.malilib.gui.widgets.WidgetSearchBar;
import fi.dy.masa.malilib.interfaces.IStringValue;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.fallenbreath.tweakermore.TweakerMoreMod;
import me.fallenbreath.tweakermore.config.Config;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.config.TweakerMoreOption;
import me.fallenbreath.tweakermore.config.options.TweakerMoreIConfigBase;
import me.fallenbreath.tweakermore.gui.SelectorDropDownList;
import me.fallenbreath.tweakermore.mixins.core.gui.access.WidgetSearchBarAccessor;
import me.fallenbreath.tweakermore.util.FabricUtils;
import me.fallenbreath.tweakermore.util.JsonSaveAble;
import me.fallenbreath.tweakermore.util.render.RenderUtils;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public class TweakerMoreConfigGui
extends GuiConfigsBase {
    @Nullable
    private static TweakerMoreConfigGui currentInstance = null;
    private static final Setting SETTING = new Setting();
    private final List<WidgetBase> hoveringWidgets = Lists.newArrayList();
    @Nullable
    private Config.Type filteredType = null;
    private WidgetSearchBar searchBar = null;

    public TweakerMoreConfigGui() {
        super(10, 50, "tweakermore", null, "tweakermore.gui.title", new Object[]{TweakerMoreMod.VERSION});
    }

    public void method_25426() {
        super.method_25426();
        currentInstance = this;
    }

    public void method_25432() {
        super.method_25432();
        currentInstance = null;
    }

    public static Setting getSetting() {
        return SETTING;
    }

    public static Optional<TweakerMoreConfigGui> getCurrentInstance() {
        return Optional.ofNullable(currentInstance);
    }

    public void setSearchBar(WidgetSearchBar searchBar) {
        this.searchBar = searchBar;
    }

    public static void openGui() {
        GuiBase.openGui((class_437)new TweakerMoreConfigGui());
    }

    public void initGui() {
        super.initGui();
        this.clearOptions();
        this.hoveringWidgets.clear();
        int x = 10;
        int y = 26;
        for (Config.Category category : Config.Category.values()) {
            x += this.createNavigationButton(x, y, category);
        }
        x = this.field_22789 - 11;
        x = this.initTypeFilterDropDownList(x) - 5;
        x = this.initSortingStrategyDropDownList(x) - 5;
        if (this.searchBar != null) {
            GuiTextFieldGeneric searchBox = ((WidgetSearchBarAccessor)this.searchBar).getSearchBox();
            int deltaWidth = Math.max(50, x - this.searchBar.getX()) - this.searchBar.getWidth();
            this.searchBar.setWidth(this.searchBar.getWidth() + deltaWidth);
            searchBox.method_25358(searchBox.method_25368() + deltaWidth);
        }
        this.initBottomStatLine();
    }

    private Stream<TweakerMoreOption> getCurrentOptions() {
        return TweakerMoreConfigs.getOptions(TweakerMoreConfigGui.SETTING.category).stream().filter(option -> this.filteredType == null || option.getType() == this.filteredType);
    }

    private Stream<TweakerMoreOption> getCurrentValidOptions() {
        return this.getCurrentOptions().filter(this::isValidOption);
    }

    private boolean isValidOption(TweakerMoreOption option) {
        if (option.isDebug() && !TweakerMoreConfigs.TWEAKERMORE_DEBUG_MODE.getBooleanValue()) {
            return false;
        }
        return !option.isDevOnly() || TweakerMoreConfigs.TWEAKERMORE_DEBUG_MODE.getBooleanValue() && FabricUtils.isDevelopmentEnvironment();
    }

    private void initBottomStatLine() {
        AtomicInteger enabled = new AtomicInteger(0);
        AtomicInteger disabled = new AtomicInteger(0);
        AtomicInteger modified = new AtomicInteger(0);
        this.getCurrentValidOptions().forEach(option -> {
            TweakerMoreIConfigBase config = option.getConfig();
            if (option.isEnabled()) {
                enabled.getAndIncrement();
                if (config instanceof IConfigResettable && ((IConfigResettable)config).isModified()) {
                    modified.getAndIncrement();
                }
            } else {
                disabled.getAndIncrement();
            }
        });
        int total = enabled.get() + disabled.get();
        String bottomLine = StringUtils.translate((String)"tweakermore.gui.bottom_stat", (Object[])new Object[]{total, enabled.get(), modified.get(), disabled.get()});
        int width = RenderUtils.getRenderWidth(bottomLine);
        int height = RenderUtils.TEXT_HEIGHT;
        int x = this.field_22789 - (this.field_22789 - this.getBrowserWidth()) / 2 - width;
        int y = this.field_22790 - height - 10;
        this.addLabel(x, y, width, height, -3355444, new String[]{bottomLine});
    }

    private <T> void setDisplayParameter(T currentValue, T newValue, Runnable valueSetter, boolean keepSearchBar) {
        if (newValue != currentValue) {
            valueSetter.run();
            this.reDraw(keepSearchBar);
        }
    }

    private int createNavigationButton(int x, int y, Config.Category category) {
        ButtonGeneric button = new ButtonGeneric(x, y, -1, 20, category.getDisplayName(), new String[0]);
        button.setEnabled(TweakerMoreConfigGui.SETTING.category != category);
        button.setHoverStrings(new String[]{category.getDescription()});
        this.addButton((ButtonBase)button, (b, mb) -> this.setDisplayParameter(TweakerMoreConfigGui.SETTING.category, category, () -> {
            TweakerMoreConfigGui.SETTING.category = category;
        }, false));
        return button.getWidth() + 2;
    }

    private <T extends IStringValue> int initDropDownList(int x, List<T> entries, T defaultValue, Supplier<T> valueGetter, Consumer<T> valueSetter, String hoverTextKey, Consumer<SelectorDropDownList<T>> postProcessor) {
        int y = this.getListY() + 3;
        int height = 16;
        int maxTextWidth = entries.stream().filter(Objects::nonNull).mapToInt(e -> this.getStringWidth(e.getStringValue())).max().orElse(-1);
        int width = Math.max(maxTextWidth, 40) + 20;
        SelectorDropDownList<T> dd = new SelectorDropDownList<T>(x - width, y, width, height, 200, entries.size(), entries);
        dd.setEntryChangeListener(entry -> this.setDisplayParameter((IStringValue)valueGetter.get(), entry, () -> valueSetter.accept(entry), true));
        dd.setSelectedEntry(defaultValue);
        dd.setHoverText(hoverTextKey, new Object[0]);
        postProcessor.accept(dd);
        this.addWidget((WidgetBase)dd);
        this.hoveringWidgets.add((WidgetBase)dd);
        return dd.getX();
    }

    private int initTypeFilterDropDownList(int x) {
        Set possibleTypes = this.getCurrentValidOptions().map(TweakerMoreOption::getType).collect(Collectors.toSet());
        List items = Arrays.stream(Config.Type.values()).filter(possibleTypes::contains).collect(Collectors.toList());
        items.add(0, null);
        return this.initDropDownList(x, items, this.filteredType, () -> this.filteredType, type -> {
            this.filteredType = type;
        }, "tweakermore.gui.config_type.label_text", dd -> dd.setNullEntry(() -> StringUtils.translate((String)"tweakermore.gui.selector_drop_down_list.all", (Object[])new Object[0])));
    }

    private int initSortingStrategyDropDownList(int x) {
        List<SortingStrategy> items = Arrays.asList(SortingStrategy.values());
        return this.initDropDownList(x, items, TweakerMoreConfigGui.SETTING.sortingStrategy, () -> TweakerMoreConfigGui.SETTING.sortingStrategy, strategy -> {
            TweakerMoreConfigGui.SETTING.sortingStrategy = strategy;
        }, "tweakermore.gui.sorting_strategy.label_text", dd -> {});
    }

    public void reDraw(boolean keepSearchBar) {
        String previousSearchBarText = null;
        boolean previousSearchBoxFocus = false;
        if (keepSearchBar && this.searchBar != null && this.searchBar.isSearchOpen()) {
            previousSearchBarText = this.searchBar.getFilter();
            previousSearchBoxFocus = ((WidgetSearchBarAccessor)this.searchBar).getSearchBox().method_25370();
        }
        this.reCreateListWidget();
        if (this.searchBar != null && previousSearchBarText != null) {
            GuiTextFieldGeneric searchBox = ((WidgetSearchBarAccessor)this.searchBar).getSearchBox();
            this.searchBar.setSearchOpen(true);
            searchBox.method_1852(previousSearchBarText);
            searchBox.method_25365(previousSearchBoxFocus);
        }
        Objects.requireNonNull((WidgetListConfigOptions)this.getListWidget()).resetScrollbarPosition();
        this.initGui();
    }

    public void reDraw() {
        this.reDraw(true);
    }

    public void renderDropDownList(class_332 matrixStackOrDrawContext, int mouseX, int mouseY) {
        this.hoveringWidgets.forEach(widget -> widget.render(mouseX, mouseY, widget.isMouseOver(mouseX, mouseY), matrixStackOrDrawContext));
    }

    public Pair<Integer, Integer> adjustWidths(int guiWidth, int maxTextWidth) {
        int panelWidth = 190;
        int labelWidth = class_3532.method_15340((int)((guiWidth -= 74) - panelWidth), (int)(maxTextWidth - 5), (int)(maxTextWidth + 100));
        panelWidth = class_3532.method_15340((int)(guiWidth - labelWidth), (int)100, (int)panelWidth);
        labelWidth = class_3532.method_15340((int)(guiWidth - panelWidth + 25), (int)(labelWidth - Math.max((int)((double)maxTextWidth * 0.4), 30)), (int)labelWidth);
        labelWidth = Math.max(labelWidth, 0);
        panelWidth = Math.max(panelWidth, 0);
        return Pair.of((Object)labelWidth, (Object)panelWidth);
    }

    public List<GuiConfigsBase.ConfigOptionWrapper> getConfigs() {
        Comparator<TweakerMoreOption> nameComparator = Comparator.comparing(c -> c.getConfig().getName(), String::compareToIgnoreCase);
        List configs = this.getCurrentValidOptions().filter(option -> {
            if (TweakerMoreConfigs.HIDE_DISABLE_OPTIONS.getBooleanValue() && !option.isEnabled()) {
                return false;
            }
            return option.worksForCurrentMCVersion() || TweakerMoreConfigs.TWEAKERMORE_DEBUG_MODE.getBooleanValue();
        }).sorted(TweakerMoreConfigGui.SETTING.sortingStrategy.getComparator().thenComparing(nameComparator)).map(TweakerMoreOption::getConfig).collect(Collectors.toList());
        return GuiConfigsBase.ConfigOptionWrapper.createFor(configs);
    }

    private static class Setting
    implements JsonSaveAble {
        public Config.Category category = Config.Category.FEATURES;
        public SortingStrategy sortingStrategy = SortingStrategy.ALPHABET;

        private Setting() {
        }

        @Override
        public void dumpToJson(JsonObject jsonObject) {
            jsonObject.addProperty("category", this.category.name());
            jsonObject.addProperty("sortingStrategy", this.sortingStrategy.name());
        }

        @Override
        public void loadFromJson(JsonObject jsonObject) {
            this.category = this.getEnumSafe(jsonObject, "category", this.category);
            this.sortingStrategy = this.getEnumSafe(jsonObject, "sortingStrategy", this.sortingStrategy);
        }
    }

    private static enum SortingStrategy implements IStringValue
    {
        ALPHABET((a, b) -> 0),
        MOST_RECENTLY_USED(Collections.reverseOrder(Comparator.comparingLong(c -> c.getStatistic().lastUsedTime))),
        MOST_COMMONLY_USED(Collections.reverseOrder(Comparator.comparingLong(c -> c.getStatistic().useAmount)));

        private final Comparator<TweakerMoreOption> comparator;

        private SortingStrategy(Comparator<TweakerMoreOption> comparator) {
            this.comparator = comparator;
        }

        public Comparator<TweakerMoreOption> getComparator() {
            return this.comparator;
        }

        public String getStringValue() {
            return StringUtils.translate((String)("tweakermore.gui.sorting_strategy." + this.name().toLowerCase()), (Object[])new Object[0]);
        }
    }
}

