/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.features.infoView.cache;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import fi.dy.masa.malilib.util.WorldUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.impl.features.infoView.InfoViewer;
import me.fallenbreath.tweakermore.impl.features.infoView.cache.RenderVisitorWorldView;
import me.fallenbreath.tweakermore.impl.features.infoView.cache.ScanningCache;
import me.fallenbreath.tweakermore.impl.features.infoView.cache.SimpleCachedWorldView;
import me.fallenbreath.tweakermore.util.FabricUtils;
import me.fallenbreath.tweakermore.util.PositionUtils;
import me.fallenbreath.tweakermore.util.render.RenderUtils;
import me.fallenbreath.tweakermore.util.render.TextRenderer;
import me.fallenbreath.tweakermore.util.render.context.RenderContext;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_638;

public class InfoViewCachedRenderer {
    private long cacheUpdateNs = 0L;
    private CacheData cacheData = null;

    private boolean isCacheInvalid() {
        class_638 clientWorld = class_310.method_1551().field_1687;
        return clientWorld == null || this.cacheData == null || clientWorld != this.cacheData.clientWorld;
    }

    public void render(RenderContext renderContext, List<InfoViewer> viewers) {
        class_310 mc = class_310.method_1551();
        class_1937 world = WorldUtils.getBestWorld((class_310)mc);
        class_638 clientWorld = mc.field_1687;
        if (world == null || clientWorld == null || mc.field_1724 == null) {
            return;
        }
        class_243 camPos = mc.field_1724.method_5836(RenderUtils.tickDelta);
        class_243 camVec = mc.field_1724.method_5828(RenderUtils.tickDelta);
        long now = System.nanoTime();
        long ups = TweakerMoreConfigs.INFO_VIEW_SCANNING_PER_SECOND.getIntegerValue();
        if (this.isCacheInvalid() || ups == 0L || this.cacheUpdateNs == 0L || (double)(now - this.cacheUpdateNs) >= 1.0E9 / (double)ups) {
            this.cacheData = new CacheData(world, (class_1937)clientWorld);
            this.cacheUpdateNs = now;
            RenderVisitorWorldView worldView = this.cacheData.worldView;
            HashMap renderingPositions = Maps.newHashMap();
            for (InfoViewer viewer : viewers) {
                viewer.scanForRender(this.cacheData.scanningCache, camPos, camVec).forEach((pos, renderer) -> {
                    if (viewer.shouldRenderFor(worldView, (class_2338)pos)) {
                        if (!worldView.isBestWorldServerWorld() && viewer.requireBlockEntitySyncing(worldView, (class_2338)pos)) {
                            worldView.syncBlockEntity((class_2338)pos);
                        }
                        renderingPositions.computeIfAbsent(pos, k -> Lists.newArrayList()).add(renderer);
                    }
                });
            }
            renderingPositions.keySet().stream().map(pos -> Pair.of((Object)pos, (Object)camPos.method_1025(PositionUtils.centerOf(pos)))).sorted(Collections.reverseOrder(Comparator.comparingDouble(Pair::getSecond))).forEach(pair -> {
                class_2338 pos = (class_2338)pair.getFirst();
                this.cacheData.renderingPositions.put(pos, (List)renderingPositions.get(pos));
            });
        }
        if (TweakerMoreConfigs.TWEAKERMORE_DEBUG_BOOL.getBooleanValue() && FabricUtils.isDevelopmentEnvironment()) {
            Function<class_2338, Double> distanceGetter = pos -> camPos.method_1022(PositionUtils.centerOf(pos));
            Set<class_2338> positions = this.cacheData.renderingPositions.keySet();
            double maxDis = positions.stream().map(distanceGetter).mapToDouble(x -> x).max().orElse(1.0);
            positions.forEach(pos -> TextRenderer.create().color(0xFFFFFF00 | (int)(255.0 * (Double)distanceGetter.apply((class_2338)pos) / maxDis)).atCenter((class_2338)pos).text("x").render());
        }
        this.cacheData.renderingPositions.forEach((pos, renderers) -> {
            for (InfoViewer.Renderer renderer : renderers) {
                renderer.render(renderContext, this.cacheData.worldView, (class_2338)pos);
            }
        });
    }

    public void onClientTick() {
        this.cacheData = null;
    }

    private static class CacheData {
        private final class_1937 bestWorld;
        private final class_1937 clientWorld;
        private final RenderVisitorWorldView worldView;
        private final ScanningCache scanningCache;
        private final Map<class_2338, List<InfoViewer.Renderer>> renderingPositions;

        private CacheData(class_1937 bestWorld, class_1937 clientWorld) {
            this.bestWorld = bestWorld;
            this.clientWorld = clientWorld;
            SimpleCachedWorldView cachedBestWorld = new SimpleCachedWorldView(bestWorld);
            SimpleCachedWorldView cachedClientWorld = clientWorld != bestWorld ? new SimpleCachedWorldView(clientWorld) : cachedBestWorld;
            this.worldView = new RenderVisitorWorldView(cachedBestWorld, cachedClientWorld);
            this.scanningCache = new ScanningCache();
            this.renderingPositions = Maps.newLinkedHashMap();
        }
    }
}

