/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.features.infoView.respawnBlock;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import fi.dy.masa.malilib.config.IConfigBoolean;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.impl.features.infoView.CommonScannerInfoViewer;
import me.fallenbreath.tweakermore.impl.features.infoView.cache.RenderVisitorWorldView;
import me.fallenbreath.tweakermore.impl.features.infoView.respawnBlock.handler.AbstractBlockHandler;
import me.fallenbreath.tweakermore.impl.features.infoView.respawnBlock.handler.BedHandler;
import me.fallenbreath.tweakermore.impl.features.infoView.respawnBlock.handler.RespawnAnchorHandler;
import me.fallenbreath.tweakermore.util.Messenger;
import me.fallenbreath.tweakermore.util.TemporaryBlockReplacer;
import me.fallenbreath.tweakermore.util.damage.DamageCalculator;
import me.fallenbreath.tweakermore.util.damage.DamageUtil;
import me.fallenbreath.tweakermore.util.render.TextRenderer;
import me.fallenbreath.tweakermore.util.render.context.RenderContext;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;

public class RespawnBlockExplosionViewer
extends CommonScannerInfoViewer {
    private static final List<BlockHandlerProvider> BLOCK_HANDLER_FACTORIES = ImmutableList.of(BedHandler::new, RespawnAnchorHandler::new);
    private final LongOpenHashSet renderedKeys = new LongOpenHashSet();
    private final Map<class_243, DamageCache> damageCache = Maps.newHashMap();

    public RespawnBlockExplosionViewer() {
        super((IConfigBoolean)TweakerMoreConfigs.INFO_VIEW_RESPAWN_BLOCK_EXPLOSION, TweakerMoreConfigs.INFO_VIEW_RESPAWN_BLOCK_EXPLOSION_RENDER_STRATEGY, TweakerMoreConfigs.INFO_VIEW_RESPAWN_BLOCK_EXPLOSION_TARGET_STRATEGY);
    }

    @Nullable
    private static class_124 stagedColor(float value, float[] bounds, class_124[] formattings) {
        if (bounds.length == formattings.length) {
            for (int i = 0; i < bounds.length; ++i) {
                if (!(value <= bounds[i])) continue;
                return formattings[i];
            }
        }
        return null;
    }

    @Override
    public boolean shouldRenderFor(RenderVisitorWorldView world, class_2338 pos) {
        for (BlockHandlerProvider factory : BLOCK_HANDLER_FACTORIES) {
            if (!factory.construct(world, pos, world.method_8320(pos)).isValid()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean requireBlockEntitySyncing(RenderVisitorWorldView world, class_2338 pos) {
        return false;
    }

    @Override
    protected void render(RenderContext context, RenderVisitorWorldView world, class_2338 pos, boolean isCrossHairPos) {
        class_310 mc = class_310.method_1551();
        class_638 clientWorld = mc.field_1687;
        if (clientWorld == null || mc.field_1724 == null) {
            return;
        }
        Optional<AbstractBlockHandler> optionalBlockHandler = BLOCK_HANDLER_FACTORIES.stream().map(fac -> fac.construct(world, pos, world.method_8320(pos))).filter(AbstractBlockHandler::isValid).findFirst();
        if (!optionalBlockHandler.isPresent()) {
            return;
        }
        AbstractBlockHandler handler = optionalBlockHandler.get();
        if (!this.renderedKeys.add(handler.getDeduplicationKey().method_10063())) {
            return;
        }
        DamageCache cache = this.damageCache.computeIfAbsent(handler.getExplosionCenter(), explosionCenter -> {
            TemporaryBlockReplacer replacer = new TemporaryBlockReplacer((class_1937)clientWorld);
            handler.addBlocksToRemove(replacer);
            replacer.removeBlocks();
            DamageCalculator calculator = DamageCalculator.explosion(explosionCenter, handler.getExplosionPower(), (class_1309)mc.field_1724);
            replacer.restoreBlocks();
            class_1937 bestWorld = world.getBestWorld();
            if (bestWorld instanceof class_3218) {
                calculator.setServerWorld((class_3218)bestWorld);
            }
            calculator.applyDifficulty(bestWorld.method_8407());
            float baseAmount = calculator.getDamageAmount();
            calculator.applyArmorAndResistanceAndEnchantment();
            float appliedAmount = calculator.getDamageAmount();
            calculator.applyAbsorption();
            float remainingHealth = calculator.getEntityHealthAfterDeal();
            return new DamageCache(calculator.getDamageSource(), baseAmount, appliedAmount, remainingHealth);
        });
        class_124 amountFmt = RespawnBlockExplosionViewer.stagedColor(cache.remainingHealth, new float[]{0.0f, mc.field_1724.method_6063() * 0.2f}, new class_124[]{class_124.field_1061, class_124.field_1065});
        class_124 lineFmt = RespawnBlockExplosionViewer.stagedColor(cache.baseAmount, new float[]{1.0E-6f, DamageUtil.modifyDamageForDifficulty(1.0f, world.getBestWorld().method_8407(), cache.damageSource)}, new class_124[]{class_124.field_1063, class_124.field_1080});
        Function<Float, class_5250> float2text = hp -> {
            class_5250 text = Messenger.s(String.format("%.2f", hp));
            if (amountFmt != null) {
                Messenger.formatting(text, amountFmt);
            }
            return text;
        };
        Function<class_5250, class_5250> lineModifier = text -> {
            if (amountFmt == null && lineFmt != null) {
                Messenger.formatting(text, lineFmt);
            }
            return text;
        };
        class_5250 line1 = Messenger.tr("tweakermore.impl.infoViewRespawnBlockExplosion.damage", float2text.apply(Float.valueOf(cache.appliedAmount)));
        class_5250 line2 = Messenger.c("-> ", float2text.apply(Float.valueOf(cache.remainingHealth)), "HP");
        double alpha = TweakerMoreConfigs.INFO_VIEW_RESPAWN_BLOCK_EXPLOSION_TEXT_ALPHA.getDoubleValue();
        if (alpha > 0.0) {
            int textAlphaBits = ((int)Math.round(255.0 * alpha) & 0xFF) << 24;
            int bgAlphaBits = ((int)Math.round(31.0 * alpha) & 0xFF) << 24;
            TextRenderer.create().at(handler.getTextPosition()).addLine((class_2561)lineModifier.apply(line1)).addLine((class_2561)lineModifier.apply(line2)).color(0xFFFFFF | textAlphaBits, 0 | bgAlphaBits).seeThrough().shadow().render();
        }
    }

    @Override
    public void onInfoViewStart() {
        this.renderedKeys.clear();
    }

    @Override
    public void onClientTick() {
        this.damageCache.clear();
    }

    @FunctionalInterface
    private static interface BlockHandlerProvider {
        public AbstractBlockHandler construct(RenderVisitorWorldView var1, class_2338 var2, class_2680 var3);
    }

    private static class DamageCache {
        public final class_1282 damageSource;
        public final float baseAmount;
        public final float appliedAmount;
        public final float remainingHealth;

        public DamageCache(class_1282 damageSource, float baseAmount, float appliedAmount, float remainingHealth) {
            this.damageSource = damageSource;
            this.baseAmount = baseAmount;
            this.appliedAmount = appliedAmount;
            this.remainingHealth = remainingHealth;
        }
    }
}

