/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.util.condition;

import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.List;
import me.fallenbreath.conditionalmixin.api.annotation.Condition;
import me.fallenbreath.tweakermore.util.FabricUtils;

public class ModPredicate {
    public final String modId;
    public final List<String> versionPredicates;
    private final boolean satisfied;

    private ModPredicate(String modId, List<String> versionPredicates) {
        this.modId = modId;
        this.versionPredicates = versionPredicates;
        this.satisfied = FabricUtils.isModLoaded(this.modId) && FabricUtils.doesModFitsAnyPredicate(this.modId, this.versionPredicates);
    }

    public static ModPredicate of(Condition condition) {
        if (condition.type() != Condition.Type.MOD) {
            throw new IllegalArgumentException("Only MOD condition type is accepted");
        }
        return new ModPredicate(condition.value(), Arrays.asList(condition.versionPredicates()));
    }

    public boolean isSatisfied() {
        return this.satisfied;
    }

    public String getVersionPredicatesString() {
        return Joiner.on((String)" || ").join(this.versionPredicates);
    }

    public String toString() {
        return this.modId + (String)(this.versionPredicates.isEmpty() ? "" : " " + this.getVersionPredicatesString());
    }
}

