/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.mixins.tweaks.features.fireworkRocketThrottler;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import fi.dy.masa.malilib.util.InfoUtils;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1781;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3965;
import net.minecraft.class_636;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_636.class})
public abstract class ClientPlayerInteractionManagerMixin {
    @Unique
    private long lastFireworkRocketUsageMilli = 0L;

    @Inject(method={"useItemOn"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientPacketListener;send(Lnet/minecraft/network/protocol/Packet;)V", ordinal=2)}, cancellable=true)
    private void fireworkRocketThrottler_cancelIfCooldown_useOnBlock(class_746 player, class_638 world, class_1268 hand, class_3965 hitResult, CallbackInfoReturnable<class_1269> cir) {
        this.cancelIfCooldown((class_1657)player, hand, cir);
    }

    @Inject(method={"useItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientPacketListener;send(Lnet/minecraft/network/protocol/Packet;)V")}, cancellable=true)
    private void fireworkRocketThrottler_cancelIfCooldown_useAtAir(class_1657 player, class_1937 world, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        this.cancelIfCooldown(player, hand, cir);
    }

    @Unique
    private void cancelIfCooldown(class_1657 player, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        class_1799 itemStack;
        if (TweakerMoreConfigs.FIREWORK_ROCKET_THROTTLER.getBooleanValue() && (itemStack = player.method_5998(hand)).method_7909() instanceof class_1781) {
            long now = System.currentTimeMillis();
            double cooldown = TweakerMoreConfigs.FIREWORK_ROCKET_THROTTLER_COOLDOWN.getDoubleValue();
            double remaining = cooldown - (double)(now - this.lastFireworkRocketUsageMilli) / 1000.0;
            if (remaining > 0.0) {
                InfoUtils.printActionbarMessage((String)"tweakermore.impl.fireworkRocketThrottler.throttled", (Object[])new Object[]{String.format("%.1f", remaining)});
                cir.setReturnValue((Object)class_1269.field_5814);
            }
        }
    }

    @ModifyExpressionValue(method={"useItemOn"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;useOn(Lnet/minecraft/world/item/context/UseOnContext;)Lnet/minecraft/world/InteractionResult;")})
    private class_1269 fireworkRocketThrottler_updateCooldown_useOnBlock(class_1269 actionResult) {
        this.updateCooldownOnUse(actionResult);
        return actionResult;
    }

    @ModifyExpressionValue(method={"useItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/InteractionResultHolder;getResult()Lnet/minecraft/world/InteractionResult;")})
    private class_1269 fireworkRocketThrottler_updateCooldown_useAtAir(class_1269 actionResult) {
        this.updateCooldownOnUse(actionResult);
        return actionResult;
    }

    @Unique
    private void updateCooldownOnUse(class_1269 actionResult) {
        if (TweakerMoreConfigs.FIREWORK_ROCKET_THROTTLER.getBooleanValue() && actionResult.method_23665()) {
            this.lastFireworkRocketUsageMilli = System.currentTimeMillis();
        }
    }
}

