/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.features.infoView.beacon;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import fi.dy.masa.malilib.config.IConfigBoolean;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.ArrayList;
import java.util.Optional;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.impl.features.infoView.CommonScannerInfoViewer;
import me.fallenbreath.tweakermore.impl.features.infoView.cache.RenderVisitorWorldView;
import me.fallenbreath.tweakermore.mixins.tweaks.features.infoView.beacon.BeaconBlockEntityAccessor;
import me.fallenbreath.tweakermore.util.PositionUtils;
import me.fallenbreath.tweakermore.util.render.InWorldPositionTransformer;
import me.fallenbreath.tweakermore.util.render.RenderUtils;
import me.fallenbreath.tweakermore.util.render.TextRenderer;
import me.fallenbreath.tweakermore.util.render.context.MixedRenderContext;
import me.fallenbreath.tweakermore.util.render.context.RenderGlobals;
import me.fallenbreath.tweakermore.util.render.context.WorldRenderContext;
import net.minecraft.class_1058;
import net.minecraft.class_1291;
import net.minecraft.class_2238;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2580;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class BeaconEffectRenderer
extends CommonScannerInfoViewer {
    private static final double FONT_SCALE = 0.025;
    private static final double MARGIN = 5.0;
    private static final int ICON_SIZE = 18;
    private static final int ICON_RENDERED_SIZE = RenderUtils.TEXT_HEIGHT;

    public BeaconEffectRenderer() {
        super((IConfigBoolean)TweakerMoreConfigs.INFO_VIEW_BEACON, TweakerMoreConfigs.INFO_VIEW_BEACON_RENDER_STRATEGY, TweakerMoreConfigs.INFO_VIEW_BEACON_TARGET_STRATEGY);
    }

    @Override
    public boolean shouldRenderFor(RenderVisitorWorldView world, class_2338 pos) {
        return world.method_8320(pos).method_26204() instanceof class_2238 && world.method_8321(pos) instanceof class_2580;
    }

    @Override
    public boolean requireBlockEntitySyncing(RenderVisitorWorldView world, class_2338 pos) {
        return true;
    }

    @Override
    protected void render(WorldRenderContext context, RenderVisitorWorldView world, class_2338 pos, boolean isCrossHairPos) {
        class_2586 blockEntity = world.method_8321(pos);
        if (!(blockEntity instanceof class_2580)) {
            return;
        }
        BeaconBlockEntityAccessor accessor = (BeaconBlockEntityAccessor)blockEntity;
        int beaconLevel = accessor.getLevel();
        class_1291 primary = Optional.ofNullable(accessor.getPrimary()).map(class_6880::comp_349).orElse(null);
        class_1291 secondary = Optional.ofNullable(accessor.getSecondary()).map(class_6880::comp_349).orElse(null);
        if (primary != null) {
            ArrayList effects = Lists.newArrayList();
            effects.add(Pair.of((Object)primary, (Object)(beaconLevel >= 4 && primary == secondary ? 1 : 0)));
            if (beaconLevel >= 4 && primary != secondary && secondary != null) {
                effects.add(Pair.of((Object)secondary, (Object)0));
            }
            class_243 centerPos = PositionUtils.centerOf(pos);
            double maxWidth = effects.stream().mapToDouble(pair -> this.calculateRowWidth((class_1291)pair.getFirst(), (Integer)pair.getSecond())).max().orElse(0.0);
            for (int i = 0; i < effects.size(); ++i) {
                Pair pair2 = (Pair)effects.get(i);
                class_1291 statusEffect = (class_1291)pair2.getFirst();
                int amplifier = (Integer)pair2.getSecond();
                double deltaX = -maxWidth / 2.0;
                double kDeltaY = (double)i - (double)(effects.size() - 1) / 2.0;
                this.renderStatusEffectIcon(context, centerPos, statusEffect, amplifier, deltaX, kDeltaY);
                this.renderStatusEffectText(centerPos, statusEffect, amplifier, deltaX, kDeltaY);
            }
        }
    }

    private double calculateRowWidth(class_1291 statusEffect, int amplifier) {
        double textWidth = RenderUtils.getRenderWidth(BeaconEffectRenderer.getStatusEffectText(statusEffect, amplifier));
        return (double)ICON_RENDERED_SIZE + 5.0 + textWidth;
    }

    private void renderStatusEffectIcon(WorldRenderContext context, class_243 pos, class_1291 statusEffect, int amplifier, double deltaX, double kDeltaY) {
        class_310 mc = class_310.method_1551();
        class_1058 sprite = mc.method_18505().method_18663(class_7923.field_41174.method_47983((Object)statusEffect));
        MixedRenderContext renderContext = MixedRenderContext.create();
        InWorldPositionTransformer positionTransformer = new InWorldPositionTransformer(pos);
        positionTransformer.apply(renderContext);
        RenderGlobals.disableDepthTest();
        RenderGlobals.enableBlend();
        renderContext.scale(0.025 * (double)RenderUtils.getSizeScalingXSign(), -0.025, 0.025);
        renderContext.translate(deltaX, 0.0, 0.0);
        double k = 1.0 * (double)ICON_RENDERED_SIZE / 18.0;
        renderContext.scale(k, k, k);
        renderContext.translate(0.0, 18.0 * (-0.5 + kDeltaY), 0.0);
        RenderSystem.setShaderTexture((int)0, (class_2960)sprite.method_45852());
        RenderGlobals.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        renderContext.getGuiDrawer().method_25298(0, 0, 0, 18, 18, sprite);
        RenderGlobals.enableDepthTest();
        positionTransformer.restore();
    }

    private void renderStatusEffectText(class_243 pos, class_1291 statusEffect, int amplifier, double deltaX, double kDeltaY) {
        String description = BeaconEffectRenderer.getStatusEffectText(statusEffect, amplifier);
        TextRenderer textRenderer = TextRenderer.create().at(pos).text(description).fontScale(0.025).align(TextRenderer.HorizontalAlignment.LEFT).seeThrough().shadow();
        textRenderer.shift(deltaX + (double)ICON_RENDERED_SIZE + 5.0, kDeltaY * textRenderer.getLineHeight());
        textRenderer.render();
    }

    private static String getStatusEffectText(class_1291 statusEffect, int amplifier) {
        return StringUtils.translate((String)statusEffect.method_5567(), (Object[])new Object[0]) + " " + StringUtils.translate((String)("enchantment.level." + (amplifier + 1)), (Object[])new Object[0]);
    }
}

