/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.mc_tweaks.shulkerBoxItemContentHint;

import java.util.Optional;
import java.util.function.Predicate;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.impl.mc_tweaks.shulkerBoxItemContentHint.ShulkerBoxItemContentHintRenderer;
import me.fallenbreath.tweakermore.util.IdentifierUtils;
import me.fallenbreath.tweakermore.util.InventoryUtils;
import me.fallenbreath.tweakermore.util.ItemUtils;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_9334;

public class ShulkerBoxItemContentHintCommon {
    public static Info prepareInformation(class_1799 itemStack) {
        Optional<class_1799> override;
        Info info = new Info();
        info.enabled = false;
        if (!TweakerMoreConfigs.SHULKER_BOX_ITEM_CONTENT_HINT.getBooleanValue()) {
            return info;
        }
        if (ShulkerBoxItemContentHintRenderer.isRendering.get().booleanValue()) {
            return info;
        }
        if (!ItemUtils.isShulkerBox(itemStack.method_7909())) {
            return info;
        }
        Optional<class_2371<class_1799>> stackList = InventoryUtils.getStoredItems(itemStack);
        if (!stackList.isPresent()) {
            return info;
        }
        Predicate<class_1799> stackFilter = stack -> true;
        if (TweakerMoreConfigs.SHULKER_BOX_ITEM_CONTENT_HINT_CUSTOM_NAMES_OVERRIDE_ITEM.getBooleanValue() && (override = ShulkerBoxItemContentHintCommon.computeCustomNameOverride(itemStack)).isPresent()) {
            stackFilter = stack -> class_1799.method_7984((class_1799)stack, (class_1799)((class_1799)override.get()));
        }
        class_1799 std = null;
        info.allItemSame = true;
        info.allItemSameIgnoreNbt = true;
        for (class_1799 stack2 : stackList.get()) {
            if (stack2.method_7960() || !stackFilter.test(stack2)) continue;
            if (std == null) {
                std = stack2;
                continue;
            }
            boolean itemEqual = class_1799.method_7984((class_1799)stack2, (class_1799)std);
            boolean itemAndNbtEqual = class_1799.method_31577((class_1799)stack2, (class_1799)std);
            if (!itemAndNbtEqual) {
                info.allItemSame = false;
            }
            if (itemEqual) continue;
            info.allItemSameIgnoreNbt = false;
        }
        if (std == null) {
            return info;
        }
        info.stack = std;
        info.scale = TweakerMoreConfigs.SHULKER_BOX_ITEM_CONTENT_HINT_SCALE.getDoubleValue();
        if (info.scale <= 0.0) {
            return info;
        }
        info.enabled = true;
        info.fillRatio = -1.0;
        int slotAmount = InventoryUtils.getInventorySlotAmount(itemStack);
        if (slotAmount != -1) {
            double sum = 0.0;
            for (class_1799 stack3 : stackList.get()) {
                sum += 1.0 * (double)stack3.method_7947() / (double)stack3.method_7914();
            }
            double ratio = sum / (double)slotAmount;
            if (ratio >= 0.0 && ratio <= 1.0) {
                info.fillRatio = ratio;
            }
        }
        return info;
    }

    private static Optional<class_1799> computeCustomNameOverride(class_1799 shulkerBoxItemStack) {
        if (!shulkerBoxItemStack.method_57826(class_9334.field_49631)) {
            return Optional.empty();
        }
        Optional<class_2960> itemIdOpt = IdentifierUtils.tryParse(shulkerBoxItemStack.method_7964().getString());
        if (!itemIdOpt.isPresent()) {
            return Optional.empty();
        }
        if (!class_7923.field_41178.method_10250(itemIdOpt.get())) {
            return Optional.empty();
        }
        class_1792 item = (class_1792)class_7923.field_41178.method_10223(itemIdOpt.get());
        return Optional.of(new class_1799((class_1935)item));
    }

    public static class Info {
        public boolean enabled;
        public boolean allItemSame;
        public boolean allItemSameIgnoreNbt;
        public double scale;
        public class_1799 stack;
        public double fillRatio;
    }
}

