/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.config;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import fi.dy.masa.malilib.config.ConfigUtils;
import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.config.IConfigHandler;
import fi.dy.masa.malilib.util.JsonUtils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.fallenbreath.tweakermore.TweakerMoreMod;
import me.fallenbreath.tweakermore.config.Config;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.config.TweakerMoreOption;
import me.fallenbreath.tweakermore.config.migration.ConfigRenameMigration;
import me.fallenbreath.tweakermore.config.statistic.OptionStatisticSaver;
import me.fallenbreath.tweakermore.gui.TweakerMoreConfigGui;
import me.fallenbreath.tweakermore.util.FabricUtils;
import me.fallenbreath.tweakermore.util.FileUtils;
import me.fallenbreath.tweakermore.util.JsonSaveAble;

public class TweakerMoreConfigStorage
implements IConfigHandler {
    private static final TweakerMoreConfigStorage INSTANCE = new TweakerMoreConfigStorage();
    private static final Map<String, JsonSaveAble> INTERNAL_DATA_SAVERS = new ImmutableMap.Builder().put((Object)"configGui", (Object)TweakerMoreConfigGui.getSetting()).put((Object)"configStatistic", (Object)new OptionStatisticSaver()).build();
    private JsonObject loadedJson = new JsonObject();

    private TweakerMoreConfigStorage() {
    }

    public static TweakerMoreConfigStorage getInstance() {
        return INSTANCE;
    }

    private static <T extends IConfigBase> List<T> getConfigOptions(Config.Type optionType) {
        return TweakerMoreConfigs.getOptions(optionType).stream().filter(o -> !o.isDevOnly() || FabricUtils.isDevelopmentEnvironment()).map(TweakerMoreOption::getConfig).collect(Collectors.toList());
    }

    public void load() {
        JsonElement element;
        JsonObject root = null;
        File configFile = FileUtils.getConfigFile();
        if (configFile.exists() && configFile.isFile() && configFile.canRead() && (element = JsonUtils.parseJsonFile((File)configFile)) != null && element.isJsonObject()) {
            root = element.getAsJsonObject();
        }
        if (root != null) {
            this.loadFromJson(root, true);
        }
    }

    public void loadFromJson(JsonObject root, boolean isSelfConfig) {
        if (isSelfConfig) {
            this.loadedJson = new JsonParser().parse(root.toString()).getAsJsonObject();
            ConfigRenameMigration.patchConfig(root, Lists.newArrayList((Object[])new String[]{"Generic", "GenericHotkeys", "Lists", "Fixes", "TweakHotkeys", "TweakToggles", "DisableHotkeys", "DisableToggles"}));
        }
        ConfigUtils.readConfigBase((JsonObject)root, (String)"Generic", TweakerMoreConfigStorage.getConfigOptions(Config.Type.GENERIC));
        ConfigUtils.readConfigBase((JsonObject)root, (String)"GenericHotkeys", TweakerMoreConfigStorage.getConfigOptions(Config.Type.HOTKEY));
        ConfigUtils.readConfigBase((JsonObject)root, (String)"Lists", TweakerMoreConfigStorage.getConfigOptions(Config.Type.LIST));
        ConfigUtils.readHotkeyToggleOptions((JsonObject)root, (String)"TweakHotkeys", (String)"TweakToggles", TweakerMoreConfigStorage.getConfigOptions(Config.Type.TWEAK));
        ConfigUtils.readHotkeyToggleOptions((JsonObject)root, (String)"DisableHotkeys", (String)"DisableToggles", TweakerMoreConfigStorage.getConfigOptions(Config.Type.DISABLE));
        ConfigUtils.readConfigBase((JsonObject)root, (String)"Fixes", TweakerMoreConfigStorage.getConfigOptions(Config.Type.FIX));
        this.loadInternal(root);
        TweakerMoreConfigs.onConfigLoaded();
    }

    private void loadInternal(JsonObject jsonObject) {
        JsonObject internal = JsonUtils.getNestedObject((JsonObject)jsonObject, (String)"internal", (boolean)false);
        if (internal != null) {
            INTERNAL_DATA_SAVERS.forEach((name, jsonSaveAble) -> {
                JsonObject object = JsonUtils.getNestedObject((JsonObject)internal, (String)name, (boolean)false);
                if (object != null) {
                    jsonSaveAble.loadFromJsonSafe(object);
                }
            });
        }
    }

    public void save() {
        try {
            JsonObject root = TweakerMoreConfigs.PRESERVE_CONFIG_UNKNOWN_ENTRIES.getBooleanValue() ? this.loadedJson : new JsonObject();
            ConfigUtils.writeConfigBase((JsonObject)root, (String)"Generic", TweakerMoreConfigStorage.getConfigOptions(Config.Type.GENERIC));
            ConfigUtils.writeConfigBase((JsonObject)root, (String)"GenericHotkeys", TweakerMoreConfigStorage.getConfigOptions(Config.Type.HOTKEY));
            ConfigUtils.writeConfigBase((JsonObject)root, (String)"Lists", TweakerMoreConfigStorage.getConfigOptions(Config.Type.LIST));
            ConfigUtils.writeHotkeyToggleOptions((JsonObject)root, (String)"TweakHotkeys", (String)"TweakToggles", TweakerMoreConfigStorage.getConfigOptions(Config.Type.TWEAK));
            ConfigUtils.writeHotkeyToggleOptions((JsonObject)root, (String)"DisableHotkeys", (String)"DisableToggles", TweakerMoreConfigStorage.getConfigOptions(Config.Type.DISABLE));
            ConfigUtils.writeConfigBase((JsonObject)root, (String)"Fixes", TweakerMoreConfigStorage.getConfigOptions(Config.Type.FIX));
            this.saveInternal(root);
            File configFile = FileUtils.getConfigFile();
            File tempFile = new File(configFile.getParent(), configFile.getName() + ".tmp");
            JsonUtils.writeJsonToFile((JsonObject)root, (File)tempFile);
            Files.move(tempFile.toPath(), configFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            TweakerMoreMod.LOGGER.error("Failed to save the config file of TweakerMore", (Throwable)e);
        }
    }

    private void saveInternal(JsonObject jsonObject) {
        JsonObject internal = JsonUtils.getNestedObject((JsonObject)jsonObject, (String)"internal", (boolean)true);
        assert (internal != null);
        INTERNAL_DATA_SAVERS.forEach((name, jsonSaveAble) -> internal.add(name, (JsonElement)jsonSaveAble.dumpToJson()));
    }
}

