/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.config;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.fallenbreath.tweakermore.config.Config;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.config.comment.MarkProcessor;
import me.fallenbreath.tweakermore.config.comment.TagProcessor;
import me.fallenbreath.tweakermore.config.options.TweakerMoreIConfigBase;
import me.fallenbreath.tweakermore.config.statistic.OptionStatistic;
import me.fallenbreath.tweakermore.util.condition.ModPredicate;
import me.fallenbreath.tweakermore.util.condition.ModRestriction;
import org.jetbrains.annotations.Nullable;

public class TweakerMoreOption {
    private final Config annotation;
    private final TweakerMoreIConfigBase config;
    private final List<ModRestriction> modRestrictions;
    private final List<ModRestriction> minecraftRestrictions;
    private final OptionStatistic statistic;
    @Nullable
    protected Function<String, String> commentModifier = null;
    private boolean appendFooterFlag = true;

    public TweakerMoreOption(Config annotation, TweakerMoreIConfigBase config) {
        this.annotation = annotation;
        this.config = config;
        this.modRestrictions = Arrays.stream(annotation.restriction()).map(ModRestriction::of).collect(Collectors.toList());
        this.minecraftRestrictions = Arrays.stream(annotation.restriction()).map(r -> ModRestriction.of(r, c -> "minecraft".equals(c.value()))).collect(Collectors.toList());
        this.statistic = new OptionStatistic();
    }

    public Config.Type getType() {
        return this.annotation.type();
    }

    public Config.Category getCategory() {
        return this.annotation.category();
    }

    public List<ModRestriction> getModRestrictions() {
        return this.modRestrictions;
    }

    public OptionStatistic getStatistic() {
        return this.statistic;
    }

    public boolean isEnabled() {
        return this.modRestrictions.isEmpty() || this.modRestrictions.stream().anyMatch(ModRestriction::isSatisfied);
    }

    public boolean worksForCurrentMCVersion() {
        return this.minecraftRestrictions.isEmpty() || this.minecraftRestrictions.stream().anyMatch(ModRestriction::isSatisfied);
    }

    public boolean isDebug() {
        return this.annotation.debug();
    }

    public boolean isDevOnly() {
        return this.annotation.devOnly();
    }

    public TweakerMoreIConfigBase getConfig() {
        return this.config;
    }

    private static List<String> getFooter(Collection<ModPredicate> modPredicates, boolean nice, boolean good, String footerTextKey) {
        if (modPredicates.size() > 0) {
            ArrayList lines = Lists.newArrayList();
            lines.add((nice ? GuiBase.TXT_GRAY : GuiBase.TXT_RED) + GuiBase.TXT_ITALIC + StringUtils.translate((String)footerTextKey, (Object[])new Object[0]) + GuiBase.TXT_RST);
            for (ModPredicate modPredicate : modPredicates) {
                String element = String.format("%s (%s) %s", StringUtils.translate((String)("tweakermore.util.mod." + modPredicate.modId), (Object[])new Object[0]), modPredicate.modId, modPredicate.getVersionPredicatesString());
                String color = good && modPredicate.isSatisfied() || !good && !modPredicate.isSatisfied() ? GuiBase.TXT_GRAY : GuiBase.TXT_RED;
                String lineItem = color + GuiBase.TXT_ITALIC + element + GuiBase.TXT_GRAY + GuiBase.TXT_ITALIC;
                lines.add(GuiBase.TXT_DARK_GRAY + GuiBase.TXT_ITALIC + "- " + lineItem);
            }
            return lines;
        }
        return Collections.emptyList();
    }

    private List<String> getModRelationsFooter() {
        ArrayList result = Lists.newArrayList();
        boolean first = true;
        for (ModRestriction modRestriction : this.modRestrictions) {
            if (!first) {
                result.add(GuiBase.TXT_DARK_GRAY + GuiBase.TXT_ITALIC + String.format("--- %s ---", StringUtils.translate((String)"tweakermore.gui.mod_relation_footer.or", (Object[])new Object[0])));
            }
            first = false;
            result.addAll(TweakerMoreOption.getFooter(modRestriction.getRequirements(), modRestriction.isRequirementsSatisfied(), true, "tweakermore.gui.mod_relation_footer.requirement"));
            result.addAll(TweakerMoreOption.getFooter(modRestriction.getConflictions(), modRestriction.isNoConfliction(), false, "tweakermore.gui.mod_relation_footer.confliction"));
        }
        return result;
    }

    public void setCommentModifier(@Nullable Function<String, String> commentModifier) {
        this.commentModifier = commentModifier;
    }

    public void setAppendFooterFlag(boolean appendFooterFlag) {
        this.appendFooterFlag = appendFooterFlag;
    }

    public String modifyComment(String comment) {
        if (this.commentModifier != null) {
            comment = this.commentModifier.apply(comment);
        }
        if (this.appendFooterFlag) {
            List<String> footers = this.getModRelationsFooter();
            if (!footers.isEmpty()) {
                comment = comment + "\n" + Joiner.on((String)"\n").join(footers);
            }
            if (TweakerMoreConfigs.TWEAKERMORE_DEBUG_MODE.getBooleanValue()) {
                List<String> lines = this.statistic.getDisplayLines();
                comment = comment + "\n" + GuiBase.TXT_DARK_GRAY + "-------------------------" + GuiBase.TXT_RST + "\n" + GuiBase.TXT_GRAY + StringUtils.translate((String)"tweakermore.statistic.debug_title", (Object[])new Object[0]) + GuiBase.TXT_RST + "\n" + Joiner.on((char)'\n').join(lines.stream().map(line -> GuiBase.TXT_DARK_GRAY + "- " + GuiBase.TXT_GRAY + line + GuiBase.TXT_RST).toArray());
            }
        }
        comment = TagProcessor.processReferences(comment);
        comment = MarkProcessor.processMarks(comment);
        return comment;
    }
}

