/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.features.autoContainerProcess;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import me.fallenbreath.tweakermore.impl.features.autoContainerProcess.AutoProcessableScreen;
import me.fallenbreath.tweakermore.impl.features.autoContainerProcess.processors.ContainerCleaner;
import me.fallenbreath.tweakermore.impl.features.autoContainerProcess.processors.ContainerFiller;
import me.fallenbreath.tweakermore.impl.features.autoContainerProcess.processors.ContainerItemPutBackProcessor;
import me.fallenbreath.tweakermore.impl.features.autoContainerProcess.processors.ContainerMaterialListItemCollector;
import me.fallenbreath.tweakermore.impl.features.autoContainerProcess.processors.IContainerProcessor;
import me.fallenbreath.tweakermore.impl.features.autoContainerProcess.processors.ProcessResult;
import me.fallenbreath.tweakermore.mixins.tweaks.features.autoContainerProcess.ItemScrollerInventoryUtilsAccessor;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_479;
import net.minecraft.class_481;
import net.minecraft.class_490;
import net.minecraft.class_492;
import net.minecraft.class_746;

public class ContainerProcessorManager {
    private static final List<IContainerProcessor> CONTAINER_PROCESSORS = ImmutableList.of((Object)new ContainerCleaner(), (Object)new ContainerFiller(), (Object)new ContainerItemPutBackProcessor(), (Object)new ContainerMaterialListItemCollector());

    private static boolean hasTweakEnabled() {
        return CONTAINER_PROCESSORS.stream().anyMatch(IContainerProcessor::isEnabled);
    }

    public static List<IContainerProcessor> getProcessors() {
        return CONTAINER_PROCESSORS;
    }

    public static void process(class_1703 container) {
        if (ContainerProcessorManager.hasTweakEnabled()) {
            class_437 screen = class_310.method_1551().field_1755;
            class_746 player = class_310.method_1551().field_1724;
            if (player != null && screen instanceof class_465) {
                if (player.method_7325()) {
                    return;
                }
                class_465 containerScreen = (class_465)screen;
                if (containerScreen.method_17577() != container || !((AutoProcessableScreen)screen).shouldProcess$TKM()) {
                    return;
                }
                if (ContainerProcessorManager.isInBlackList(containerScreen)) {
                    return;
                }
                ((AutoProcessableScreen)screen).setShouldProcess$TKM(false);
                List allSlots = container.field_7761;
                List<class_1735> playerInvSlots = allSlots.stream().filter(slot -> slot.field_7871 instanceof class_1661).collect(Collectors.toList());
                if (allSlots.isEmpty() || playerInvSlots.isEmpty()) {
                    return;
                }
                List<class_1735> containerInvSlots = allSlots.stream().filter(slot -> ItemScrollerInventoryUtilsAccessor.areSlotsInSameInventory(slot, (class_1735)allSlots.get(0))).collect(Collectors.toList());
                if (containerInvSlots.isEmpty()) {
                    return;
                }
                boolean closeGui = false;
                for (IContainerProcessor processor : CONTAINER_PROCESSORS) {
                    if (!processor.isEnabled()) continue;
                    ProcessResult result = processor.process(player, containerScreen, allSlots, playerInvSlots, containerInvSlots);
                    closeGui |= result.closeGui;
                    if (!result.cancelProcessing) continue;
                    break;
                }
                if (closeGui) {
                    player.method_7346();
                }
            }
        }
    }

    private static <T extends class_1703> boolean isInBlackList(class_465<T> containerScreen) {
        return containerScreen instanceof class_490 || containerScreen instanceof class_481 || containerScreen instanceof class_479 || containerScreen instanceof class_492;
    }
}

