/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.features.schematicProPlace.restrict;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import me.fallenbreath.tweakermore.impl.features.schematicProPlace.restrict.InteractAbleTester;
import me.fallenbreath.tweakermore.impl.features.schematicProPlace.restrict.InteractAllowedTester;
import me.fallenbreath.tweakermore.impl.features.schematicProPlace.restrict.InteractAllowedTesters;
import net.minecraft.class_1657;
import net.minecraft.class_2199;
import net.minecraft.class_2238;
import net.minecraft.class_2244;
import net.minecraft.class_2248;
import net.minecraft.class_2260;
import net.minecraft.class_2269;
import net.minecraft.class_2272;
import net.minecraft.class_2275;
import net.minecraft.class_2281;
import net.minecraft.class_2286;
import net.minecraft.class_2304;
import net.minecraft.class_2309;
import net.minecraft.class_2315;
import net.minecraft.class_2323;
import net.minecraft.class_2331;
import net.minecraft.class_2336;
import net.minecraft.class_2349;
import net.minecraft.class_2363;
import net.minecraft.class_2401;
import net.minecraft.class_2406;
import net.minecraft.class_2428;
import net.minecraft.class_2462;
import net.minecraft.class_2478;
import net.minecraft.class_2480;
import net.minecraft.class_2533;
import net.minecraft.class_2680;
import net.minecraft.class_3708;
import net.minecraft.class_3711;
import net.minecraft.class_3713;
import net.minecraft.class_3718;

public class BlockInteractionRestrictor {
    private static final Map<Class<? extends class_2248>, InteractAbleTester> INTERACT_ABLE_TESTER_MAP = Maps.newHashMap();
    private static final Map<Class<? extends class_2248>, InteractAllowedTester> INTERACT_ALLOWED_TESTER_MAP = Maps.newHashMap();

    private static RequirementBuilder interactAble(Class<? extends class_2248> blockClass) {
        return new RequirementBuilder(blockClass);
    }

    public static Result checkInteract(class_1657 player, class_2680 worldState, class_2680 schematicState) {
        boolean shiftingAndHasItem;
        boolean hasItemOnHand = !player.method_6047().method_7960() || !player.method_6079().method_7960();
        boolean bl = shiftingAndHasItem = player.method_21823() && hasItemOnHand;
        if (shiftingAndHasItem) {
            return Result.no();
        }
        boolean canConsume = false;
        for (Class<?> clazz = worldState.method_26204().getClass(); clazz != null && clazz != class_2248.class; clazz = clazz.getSuperclass()) {
            Optional<String> failureMessage;
            InteractAbleTester tester1 = INTERACT_ABLE_TESTER_MAP.get(clazz);
            if (tester1 == null || !tester1.isInteractAble(player, worldState)) continue;
            canConsume = true;
            InteractAllowedTester tester2 = INTERACT_ALLOWED_TESTER_MAP.get(clazz);
            if (tester2 == null || !(failureMessage = tester2.isInteractionAllowed(player, worldState, schematicState)).isPresent()) continue;
            return Result.bad(failureMessage.get());
        }
        return canConsume ? Result.good() : Result.no();
    }

    static {
        BlockInteractionRestrictor.interactAble(class_2269.class).notAllowed();
        BlockInteractionRestrictor.interactAble(class_2363.class);
        BlockInteractionRestrictor.interactAble(class_2478.class);
        BlockInteractionRestrictor.interactAble(class_2199.class);
        BlockInteractionRestrictor.interactAble(class_3708.class);
        BlockInteractionRestrictor.interactAble(class_2238.class);
        BlockInteractionRestrictor.interactAble(class_2244.class);
        BlockInteractionRestrictor.interactAble(class_2260.class);
        BlockInteractionRestrictor.interactAble(class_2272.class).when(new InteractAbleTester[]{(player, worldState) -> player.method_7332(false)}).allowIf(InteractAllowedTesters.unequalProperty(class_2272.field_10739));
        BlockInteractionRestrictor.interactAble(class_3711.class);
        BlockInteractionRestrictor.interactAble(class_2275.class).notAllowed();
        BlockInteractionRestrictor.interactAble(class_2281.class);
        BlockInteractionRestrictor.interactAble(class_2286.class).when(new InteractAbleTester[]{InteractAbleTester.playerCanModifyWorld()}).allowIf(InteractAllowedTesters.unequalProperty(class_2286.field_10789));
        BlockInteractionRestrictor.interactAble(class_2304.class);
        BlockInteractionRestrictor.interactAble(class_2309.class).when(new InteractAbleTester[]{InteractAbleTester.playerCanModifyWorld()}).allowIf(InteractAllowedTesters.unequalProperty(class_2309.field_10899));
        BlockInteractionRestrictor.interactAble(class_2315.class);
        BlockInteractionRestrictor.interactAble(class_2323.class).when(new InteractAbleTester[]{InteractAbleTester.canOpenByHand()}).allowIf(InteractAllowedTesters.unequalProperty(class_2323.field_10945));
        BlockInteractionRestrictor.interactAble(class_2331.class);
        BlockInteractionRestrictor.interactAble(class_2336.class);
        BlockInteractionRestrictor.interactAble(class_2349.class).allowIf(InteractAllowedTesters.unequalProperty(class_2349.field_11026));
        BlockInteractionRestrictor.interactAble(class_3713.class);
        BlockInteractionRestrictor.interactAble(class_2401.class).allowIf(InteractAllowedTesters.unequalProperty(class_2401.field_11265));
        BlockInteractionRestrictor.interactAble(class_2406.class);
        BlockInteractionRestrictor.interactAble(class_2428.class).allowIf(InteractAllowedTesters.unequalProperty(class_2428.field_11324));
        BlockInteractionRestrictor.interactAble(class_2462.class).when(new InteractAbleTester[]{InteractAbleTester.playerCanModifyWorld()}).allowIf(InteractAllowedTesters.unequalProperty(class_2462.field_11451));
        BlockInteractionRestrictor.interactAble(class_2480.class);
        BlockInteractionRestrictor.interactAble(class_3718.class);
        BlockInteractionRestrictor.interactAble(class_2533.class).when(new InteractAbleTester[]{InteractAbleTester.canOpenByHand()}).allowIf(InteractAllowedTesters.unequalProperty(class_2323.field_10945));
    }

    private static class RequirementBuilder {
        private final Class<? extends class_2248> blockClass;

        private RequirementBuilder(Class<? extends class_2248> blockClass) {
            this.blockClass = blockClass;
            INTERACT_ABLE_TESTER_MAP.put(this.blockClass, InteractAbleTester.always());
        }

        private RequirementBuilder when(InteractAbleTester ... testers) {
            InteractAbleTester tester = InteractAbleTester.always();
            for (InteractAbleTester t : testers) {
                tester = tester.and(t);
            }
            INTERACT_ABLE_TESTER_MAP.put(this.blockClass, tester);
            return this;
        }

        private RequirementBuilder allowIf(InteractAllowedTester tester) {
            INTERACT_ALLOWED_TESTER_MAP.put(this.blockClass, tester);
            return this;
        }

        private void notAllowed() {
            INTERACT_ALLOWED_TESTER_MAP.put(this.blockClass, InteractAllowedTesters.notAllowed());
        }
    }

    public static class Result {
        private final ResultType type;
        private final String message;

        private Result(ResultType type, String message) {
            this.type = type;
            this.message = message;
        }

        public static Result no() {
            return new Result(ResultType.NO_INTERACTION, "");
        }

        public static Result good() {
            return new Result(ResultType.GOOD_INTERACTION, "");
        }

        public static Result bad(String message) {
            return new Result(ResultType.BAD_INTERACTION, message);
        }

        public ResultType getType() {
            return this.type;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static enum ResultType {
        NO_INTERACTION,
        GOOD_INTERACTION,
        BAD_INTERACTION;

    }
}

