/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.mc_tweaks.shulkerBoxTooltipHints;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.function.ToIntFunction;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.impl.mc_tweaks.shulkerBoxTooltipHints.builder.AbstractHintBuilder;
import me.fallenbreath.tweakermore.impl.mc_tweaks.shulkerBoxTooltipHints.builder.EnchantmentHintBuilder;
import me.fallenbreath.tweakermore.impl.mc_tweaks.shulkerBoxTooltipHints.builder.PotionHintBuilder;
import me.fallenbreath.tweakermore.util.InventoryUtils;
import me.fallenbreath.tweakermore.util.Messenger;
import me.fallenbreath.tweakermore.util.render.context.RenderGlobals;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2554;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class ShulkerBoxToolTipEnhancer {
    private static final List<AbstractHintBuilder> HINT_BUILDERS = ImmutableList.of((Object)new EnchantmentHintBuilder(), (Object)new PotionHintBuilder());

    public static void appendContentHints(class_1799 itemStack, class_5250 text) {
        HINT_BUILDERS.stream().map(builder -> builder.build(itemStack)).filter(Objects::nonNull).forEach(arg_0 -> ((class_5250)text).method_10852(arg_0));
    }

    public static void applyFillLevelHint(class_1799 skulker, List<class_2561> tooltip) {
        class_2561 prevSpacing;
        List siblings;
        if (!RenderGlobals.isOnRenderThread()) {
            return;
        }
        if (!TweakerMoreConfigs.SHULKER_BOX_TOOLTIP_FILL_LEVEL_HINT.getBooleanValue()) {
            return;
        }
        if (tooltip.isEmpty()) {
            return;
        }
        int slotAmount = InventoryUtils.getInventorySlotAmount(skulker);
        if (slotAmount == -1) {
            return;
        }
        class_2371 stackList = fi.dy.masa.malilib.util.InventoryUtils.getStoredItems((class_1799)skulker, (int)slotAmount);
        if (stackList.isEmpty()) {
            return;
        }
        double sum = 0.0;
        for (class_1799 stack : stackList) {
            sum += 1.0 * (double)stack.method_7947() / (double)stack.method_7914();
        }
        double ratio = sum / (double)slotAmount;
        class_124 color = ratio >= 1.0 ? class_124.field_1077 : class_124.field_1080;
        class_2554 fillLevelText = Messenger.s(String.format("%.2f%%", 100.0 * ratio), color);
        String spacing = " ";
        class_2554 firstLine = Messenger.c(tooltip.get(0), spacing, fillLevelText);
        class_327 textRenderer = class_310.method_1551().field_1772;
        ToIntFunction<class_2561> textLenCalc = text -> textRenderer.method_27525((class_5348)text);
        int maxWidth = tooltip.stream().mapToInt(textLenCalc).max().orElse(0);
        do {
            siblings = firstLine.method_10855();
            spacing = spacing + " ";
            prevSpacing = (class_2561)siblings.get(1);
            siblings.set(1, Messenger.s(spacing));
        } while (textLenCalc.applyAsInt((class_2561)firstLine) <= maxWidth);
        siblings.set(1, prevSpacing);
        tooltip.set(0, (class_2561)firstLine);
    }
}

