/*
 * Decompiled with CFR 0.152.
 */
package me.fallenbreath.tweakermore.impl.features.safeAfk;

import java.text.SimpleDateFormat;
import java.util.Date;
import me.fallenbreath.tweakermore.config.TweakerMoreConfigs;
import me.fallenbreath.tweakermore.util.Messenger;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_419;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_500;
import net.minecraft.class_5250;

public class SafeAfkHelper {
    private static long lastHurtMs = 0L;
    private static final long MAX_TIME_WAIT = 15000L;

    public static void resetHurtTime() {
        lastHurtMs = -15000L;
    }

    public static void recordHurtTime() {
        lastHurtMs = System.currentTimeMillis();
    }

    public static boolean hasRecord() {
        return System.currentTimeMillis() - lastHurtMs <= 15000L;
    }

    public static void onHealthUpdate(class_310 mc) {
        if (TweakerMoreConfigs.SAFE_AFK.getBooleanValue() && mc.field_1724 != null && mc.field_1687 != null && SafeAfkHelper.hasRecord()) {
            float health = mc.field_1724.method_6032();
            float maxHealth = mc.field_1724.method_6063();
            if (maxHealth > 0.0f && (double)health < TweakerMoreConfigs.SAFE_AFK_HEALTH_THRESHOLD.getDoubleValue()) {
                class_5250 title = Messenger.s("TweakerMore " + TweakerMoreConfigs.SAFE_AFK.getPrettyName());
                class_5250 reason = Messenger.tr("tweakermore.impl.safeAfk.received_damage", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()), String.format("%.1f / %.1f (%.0f%%)", Float.valueOf(health), Float.valueOf(maxHealth), Float.valueOf(health / maxHealth * 100.0f)));
                SafeAfkHelper.resetHurtTime();
                mc.execute(() -> {
                    mc.field_1687.method_8525((class_2561)class_2561.method_43471((String)"multiplayer.status.quitting"));
                    mc.method_72100();
                    mc.method_1507((class_437)new class_419((class_437)new class_500((class_437)new class_442()), (class_2561)title, (class_2561)reason));
                });
            }
        }
    }

    public static void onEntityEnterDamageStatus(class_1309 livingEntity) {
        if (TweakerMoreConfigs.SAFE_AFK.getBooleanValue()) {
            class_310 mc = class_310.method_1551();
            if (livingEntity == mc.field_1724 && mc.field_1687 != null) {
                SafeAfkHelper.recordHurtTime();
            }
        }
    }
}

